## Open API Integration in Aries JAX-RS Whiteboard

### The OpenAPI service

The Open API integration in Aries JAX-RS Whiteboard begins by creating a service of type `io.swagger.v3.oas.models.OpenAPI`.

e.g. using **Declarative Services**
```java
@Component(service = OpenAPI.class)
public class MyOpenAPI extends OpenAPI {

    public MyOpenAPI() {
        super();

        info(
            new Info()
                .title("My Service")
                .description("Service REST API")
                .contact(
                    new Contact()
                        .email("me@me.com")
        );
    }

}
```

The service properties which are currently supported are:

- `cache.ttl` - Corresponds to the method `io.swagger.v3.oas.integration.SwaggerConfiguration.setCacheTTL(Long cacheTTL)`
- `id` - Corresponds to the method `io.swagger.v3.oas.integration.SwaggerConfiguration.id(String id)`
- `ignored.routes` - Corresponds to the method `io.swagger.v3.oas.integration.SwaggerConfiguration.setIgnoredRoutes(Collection<String> ignoredRoutes)`
- `pretty.print` - Corresponds to the method `io.swagger.v3.oas.integration.SwaggerConfiguration.setPrettyPrint(Boolean prettyPrint)`
- `read.all.resources` - Corresponds to the method `io.swagger.v3.oas.integration.SwaggerConfiguration.setReadAllResources(Boolean readAllResources)`

The following properties are automatically applied when creating the resource from this service instance:

- `org.apache.aries.jax.rs.whiteboard.application.scoped=true` - indicating that Aries JAX-RS will scope prototype instance to matching applications
- `osgi.jaxrs.resource=true` - indicating that the produced service is a JAX-RS resource

Further service properties that are supplied by the `OpenAPI` service will propagate onto the generated resource service supporting various details such as `osgi.jaxrs.application.select`, etc.

Once the OpenAPI service is deployed some automatically generated schema metadata should be available at the URL `<application.base>/openapi.[json|yaml]`.

### Customizing OpenAPI metadata for resources

Chances are good that at least some of the autogenerated schema information is correct. It is also quite likely that it requires further customization. This is done by using Open API, Swagger or JAX-B annotations on the resources and types provided/supported by the API.

Please review the [Swagger annotation documentation](https://github.com/swagger-api/swagger-core/wiki/Swagger-2.X---Annotations) for the most up to date details.

However here is a simple example:

```java
@GET
@Operation(
    summary = "Get users",
    description = "Get list of users"
)
public Response getUsers() {..}
```

The extra information provided by the `@Operation` will enhance the generated schema.

For more complex examples of advanced schema definitions take a look at the resources in [integrations/rest-management/rest-management/src/main/java/org/apache/aries/jax/rs/rest/management/internal](integrations/rest-management/rest-management/src/main/java/org/apache/aries/jax/rs/rest/management/internal).