/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.core.internal.AbstractRequirement;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.osgi.service.subsystem.SubsystemException;

public class OsgiIdentityRequirement
extends AbstractRequirement {
    private final Map<String, String> directives = new HashMap<String, String>();
    private final Resource resource;
    private final boolean transitive;

    private static Filter createFilter(String symbolicName, Version version, String type) {
        return OsgiIdentityRequirement.createFilter(symbolicName, '(' + "version" + '=' + version + ')', type);
    }

    private static Filter createFilter(String symbolicName, VersionRange versionRange, String type) {
        return OsgiIdentityRequirement.createFilter(symbolicName, versionRange.toFilterString("version"), type);
    }

    private static Filter createFilter(Resource resource) {
        Map attributes = ((Capability)resource.getCapabilities("osgi.identity").get(0)).getAttributes();
        String symbolicName = String.valueOf(attributes.get("osgi.identity"));
        Version version = Version.parseVersion((String)String.valueOf(attributes.get("version")));
        String type = String.valueOf(attributes.get("type"));
        return OsgiIdentityRequirement.createFilter(symbolicName, version, type);
    }

    private static Filter createFilter(String symbolicName, String versionFilter, String type) {
        try {
            return FrameworkUtil.createFilter((String)OsgiIdentityRequirement.createFilterString(symbolicName, versionFilter, type));
        }
        catch (InvalidSyntaxException e) {
            throw new SubsystemException(e);
        }
    }

    private static String createFilterString(String symbolicName, String versionFilter, String type) {
        return "(&(" + "osgi.identity" + '=' + symbolicName + ')' + versionFilter + '(' + "type" + '=' + type + "))";
    }

    public OsgiIdentityRequirement(String symbolicName, VersionRange versionRange, String type, boolean transitive) {
        this(OsgiIdentityRequirement.createFilter(symbolicName, versionRange, type), null, transitive);
    }

    public OsgiIdentityRequirement(String symbolicName, Version version, String type, boolean transitive) {
        this(OsgiIdentityRequirement.createFilter(symbolicName, version, type), null, transitive);
    }

    public OsgiIdentityRequirement(Resource resource, boolean transitive) {
        this(OsgiIdentityRequirement.createFilter(resource), resource, transitive);
    }

    private OsgiIdentityRequirement(Filter filter, Resource resource, boolean transitive) {
        this.resource = resource;
        this.transitive = transitive;
        this.directives.put("filter", filter.toString());
    }

    public Map<String, Object> getAttributes() {
        return Collections.emptyMap();
    }

    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }

    public String getNamespace() {
        return "osgi.identity";
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean isTransitiveDependency() {
        return this.transitive;
    }
}

