/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ILSMIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.common.EnforcedIndexCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public abstract class LSMBTreeWithBuddyAbstractCursor
extends EnforcedIndexCursor
implements ILSMIndexCursor {
    protected boolean open;
    protected BTreeRangeSearchCursor[] btreeCursors;
    protected BTreeRangeSearchCursor[] buddyBtreeCursors;
    protected BTree.BTreeAccessor[] btreeAccessors;
    protected BTree.BTreeAccessor[] buddyBtreeAccessors;
    protected BloomFilter[] buddyBtreeBloomFilters;
    protected MultiComparator btreeCmp;
    protected MultiComparator buddyBtreeCmp;
    protected int numberOfTrees;
    protected RangePredicate btreeRangePredicate;
    protected RangePredicate buddyBtreeRangePredicate;
    protected ITupleReference frameTuple;
    protected boolean includeMutableComponent;
    protected ILSMHarness lsmHarness;
    protected boolean foundNext;
    protected final ILSMIndexOperationContext opCtx;
    protected final IIndexAccessParameters iap;
    protected final long[] hashes = BloomFilter.createHashArray();
    protected List<ILSMComponent> operationalComponents;

    public LSMBTreeWithBuddyAbstractCursor(ILSMIndexOperationContext opCtx, IIndexCursorStats stats) {
        this.opCtx = opCtx;
        this.iap = IndexAccessParameters.createNoOpParams((IIndexCursorStats)stats);
        this.buddyBtreeRangePredicate = new RangePredicate(null, null, true, true, null, null);
    }

    public ITreeIndexCursor getCursor(int cursorIndex) {
        return this.btreeCursors[cursorIndex];
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMBTreeWithBuddyCursorInitialState lsmInitialState = (LSMBTreeWithBuddyCursorInitialState)initialState;
        this.btreeCmp = lsmInitialState.getBTreeCmp();
        this.buddyBtreeCmp = lsmInitialState.getBuddyBTreeCmp();
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = lsmInitialState.getLSMHarness();
        this.numberOfTrees = this.operationalComponents.size();
        if (this.btreeCursors == null || this.btreeCursors.length != this.numberOfTrees) {
            this.btreeCursors = new BTreeRangeSearchCursor[this.numberOfTrees];
            this.buddyBtreeCursors = new BTreeRangeSearchCursor[this.numberOfTrees];
            this.btreeAccessors = new BTree.BTreeAccessor[this.numberOfTrees];
            this.buddyBtreeAccessors = new BTree.BTreeAccessor[this.numberOfTrees];
            this.buddyBtreeBloomFilters = new BloomFilter[this.numberOfTrees];
        }
        this.includeMutableComponent = false;
        for (int i = 0; i < this.numberOfTrees; ++i) {
            BTree buddyBtree;
            BTree btree;
            ILSMComponent component = this.operationalComponents.get(i);
            if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                this.includeMutableComponent = true;
                if (this.buddyBtreeCursors[i] == null) {
                    this.buddyBtreeCursors[i] = new BTreeRangeSearchCursor((IBTreeLeafFrame)lsmInitialState.getBuddyBTreeLeafFrameFactory().createFrame(), false);
                } else {
                    this.buddyBtreeCursors[i].close();
                }
                btree = ((LSMBTreeWithBuddyMemoryComponent)component).getIndex();
                buddyBtree = ((LSMBTreeWithBuddyMemoryComponent)component).getBuddyIndex();
                this.buddyBtreeBloomFilters[i] = null;
            } else {
                if (this.buddyBtreeCursors[i] == null) {
                    this.buddyBtreeCursors[i] = new BTreeRangeSearchCursor((IBTreeLeafFrame)lsmInitialState.getBuddyBTreeLeafFrameFactory().createFrame(), false);
                } else {
                    this.buddyBtreeCursors[i].close();
                }
                btree = ((LSMBTreeWithBuddyDiskComponent)component).getIndex();
                buddyBtree = ((LSMBTreeWithBuddyDiskComponent)component).getBuddyIndex();
                this.buddyBtreeBloomFilters[i] = ((LSMBTreeWithBuddyDiskComponent)component).getBloomFilter();
            }
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)lsmInitialState.getBTreeLeafFrameFactory().createFrame();
            if (this.btreeAccessors[i] == null) {
                this.btreeCursors[i] = new BTreeRangeSearchCursor(leafFrame, false);
                this.btreeAccessors[i] = btree.createAccessor(this.iap);
                this.buddyBtreeAccessors[i] = buddyBtree.createAccessor(this.iap);
                continue;
            }
            this.btreeCursors[i].close();
            this.btreeAccessors[i].reset(btree, this.iap);
            this.buddyBtreeAccessors[i].reset(buddyBtree, this.iap);
        }
        this.btreeRangePredicate = (RangePredicate)searchPred;
        this.buddyBtreeRangePredicate.reset(null, null, true, true, this.buddyBtreeCmp, this.buddyBtreeCmp);
        this.open = true;
    }

    public void doDestroy() throws HyracksDataException {
        if (!this.open) {
            return;
        }
        try {
            if (this.btreeCursors != null && this.buddyBtreeCursors != null) {
                for (int i = 0; i < this.numberOfTrees; ++i) {
                    this.btreeCursors[i].destroy();
                    this.buddyBtreeCursors[i].destroy();
                }
            }
            this.btreeCursors = null;
            this.buddyBtreeCursors = null;
        }
        finally {
            this.lsmHarness.endSearch(this.opCtx);
        }
        this.foundNext = false;
        this.open = false;
    }

    public ITupleReference doGetTuple() {
        return this.frameTuple;
    }

    public boolean getSearchOperationCallbackProceedResult() {
        return false;
    }
}

