/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.misc;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import org.apache.hyracks.dataflow.std.misc.MaterializerTaskState;

public class MaterializingOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private static final int MATERIALIZER_ACTIVITY_ID = 0;
    private static final int READER_ACTIVITY_ID = 1;
    private static final int MATERIALIZER_READER_ACTIVITY_ID = 2;
    private boolean isSingleActivity;

    public MaterializingOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor recordDescriptor) {
        this(spec, recordDescriptor, false);
    }

    public MaterializingOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor recordDescriptor, boolean isSingleActivity) {
        super(spec, 1, 1);
        this.outRecDescs[0] = recordDescriptor;
        this.isSingleActivity = isSingleActivity;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        if (this.isSingleActivity) {
            MaterializerReaderActivityNode mra = new MaterializerReaderActivityNode(new ActivityId(this.odId, 2));
            builder.addActivity((IOperatorDescriptor)this, (IActivity)mra);
            builder.addSourceEdge(0, (IActivity)mra, 0);
            builder.addTargetEdge(0, (IActivity)mra, 0);
        } else {
            MaterializerActivityNode ma = new MaterializerActivityNode(new ActivityId(this.odId, 0));
            ReaderActivityNode ra = new ReaderActivityNode(new ActivityId(this.odId, 1));
            builder.addActivity((IOperatorDescriptor)this, (IActivity)ma);
            builder.addSourceEdge(0, (IActivity)ma, 0);
            builder.addActivity((IOperatorDescriptor)this, (IActivity)ra);
            builder.addTargetEdge(0, (IActivity)ra, 0);
            builder.addBlockingEdge((IActivity)ma, (IActivity)ra);
        }
    }

    private final class ReaderActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public ReaderActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            return new AbstractUnaryOutputSourceOperatorNodePushable(){

                @Override
                public void initialize() throws HyracksDataException {
                    MaterializerTaskState state = (MaterializerTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(MaterializingOperatorDescriptor.this.getOperatorId(), 0), partition));
                    state.writeOut(this.writer, (IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx), false);
                }

                @Override
                public void deinitialize() throws HyracksDataException {
                }
            };
        }
    }

    private final class MaterializerActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public MaterializerActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            return new AbstractUnaryInputSinkOperatorNodePushable(){
                private MaterializerTaskState state;

                public void open() throws HyracksDataException {
                    this.state = new MaterializerTaskState(ctx.getJobletContext().getJobId(), new TaskId(MaterializerActivityNode.this.getActivityId(), partition));
                    this.state.open(ctx);
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.appendFrame(buffer);
                }

                public void close() throws HyracksDataException {
                    this.state.close();
                    ctx.setStateObject((IStateObject)this.state);
                }

                public void fail() throws HyracksDataException {
                }
            };
        }
    }

    private final class MaterializerReaderActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public MaterializerReaderActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            return new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
                private MaterializerTaskState state;
                private boolean failed = false;

                public void open() throws HyracksDataException {
                    this.state = new MaterializerTaskState(ctx.getJobletContext().getJobId(), new TaskId(MaterializerReaderActivityNode.this.getActivityId(), partition));
                    this.state.open(ctx);
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.appendFrame(buffer);
                }

                public void fail() throws HyracksDataException {
                    this.failed = true;
                }

                public void close() throws HyracksDataException {
                    this.state.close();
                    this.state.writeOut(this.writer, (IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx), this.failed);
                }
            };
        }
    }
}

