/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.partitions;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.partitions.IPartition;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.common.job.PartitionState;
import org.apache.hyracks.control.nc.partitions.PartitionManager;

public class PipelinedPartition
implements IFrameWriter,
IPartition {
    private final IHyracksTaskContext ctx;
    private final PartitionManager manager;
    private final PartitionId pid;
    private final TaskAttemptId taId;
    private IFrameWriter delegate;
    private volatile boolean pendingConnection = true;

    public PipelinedPartition(IHyracksTaskContext ctx, PartitionManager manager, PartitionId pid, TaskAttemptId taId) {
        this.ctx = ctx;
        this.manager = manager;
        this.pid = pid;
        this.taId = taId;
    }

    public IHyracksTaskContext getTaskContext() {
        return this.ctx;
    }

    public boolean isReusable() {
        return false;
    }

    public void deallocate() {
    }

    public synchronized void writeTo(IFrameWriter writer) {
        this.delegate = writer;
        this.notifyAll();
    }

    public void open() throws HyracksDataException {
        this.manager.registerPartition(this.pid, this.ctx.getJobletContext().getJobId().getCcId(), this.taId, this, PartitionState.STARTED, false);
        this.pendingConnection = true;
        this.ensureConnected();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.delegate.nextFrame(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureConnected() throws HyracksDataException {
        if (this.pendingConnection) {
            PipelinedPartition pipelinedPartition = this;
            synchronized (pipelinedPartition) {
                while (this.delegate == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw HyracksDataException.create((Throwable)e);
                    }
                }
            }
            this.delegate.open();
        }
        this.pendingConnection = false;
    }

    public void fail() throws HyracksDataException {
        if (!this.pendingConnection) {
            this.delegate.fail();
        }
    }

    public void close() throws HyracksDataException {
        if (!this.pendingConnection) {
            this.delegate.close();
        }
    }

    public void flush() throws HyracksDataException {
        if (!this.pendingConnection) {
            this.delegate.flush();
        }
    }
}

