/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer.jsonwrapper;

import com.azure.core.implementation.serializer.jsonwrapper.api.Config;
import com.azure.core.implementation.serializer.jsonwrapper.api.JsonApi;
import com.azure.core.implementation.serializer.jsonwrapper.spi.JsonPlugin;
import java.util.ServiceLoader;

public class JsonWrapper {
    private static final ServiceLoader<JsonPlugin> PLUGIN_LOADER = ServiceLoader.load(JsonPlugin.class);

    public static JsonApi newInstance() {
        JsonApi jsonApi = JsonWrapper.newInstance((Class<? extends JsonApi>)null);
        jsonApi.configure(Config.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonApi.configureTimezone();
        return jsonApi;
    }

    public static JsonApi newInstance(String type) throws ClassNotFoundException {
        Class<?> cls = Class.forName(type);
        return JsonWrapper.newInstance(cls);
    }

    public static JsonApi newInstance(Class<? extends JsonApi> type) {
        for (JsonPlugin plugin : PLUGIN_LOADER) {
            if (type != null && !plugin.getType().equals(type)) continue;
            JsonApi jsonApi = plugin.newInstance();
            jsonApi.configure(Config.FAIL_ON_UNKNOWN_PROPERTIES, false);
            jsonApi.configureTimezone();
            return jsonApi;
        }
        return null;
    }
}

