/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingTupleReference;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.util.trace.ITracer;

public abstract class AbstractLSMIndexOperationContext
implements ILSMIndexOperationContext {
    protected final ILSMIndex index;
    protected final PermutingTupleReference indexTuple;
    protected final MultiComparator filterCmp;
    protected final PermutingTupleReference filterTuple;
    protected final List<ILSMComponent> componentHolder;
    protected final List<ILSMDiskComponent> componentsToBeMerged;
    protected final List<ILSMDiskComponent> componentsToBeReplicated;
    protected final ISearchOperationCallback searchCallback;
    protected final IExtendedModificationOperationCallback modificationCallback;
    protected IndexOperation op;
    protected boolean accessingComponents = false;
    protected ISearchPredicate searchPredicate;
    protected final ITracer tracer;
    protected final long traceCategory;
    private long enterExitTime = 0L;
    protected boolean skipFilter = false;
    protected boolean recovery = false;
    private ILSMIOOperation ioOperation;
    private Map<String, Object> parametersMap;

    public AbstractLSMIndexOperationContext(ILSMIndex index, int[] treeFields, int[] filterFields, IBinaryComparatorFactory[] filterCmpFactories, ISearchOperationCallback searchCallback, IExtendedModificationOperationCallback modificationCallback, ITracer tracer) {
        this.index = index;
        this.searchCallback = searchCallback;
        this.modificationCallback = modificationCallback;
        this.componentHolder = new ArrayList<ILSMComponent>();
        this.componentsToBeMerged = new ArrayList<ILSMDiskComponent>();
        this.componentsToBeReplicated = new ArrayList<ILSMDiskComponent>();
        if (filterFields != null) {
            this.indexTuple = new PermutingTupleReference(treeFields);
            this.filterCmp = MultiComparator.create((IBinaryComparatorFactory[])filterCmpFactories);
            this.filterTuple = new PermutingTupleReference(filterFields);
        } else {
            this.indexTuple = null;
            this.filterCmp = null;
            this.filterTuple = null;
        }
        this.tracer = tracer;
        this.traceCategory = tracer.getRegistry().get("IndexOperations");
    }

    @Override
    public boolean isAccessingComponents() {
        return this.accessingComponents;
    }

    @Override
    public void setAccessingComponents(boolean accessingComponents) {
        this.accessingComponents = accessingComponents;
    }

    @Override
    public final PermutingTupleReference getIndexTuple() {
        return this.indexTuple;
    }

    @Override
    public final PermutingTupleReference getFilterTuple() {
        return this.filterTuple;
    }

    @Override
    public final MultiComparator getFilterCmp() {
        return this.filterCmp;
    }

    public void reset() {
        this.accessingComponents = false;
        this.componentHolder.clear();
        this.componentsToBeMerged.clear();
        this.componentsToBeReplicated.clear();
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    @Override
    public List<ILSMComponent> getComponentHolder() {
        return this.componentHolder;
    }

    @Override
    public ISearchOperationCallback getSearchOperationCallback() {
        return this.searchCallback;
    }

    @Override
    public IExtendedModificationOperationCallback getModificationCallback() {
        return this.modificationCallback;
    }

    @Override
    public List<ILSMDiskComponent> getComponentsToBeMerged() {
        return this.componentsToBeMerged;
    }

    @Override
    public List<ILSMDiskComponent> getComponentsToBeReplicated() {
        return this.componentsToBeReplicated;
    }

    public void setOperation(IndexOperation newOp) throws HyracksDataException {
        this.reset();
        this.op = newOp;
    }

    @Override
    public void setSearchPredicate(ISearchPredicate searchPredicate) {
        this.searchPredicate = searchPredicate;
    }

    @Override
    public ISearchPredicate getSearchPredicate() {
        return this.searchPredicate;
    }

    @Override
    public final boolean isTracingEnabled() {
        return this.tracer.isEnabled(this.traceCategory);
    }

    @Override
    public void logPerformanceCounters(int tupleCount) {
        if (this.isTracingEnabled()) {
            this.tracer.instant("store-counters", this.traceCategory, ITracer.Scope.t, "{\"count\":" + tupleCount + ",\"enter-exit-duration-ns\":" + this.enterExitTime + "}");
            this.resetCounters();
        }
    }

    public void resetCounters() {
        this.enterExitTime = 0L;
    }

    @Override
    public void incrementEnterExitTime(long increment) {
        this.enterExitTime += increment;
    }

    @Override
    public ILSMIndex getIndex() {
        return this.index;
    }

    @Override
    public boolean isFilterSkipped() {
        return this.skipFilter;
    }

    @Override
    public void setFilterSkip(boolean skip) {
        this.skipFilter = skip;
    }

    @Override
    public boolean isRecovery() {
        return this.recovery;
    }

    @Override
    public void setRecovery(boolean recovery) {
        this.recovery = recovery;
    }

    @Override
    public ILSMIOOperation getIoOperation() {
        return this.ioOperation;
    }

    @Override
    public void setIoOperation(ILSMIOOperation ioOperation) {
        this.ioOperation = ioOperation;
    }

    @Override
    public void setParameters(Map<String, Object> map) {
        this.parametersMap = map;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parametersMap;
    }
}

