/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;

public class LSMBTreeWithBuddyDiskComponentFactory
implements ILSMDiskComponentFactory {
    protected final TreeIndexFactory<BTree> btreeFactory;
    protected final IComponentFilterHelper filterHelper;
    protected final BloomFilterFactory bloomFilterFactory;
    protected final TreeIndexFactory<BTree> buddyBtreeFactory;

    public LSMBTreeWithBuddyDiskComponentFactory(TreeIndexFactory<BTree> btreeFactory, TreeIndexFactory<BTree> buddyBtreeFactory, BloomFilterFactory bloomFilterFactory, IComponentFilterHelper filterHelper) {
        this.btreeFactory = btreeFactory;
        this.filterHelper = filterHelper;
        this.bloomFilterFactory = bloomFilterFactory;
        this.buddyBtreeFactory = buddyBtreeFactory;
    }

    public int[] getBloomFilterKeyFields() {
        return this.bloomFilterFactory == null ? null : this.bloomFilterFactory.getBloomFilterKeyFields();
    }

    public LSMBTreeWithBuddyDiskComponent createComponent(AbstractLSMIndex lsmIndex, LSMComponentFileReferences cfr) throws HyracksDataException {
        return new LSMBTreeWithBuddyDiskComponent(lsmIndex, (BTree)this.btreeFactory.createIndexInstance(cfr.getInsertIndexFileReference()), (BTree)this.buddyBtreeFactory.createIndexInstance(cfr.getDeleteIndexFileReference()), this.bloomFilterFactory.createBloomFiltertInstance(cfr.getBloomFilterFileReference()), this.filterHelper == null ? null : this.filterHelper.createFilter());
    }
}

