/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.abstracts;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.asterix.external.input.stream.AbstractMultipleInputStream;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractExternalInputStream
extends AbstractMultipleInputStream {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Map<String, String> configuration;
    protected final List<String> filePaths;
    protected int nextFileIndex = 0;

    public AbstractExternalInputStream(Map<String, String> configuration, List<String> filePaths) {
        this.configuration = configuration;
        this.filePaths = filePaths;
    }

    @Override
    protected boolean advance() throws IOException {
        if (this.filePaths == null || this.filePaths.isEmpty()) {
            return false;
        }
        if (this.nextFileIndex >= this.filePaths.size()) {
            return false;
        }
        if (this.in != null) {
            CleanupUtils.close((AutoCloseable)this.in, null);
        }
        boolean isAvailableStream = this.getInputStream();
        ++this.nextFileIndex;
        if (!isAvailableStream) {
            return this.advance();
        }
        if (this.notificationHandler != null) {
            this.notificationHandler.notifyNewSource();
        }
        return true;
    }

    protected abstract boolean getInputStream() throws IOException;

    @Override
    public boolean stop() {
        return false;
    }

    @Override
    public boolean handleException(Throwable th) {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            CleanupUtils.close((AutoCloseable)this.in, null);
        }
    }

    @Override
    public String getStreamName() {
        return this.getStreamNameAt(this.nextFileIndex - 1);
    }

    @Override
    public String getPreviousStreamName() {
        return this.getStreamNameAt(this.nextFileIndex - 2);
    }

    private String getStreamNameAt(int fileIndex) {
        return fileIndex < 0 || this.filePaths == null || this.filePaths.isEmpty() ? "" : this.filePaths.get(fileIndex);
    }
}

