/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IFunctionHelper;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.library.JTypeObjectFactory;
import org.apache.asterix.external.library.JavaTypeInfo;
import org.apache.asterix.external.library.java.JObjectPointableVisitor;
import org.apache.asterix.external.library.java.JTypeTag;
import org.apache.asterix.external.library.java.base.JNull;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IDataOutputProvider;
import org.apache.hyracks.data.std.api.IValueReference;

public class JavaFunctionHelper
implements IFunctionHelper {
    private final IExternalFunctionInfo finfo;
    private final IDataOutputProvider outputProvider;
    private final IJObject[] arguments;
    private IJObject resultHolder;
    private final IObjectPool<IJObject, IAType> objectPool = new ListObjectPool((IObjectFactory)JTypeObjectFactory.INSTANCE);
    private final JObjectPointableVisitor pointableVisitor;
    private final PointableAllocator pointableAllocator;
    private final Map<Integer, JavaTypeInfo> poolTypeInfo;
    private final Map<String, String> parameters;
    private final IAType[] argTypes;
    private boolean isValidResult = false;

    JavaFunctionHelper(IExternalFunctionInfo finfo, IAType[] argTypes, IDataOutputProvider outputProvider) {
        this.finfo = finfo;
        this.outputProvider = outputProvider;
        this.pointableVisitor = new JObjectPointableVisitor();
        this.pointableAllocator = new PointableAllocator();
        this.arguments = new IJObject[finfo.getParameterTypes().size()];
        int index = 0;
        for (IAType param : finfo.getParameterTypes()) {
            this.arguments[index++] = (IJObject)this.objectPool.allocate((Object)param);
        }
        this.resultHolder = (IJObject)this.objectPool.allocate((Object)finfo.getReturnType());
        this.poolTypeInfo = new HashMap<Integer, JavaTypeInfo>();
        this.parameters = finfo.getResources();
        this.argTypes = argTypes;
    }

    @Override
    public IJObject getArgument(int index) {
        return this.arguments[index];
    }

    @Override
    public void setResult(IJObject result) throws HyracksDataException {
        if (result == null || this.checkInvalidReturnValueType(result, this.finfo.getReturnType())) {
            this.isValidResult = false;
        } else {
            this.isValidResult = true;
            result.serialize(this.outputProvider.getDataOutput(), true);
            result.reset();
        }
    }

    private boolean checkInvalidReturnValueType(IJObject result, IAType expectedType) {
        if (expectedType.equals(BuiltinType.ANY)) {
            return false;
        }
        return !expectedType.deepEqual((IAObject)result.getIAType());
    }

    @Override
    public boolean isValidResult() {
        return this.isValidResult;
    }

    void setArgument(int index, IValueReference valueReference) throws IOException {
        IJObject jObject;
        IAType type = this.argTypes[index];
        block0 : switch (type.getTypeTag()) {
            case OBJECT: {
                ARecordVisitablePointable pointable = this.pointableAllocator.allocateRecordValue(type);
                pointable.set(valueReference);
                jObject = this.pointableVisitor.visit(pointable, this.getTypeInfo(index, type));
                break;
            }
            case ARRAY: 
            case MULTISET: {
                AListVisitablePointable pointable = this.pointableAllocator.allocateListValue(type);
                pointable.set(valueReference);
                jObject = this.pointableVisitor.visit(pointable, this.getTypeInfo(index, type));
                break;
            }
            case ANY: {
                ATypeTag rtTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(valueReference.getByteArray()[valueReference.getStartOffset()]);
                IAType rtType = TypeTagUtil.getBuiltinTypeByTag((ATypeTag)rtTypeTag);
                switch (rtTypeTag) {
                    case OBJECT: {
                        ARecordVisitablePointable pointable = this.pointableAllocator.allocateRecordValue(rtType);
                        pointable.set(valueReference);
                        jObject = this.pointableVisitor.visit(pointable, this.getTypeInfo(index, rtType));
                        break block0;
                    }
                    case ARRAY: 
                    case MULTISET: {
                        AListVisitablePointable pointable = this.pointableAllocator.allocateListValue(rtType);
                        pointable.set(valueReference);
                        jObject = this.pointableVisitor.visit(pointable, this.getTypeInfo(index, rtType));
                        break block0;
                    }
                }
                IVisitablePointable pointable = this.pointableAllocator.allocateFieldValue(rtType);
                pointable.set(valueReference);
                jObject = this.pointableVisitor.visit((AFlatValuePointable)pointable, rtTypeTag, this.getTypeInfo(index, rtType));
                break;
            }
            default: {
                IVisitablePointable pointable = this.pointableAllocator.allocateFieldValue(type);
                pointable.set(valueReference);
                jObject = this.pointableVisitor.visit((AFlatValuePointable)pointable, this.getTypeInfo(index, type));
            }
        }
        this.arguments[index] = jObject;
    }

    private JavaTypeInfo getTypeInfo(int index, IAType type) {
        JavaTypeInfo typeInfo = this.poolTypeInfo.get(index);
        if (typeInfo == null) {
            typeInfo = new JavaTypeInfo(this.objectPool, type, type.getTypeTag());
            this.poolTypeInfo.put(index, typeInfo);
        }
        return typeInfo;
    }

    @Override
    public IJObject getResultObject() {
        if (this.resultHolder == null) {
            this.resultHolder = (IJObject)this.objectPool.allocate((Object)this.finfo.getReturnType());
        }
        return this.resultHolder;
    }

    @Override
    public IJObject getResultObject(IAType type) {
        if (this.resultHolder == null) {
            this.resultHolder = (IJObject)this.objectPool.allocate((Object)type);
        }
        return this.resultHolder;
    }

    @Override
    public IJObject getObject(JTypeTag jtypeTag) throws RuntimeDataException {
        IJObject retValue = null;
        switch (jtypeTag) {
            case INT: {
                retValue = (IJObject)this.objectPool.allocate((Object)BuiltinType.AINT32);
                break;
            }
            case STRING: {
                retValue = (IJObject)this.objectPool.allocate((Object)BuiltinType.ASTRING);
                break;
            }
            case DOUBLE: {
                retValue = (IJObject)this.objectPool.allocate((Object)BuiltinType.ADOUBLE);
                break;
            }
            case NULL: {
                retValue = JNull.INSTANCE;
                break;
            }
            default: {
                try {
                    throw new RuntimeDataException(ErrorCode.LIBRARY_JAVA_FUNCTION_HELPER_OBJ_TYPE_NOT_SUPPORTED, new Serializable[]{jtypeTag.name()});
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }
        }
        return retValue;
    }

    @Override
    public void reset() {
        this.pointableAllocator.reset();
        this.objectPool.reset();
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public List<String> getExternalIdentifier() {
        return this.finfo.getExternalIdentifier();
    }
}

