/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.NoOpIndexCursorStats;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class DiskBTreeRangeSearchCursor
extends BTreeRangeSearchCursor {
    public DiskBTreeRangeSearchCursor(IBTreeLeafFrame frame, boolean exclusiveLatchNodes) {
        this(frame, exclusiveLatchNodes, NoOpIndexCursorStats.INSTANCE);
    }

    protected DiskBTreeRangeSearchCursor(IBTreeLeafFrame frame, boolean exclusiveLatchNodes, IIndexCursorStats stats) {
        super(frame, exclusiveLatchNodes, stats);
    }

    @Override
    public boolean doHasNext() throws HyracksDataException {
        if (this.tupleIndex >= this.frame.getTupleCount()) {
            int nextLeafPage = this.frame.getNextLeaf();
            if (nextLeafPage >= 0) {
                this.fetchNextLeafPage(nextLeafPage);
                this.tupleIndex = 0;
                this.stopTupleIndex = this.getHighKeyIndex();
                if (this.stopTupleIndex < 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.tupleIndex > this.stopTupleIndex) {
            return false;
        }
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this.frame, this.tupleIndex);
        return true;
    }

    public ICachedPage getPage() {
        return this.page;
    }

    @Override
    protected void releasePage() throws HyracksDataException {
        this.bufferCache.unpin(this.page);
    }

    @Override
    protected ICachedPage acquirePage(int pageId) throws HyracksDataException {
        this.stats.getPageCounter().update(1L);
        return this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
    }
}

