/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.serde.AObjectSerializerDeserializer;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractTypeCheckEvaluator
implements IScalarEvaluator {
    protected static final AObjectSerializerDeserializer aObjectSerializerDeserializer = AObjectSerializerDeserializer.INSTANCE;
    protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected final DataOutput out = this.resultStorage.getDataOutput();
    protected final IPointable argPtr = new VoidPointable();
    protected final IScalarEvaluator eval;
    protected ABoolean res;
    private byte acceptedTypeTag;

    public AbstractTypeCheckEvaluator(IScalarEvaluator argEval, byte acceptedTypeTag) {
        this.acceptedTypeTag = acceptedTypeTag;
        this.eval = argEval;
    }

    public AbstractTypeCheckEvaluator(IScalarEvaluator argEval) {
        this.eval = argEval;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.eval.evaluate(tuple, this.argPtr);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr)) {
            return;
        }
        this.res = this.isMatch(this.argPtr.getByteArray()[this.argPtr.getStartOffset()]) ? ABoolean.TRUE : ABoolean.FALSE;
        this.resultStorage.reset();
        aObjectSerializerDeserializer.serialize((IAObject)this.res, this.out);
        result.set((IValueReference)this.resultStorage);
    }

    protected boolean isMatch(byte typeTag) {
        return typeTag == this.acceptedTypeTag;
    }
}

