/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.runtime.operators.DatasetStreamStats;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.api.job.profiling.IndexStats;
import org.apache.hyracks.api.job.profiling.OperatorStats;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.common.api.AbstractLSMWithBloomFilterDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;

public final class DatasetStreamStatsOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final String operatorName;
    private final IIndexDataflowHelperFactory[] indexes;
    private final String[] indexesNames;

    public DatasetStreamStatsOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor rDesc, String operatorName, IIndexDataflowHelperFactory[] indexes, String[] indexesNames) {
        super(spec, 1, 1);
        this.outRecDescs[0] = rDesc;
        this.operatorName = operatorName;
        this.indexes = indexes;
        this.indexesNames = indexesNames;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) throws HyracksDataException {
        return new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
            private FrameTupleAccessor fta;
            private long totalTupleCount;
            private long totalTupleLength;
            private Map<String, IndexStats> indexStats;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void open() throws HyracksDataException {
                this.fta = new FrameTupleAccessor(DatasetStreamStatsOperatorDescriptor.this.outRecDescs[0]);
                this.totalTupleCount = 0L;
                this.writer.open();
                IStatsCollector coll = ctx.getStatsCollector();
                if (coll != null) {
                    coll.add((IOperatorStats)new OperatorStats(DatasetStreamStatsOperatorDescriptor.this.operatorName, "ODID:-1"));
                }
                INCServiceContext serviceCtx = ctx.getJobletContext().getServiceContext();
                this.indexStats = new HashMap<String, IndexStats>();
                for (int i = 0; i < DatasetStreamStatsOperatorDescriptor.this.indexes.length; ++i) {
                    try (IIndexDataflowHelper idxFlowHelper = DatasetStreamStatsOperatorDescriptor.this.indexes[i].create(serviceCtx, partition);){
                        idxFlowHelper.open();
                        ILSMIndex indexInstance = (ILSMIndex)idxFlowHelper.getIndexInstance();
                        long numPages = 0L;
                        ILSMOperationTracker iLSMOperationTracker = indexInstance.getOperationTracker();
                        synchronized (iLSMOperationTracker) {
                            for (ILSMDiskComponent component : indexInstance.getDiskComponents()) {
                                long componentSize = component.getComponentSize();
                                if (component instanceof AbstractLSMWithBloomFilterDiskComponent) {
                                    componentSize -= ((AbstractLSMWithBloomFilterDiskComponent)component).getBloomFilter().getFileReference().getFile().length();
                                }
                                numPages += componentSize / (long)indexInstance.getBufferCache().getPageSize();
                            }
                        }
                        this.indexStats.put(DatasetStreamStatsOperatorDescriptor.this.indexesNames[i], new IndexStats(DatasetStreamStatsOperatorDescriptor.this.indexesNames[i], numPages));
                        continue;
                    }
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.fta.reset(buffer);
                this.computeStats();
                FrameUtils.flushFrame((ByteBuffer)buffer, (IFrameWriter)this.writer);
            }

            private void computeStats() {
                int n = this.fta.getTupleCount();
                this.totalTupleCount += (long)n;
                for (int i = 0; i < n; ++i) {
                    this.totalTupleLength += (long)this.fta.getTupleLength(i);
                }
            }

            public void fail() throws HyracksDataException {
                this.writer.fail();
            }

            public void close() throws HyracksDataException {
                IStatsCollector statsCollector = ctx.getStatsCollector();
                if (statsCollector != null) {
                    IOperatorStats stats = statsCollector.getOperatorStats(DatasetStreamStatsOperatorDescriptor.this.operatorName);
                    DatasetStreamStats.update(stats, this.totalTupleCount, this.totalTupleLength, this.indexStats);
                }
                this.writer.close();
            }

            public void flush() throws HyracksDataException {
                this.writer.flush();
            }

            public String getDisplayName() {
                return DatasetStreamStatsOperatorDescriptor.this.operatorName;
            }
        };
    }
}

