/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.server.BaseRequest;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class FormUrlEncodedRequest
extends BaseRequest
implements IServletRequest {
    public static IServletRequest create(ChannelHandlerContext ctx, FullHttpRequest request, HttpScheme scheme, boolean ignoreQueryParameters) {
        Charset charset = HttpUtil.getRequestCharset((HttpRequest)request);
        LinkedHashMap<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();
        URLEncodedUtils.parse((String)request.content().toString(charset), (Charset)charset).forEach(pair -> parameters.computeIfAbsent(pair.getName(), a -> new ArrayList()).add(pair.getValue()));
        if (!ignoreQueryParameters) {
            new QueryStringDecoder(request.uri()).parameters().forEach((name, value) -> parameters.computeIfAbsent((String)name, a -> new ArrayList()).addAll(value));
        }
        return new FormUrlEncodedRequest(ctx.channel(), request, (Map<String, List<String>>)parameters, scheme);
    }

    private FormUrlEncodedRequest(Channel channel, FullHttpRequest request, Map<String, List<String>> parameters, HttpScheme scheme) {
        super(channel, request, parameters, scheme);
    }
}

