/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.net.protocols.muxdemux;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.hyracks.api.comm.IChannelInterfaceFactory;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.net.protocols.muxdemux.ChannelControlBlock;
import org.apache.hyracks.net.protocols.muxdemux.IEventCounter;
import org.apache.hyracks.net.protocols.muxdemux.MultiplexedConnection;
import org.apache.hyracks.util.JSONUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChannelSet {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int INITIAL_SIZE = 16;
    private final MultiplexedConnection mConn;
    private ChannelControlBlock[] ccbArray;
    private final BitSet allocationBitmap;
    private final BitSet pendingChannelWriteBitmap;
    private final BitSet pendingChannelCreditsBitmap;
    private final BitSet pendingChannelSynBitmap;
    private final BitSet pendingEOSAckBitmap;
    private int openChannelCount;
    private final IEventCounter pendingWriteEventsCounter;

    ChannelSet(MultiplexedConnection mConn, IEventCounter pendingWriteEventsCounter) {
        this.mConn = mConn;
        this.ccbArray = new ChannelControlBlock[16];
        this.allocationBitmap = new BitSet();
        this.pendingChannelWriteBitmap = new BitSet();
        this.pendingChannelCreditsBitmap = new BitSet();
        this.pendingChannelSynBitmap = new BitSet();
        this.pendingEOSAckBitmap = new BitSet();
        this.pendingWriteEventsCounter = pendingWriteEventsCounter;
        this.openChannelCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChannelControlBlock allocateChannel() throws NetException {
        MultiplexedConnection multiplexedConnection = this.mConn;
        synchronized (multiplexedConnection) {
            this.cleanupClosedChannels();
            int idx = this.allocationBitmap.nextClearBit(0);
            if (idx < 0 || idx >= this.ccbArray.length) {
                this.cleanupClosedChannels();
                idx = this.allocationBitmap.nextClearBit(0);
                if (idx < 0 || idx == this.ccbArray.length) {
                    idx = this.ccbArray.length;
                }
            }
            return this.createChannel(idx);
        }
    }

    private void cleanupClosedChannels() {
        for (int i = 0; i < this.ccbArray.length; ++i) {
            ChannelControlBlock ccb = this.ccbArray[i];
            if (ccb == null || !ccb.completelyClosed()) continue;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Cleaning free channel: " + ccb);
            }
            this.freeChannel(ccb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChannelControlBlock registerChannel(int channelId) throws NetException {
        MultiplexedConnection multiplexedConnection = this.mConn;
        synchronized (multiplexedConnection) {
            return this.createChannel(channelId);
        }
    }

    private void freeChannel(ChannelControlBlock channel) {
        int idx = channel.getChannelId();
        this.ccbArray[idx] = null;
        this.allocationBitmap.clear(idx);
        this.pendingChannelWriteBitmap.clear(idx);
        this.pendingChannelCreditsBitmap.clear(idx);
        this.pendingChannelSynBitmap.clear(idx);
        this.pendingEOSAckBitmap.clear(idx);
        --this.openChannelCount;
    }

    ChannelControlBlock getCCB(int channelId) {
        return this.ccbArray[channelId];
    }

    BitSet getPendingChannelWriteBitmap() {
        return this.pendingChannelWriteBitmap;
    }

    BitSet getPendingChannelCreditsBitmap() {
        return this.pendingChannelCreditsBitmap;
    }

    BitSet getPendingChannelSynBitmap() {
        return this.pendingChannelSynBitmap;
    }

    BitSet getPendingEOSAckBitmap() {
        return this.pendingEOSAckBitmap;
    }

    int getOpenChannelCount() {
        return this.openChannelCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initiateChannelSyn(int channelId) {
        MultiplexedConnection multiplexedConnection = this.mConn;
        synchronized (multiplexedConnection) {
            assert (!this.pendingChannelSynBitmap.get(channelId));
            this.pendingChannelSynBitmap.set(channelId);
            this.pendingWriteEventsCounter.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPendingCredits(ChannelControlBlock targetCcb, int delta) {
        if (delta <= 0) {
            return;
        }
        MultiplexedConnection multiplexedConnection = this.mConn;
        synchronized (multiplexedConnection) {
            int channelId = targetCcb.getChannelId();
            ChannelControlBlock ccb = this.ccbArray[channelId];
            if (ccb == targetCcb) {
                if (ccb.getRemoteEOS()) {
                    return;
                }
                int oldCredits = ccb.getReadCredits();
                ccb.setReadCredits(oldCredits + delta);
                if (oldCredits == 0) {
                    assert (!this.pendingChannelCreditsBitmap.get(channelId));
                    this.pendingChannelCreditsBitmap.set(channelId);
                    this.pendingWriteEventsCounter.increment();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmarkPendingCredits(int channelId) {
        MultiplexedConnection multiplexedConnection = this.mConn;
        synchronized (multiplexedConnection) {
            if (this.pendingChannelCreditsBitmap.get(channelId)) {
                this.pendingChannelCreditsBitmap.clear(channelId);
                this.pendingWriteEventsCounter.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markPendingWrite(int channelId) {
        MultiplexedConnection multiplexedConnection = this.mConn;
        synchronized (multiplexedConnection) {
            assert (!this.pendingChannelWriteBitmap.get(channelId));
            this.pendingChannelWriteBitmap.set(channelId);
            this.pendingWriteEventsCounter.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmarkPendingWrite(int channelId) {
        MultiplexedConnection multiplexedConnection = this.mConn;
        synchronized (multiplexedConnection) {
            assert (this.pendingChannelWriteBitmap.get(channelId));
            this.pendingChannelWriteBitmap.clear(channelId);
            this.pendingWriteEventsCounter.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markEOSAck(int channelId) {
        MultiplexedConnection multiplexedConnection = this.mConn;
        synchronized (multiplexedConnection) {
            if (!this.pendingEOSAckBitmap.get(channelId)) {
                this.pendingEOSAckBitmap.set(channelId);
                this.pendingWriteEventsCounter.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyIOError() {
        MultiplexedConnection multiplexedConnection = this.mConn;
        synchronized (multiplexedConnection) {
            for (int i = 0; i < this.ccbArray.length; ++i) {
                ChannelControlBlock ccb = this.ccbArray[i];
                if (ccb == null) continue;
                ccb.reportRemoteError(-1);
                this.markEOSAck(i);
                this.unmarkPendingCredits(i);
            }
        }
    }

    private ChannelControlBlock createChannel(int idx) throws NetException {
        ChannelControlBlock channel;
        if (idx > 0x7FFFFFFE) {
            throw new NetException("Channel Id > 2147483646 being opened");
        }
        if (idx >= this.ccbArray.length) {
            this.expand(idx);
        }
        if (this.ccbArray[idx] != null) {
            assert (this.ccbArray[idx].completelyClosed()) : this.ccbArray[idx].toString();
            if (this.ccbArray[idx].completelyClosed()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Cleaning free channel: " + this.ccbArray[idx]);
                }
                this.freeChannel(this.ccbArray[idx]);
            }
        }
        assert (idx < this.ccbArray.length);
        assert (!this.allocationBitmap.get(idx));
        IChannelInterfaceFactory channelInterfaceFactory = this.mConn.getChannelInterfaceFactory();
        this.ccbArray[idx] = channel = new ChannelControlBlock(this, idx, channelInterfaceFactory);
        this.allocationBitmap.set(idx);
        ++this.openChannelCount;
        return channel;
    }

    private void expand(int idx) {
        while (idx >= this.ccbArray.length) {
            this.ccbArray = Arrays.copyOf(this.ccbArray, this.ccbArray.length * 2);
        }
    }

    public MultiplexedConnection getMultiplexedConnection() {
        return this.mConn;
    }

    public synchronized ArrayNode getState() {
        ArrayNode state = JSONUtil.createArray();
        for (ChannelControlBlock ccb : this.ccbArray) {
            if (ccb == null) continue;
            state.add(ccb.getState());
        }
        return state;
    }
}

