/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.management;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.replication.IPartitionReplica;
import org.apache.asterix.common.replication.IReplicationDestination;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.replication.IReplicationStrategyFactory;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.replication.api.ReplicationDestination;
import org.apache.asterix.replication.management.IndexReplicationManager;
import org.apache.asterix.replication.management.LogReplicationManager;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicationManager
implements IReplicationManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<InetSocketAddress, ReplicationDestination> dests = new HashMap<InetSocketAddress, ReplicationDestination>();
    private final ReplicationProperties replicationProperties;
    private final IReplicationStrategy strategy;
    private final INcApplicationContext appCtx;
    private final LogReplicationManager logReplicationManager;
    private final IndexReplicationManager lsnIndexReplicationManager;

    public ReplicationManager(INcApplicationContext appCtx, IReplicationStrategyFactory replicationStrategyFactory, ReplicationProperties replicationProperties) {
        this.replicationProperties = replicationProperties;
        this.appCtx = appCtx;
        this.strategy = replicationStrategyFactory.create(replicationProperties.getReplicationStrategy());
        this.logReplicationManager = new LogReplicationManager(appCtx, this);
        this.lsnIndexReplicationManager = new IndexReplicationManager(appCtx, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(IPartitionReplica replica) {
        Map<InetSocketAddress, ReplicationDestination> map = this.dests;
        synchronized (map) {
            InetSocketAddress location = NetworkUtil.ensureUnresolved((InetSocketAddress)replica.getIdentifier().getLocation());
            ReplicationDestination replicationDest = this.dests.computeIfAbsent(location, ReplicationDestination::at);
            replicationDest.add(replica);
            this.logReplicationManager.register(replicationDest);
            this.lsnIndexReplicationManager.register(replicationDest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IPartitionReplica replica) {
        Map<InetSocketAddress, ReplicationDestination> map = this.dests;
        synchronized (map) {
            InetSocketAddress location = NetworkUtil.ensureUnresolved((InetSocketAddress)replica.getIdentifier().getLocation());
            ReplicationDestination dest = this.dests.get(location);
            if (dest == null) {
                LOGGER.warn(() -> "Asked to unregister unknown replica " + replica);
                return;
            }
            LOGGER.info(() -> "unregister " + replica);
            dest.remove(replica);
            if (dest.getReplicas().isEmpty()) {
                LOGGER.info(() -> "Removing destination with no replicas " + dest);
                this.logReplicationManager.unregister(dest);
                this.lsnIndexReplicationManager.unregister(dest);
                this.dests.remove(location);
            }
        }
    }

    public void notifyFailure(IReplicationDestination dest, Exception failure) {
        LOGGER.info(() -> "processing failure for " + dest);
        this.appCtx.getThreadExecutor().execute(() -> {
            this.logReplicationManager.unregister(dest);
            this.lsnIndexReplicationManager.unregister(dest);
            dest.notifyFailure(failure);
        });
    }

    public void replicate(ILogRecord logRecord) throws InterruptedException {
        this.logReplicationManager.replicate(logRecord);
    }

    public IReplicationStrategy getReplicationStrategy() {
        return this.strategy;
    }

    public void submitJob(IReplicationJob job) {
        this.lsnIndexReplicationManager.accept(job);
    }

    public boolean isReplicationEnabled() {
        return this.replicationProperties.isReplicationEnabled();
    }

    public void start() {
    }

    public void dumpState(OutputStream os) {
    }

    public void stop(boolean dumpState, OutputStream ouputStream) throws IOException {
        LOGGER.info("Closing replication channel");
        this.appCtx.getReplicationChannel().close();
        LOGGER.info("Replication manager stopped");
    }
}

