/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.std;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hyracks.algebricks.data.IBinaryIntegerInspector;
import org.apache.hyracks.algebricks.data.IBinaryIntegerInspectorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.EvaluatorContext;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractReplicateOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputOperatorNodePushable;

public class SwitchOperatorDescriptor
extends AbstractReplicateOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    static final int SWITCHER_ACTIVITY_ID = 0;
    private final IScalarEvaluatorFactory branchingExprEvalFactory;
    private final IBinaryIntegerInspectorFactory intInspectorFactory;
    private final Map<Integer, int[]> outputMapping;

    public SwitchOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor rDesc, int outputArity, IScalarEvaluatorFactory branchingExprEvalFactory, IBinaryIntegerInspectorFactory intInspectorFactory, Map<Integer, int[]> outputMapping) {
        super(spec, rDesc, outputArity);
        if (outputArity != this.numberOfNonMaterializedOutputs) {
            throw new IllegalArgumentException();
        }
        this.branchingExprEvalFactory = branchingExprEvalFactory;
        this.intInspectorFactory = intInspectorFactory;
        this.outputMapping = outputMapping;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        SwitcherActivityNode sma = new SwitcherActivityNode(new ActivityId(this.odId, 0));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)sma);
        builder.addSourceEdge(0, (IActivity)sma, 0);
        for (int i = 0; i < this.outputArity; ++i) {
            builder.addTargetEdge(i, (IActivity)sma, i);
        }
    }

    private final class SwitcherActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public SwitcherActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
            final IFrameWriter[] writers = new IFrameWriter[SwitchOperatorDescriptor.this.outputArity];
            final boolean[] isOpen = new boolean[SwitchOperatorDescriptor.this.outputArity];
            VoidPointable p = VoidPointable.FACTORY.createPointable();
            final FrameTupleAccessor accessor = new FrameTupleAccessor(SwitchOperatorDescriptor.this.outRecDescs[0]);
            FrameTupleAppender[] appenders = new FrameTupleAppender[SwitchOperatorDescriptor.this.outputArity];
            final FrameTupleReference tRef = new FrameTupleReference();
            IBinaryIntegerInspector intInspector = SwitchOperatorDescriptor.this.intInspectorFactory.createBinaryIntegerInspector(ctx);
            EvaluatorContext evalCtx = new EvaluatorContext(ctx);
            final IScalarEvaluator eval = SwitchOperatorDescriptor.this.branchingExprEvalFactory.createScalarEvaluator(evalCtx);
            MutableBoolean hasFailed = new MutableBoolean(false);
            for (int i = 0; i < SwitchOperatorDescriptor.this.outputArity; ++i) {
                appenders[i] = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx), true);
            }
            return new AbstractUnaryInputOperatorNodePushable((IPointable)p, intInspector, appenders, hasFailed){
                final /* synthetic */ IPointable val$p;
                final /* synthetic */ IBinaryIntegerInspector val$intInspector;
                final /* synthetic */ FrameTupleAppender[] val$appenders;
                final /* synthetic */ MutableBoolean val$hasFailed;
                {
                    this.val$p = iPointable;
                    this.val$intInspector = iBinaryIntegerInspector;
                    this.val$appenders = frameTupleAppenderArray;
                    this.val$hasFailed = mutableBoolean;
                }

                public void open() throws HyracksDataException {
                    for (int i = 0; i < SwitchOperatorDescriptor.this.outputArity; ++i) {
                        isOpen[i] = true;
                        writers[i].open();
                    }
                }

                public void nextFrame(ByteBuffer bufferAccessor) throws HyracksDataException {
                    accessor.reset(bufferAccessor);
                    int tupleCount = accessor.getTupleCount();
                    for (int i = 0; i < tupleCount; ++i) {
                        int[] outputBranches;
                        tRef.reset((IFrameTupleAccessor)accessor, i);
                        eval.evaluate((IFrameTupleReference)tRef, this.val$p);
                        int fieldValue = this.val$intInspector.getIntegerValue(this.val$p.getByteArray(), this.val$p.getStartOffset(), this.val$p.getLength());
                        for (int j : outputBranches = SwitchOperatorDescriptor.this.outputMapping.get(fieldValue)) {
                            FrameUtils.appendToWriter((IFrameWriter)writers[j], (IFrameTupleAppender)this.val$appenders[j], (IFrameTupleAccessor)accessor, (int)i);
                        }
                    }
                }

                public void close() throws HyracksDataException {
                    int i;
                    Throwable hde = null;
                    if (!this.val$hasFailed.booleanValue()) {
                        for (i = 0; i < SwitchOperatorDescriptor.this.outputArity; ++i) {
                            if (!isOpen[i]) continue;
                            try {
                                this.val$appenders[i].write(writers[i], true);
                                continue;
                            }
                            catch (Throwable th) {
                                hde = th;
                                break;
                            }
                        }
                    }
                    if (hde != null) {
                        for (i = 0; i < SwitchOperatorDescriptor.this.outputArity; ++i) {
                            if (!isOpen[i]) continue;
                            CleanupUtils.fail((IFrameWriter)writers[i], (Throwable)hde);
                        }
                    }
                    for (i = 0; i < SwitchOperatorDescriptor.this.outputArity; ++i) {
                        if (!isOpen[i]) continue;
                        hde = CleanupUtils.close((IFrameWriter)writers[i], (Throwable)hde);
                    }
                    if (hde != null) {
                        throw HyracksDataException.create(hde);
                    }
                }

                public void fail() throws HyracksDataException {
                    this.val$hasFailed.setTrue();
                    HyracksDataException hde = null;
                    for (int i = 0; i < SwitchOperatorDescriptor.this.outputArity; ++i) {
                        if (!isOpen[i]) continue;
                        try {
                            writers[i].fail();
                            continue;
                        }
                        catch (Throwable th) {
                            if (hde == null) {
                                hde = HyracksDataException.create((Throwable)th);
                                continue;
                            }
                            hde.addSuppressed(th);
                        }
                    }
                    if (hde != null) {
                        throw hde;
                    }
                }

                public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) {
                    writers[index] = writer;
                }

                public void flush() throws HyracksDataException {
                    for (int i = 0; i < SwitchOperatorDescriptor.this.outputArity; ++i) {
                        if (!isOpen[i]) continue;
                        this.val$appenders[i].flush(writers[i]);
                    }
                }
            };
        }
    }
}

