/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class NumericDivideTypeComputer
extends AbstractResultTypeComputer {
    public static final NumericDivideTypeComputer INSTANCE = new NumericDivideTypeComputer();

    private NumericDivideTypeComputer() {
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        IAType type;
        IAType t1 = strippedInputTypes[0];
        IAType t2 = strippedInputTypes[1];
        ATypeTag tag1 = t1.getTypeTag();
        ATypeTag tag2 = t2.getTypeTag();
        block0 : switch (tag1) {
            case DOUBLE: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case FLOAT: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: {
                        type = BuiltinType.AFLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case FLOAT: {
                        type = BuiltinType.AFLOAT;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case ANY: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: 
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            default: {
                return BuiltinType.ANULL;
            }
        }
        if (type.getTypeTag() != ATypeTag.ANY) {
            type = AUnionType.createNullableType(type);
        }
        return type;
    }
}

