/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.DoubleToFloatTypeConvertComputer;
import org.apache.asterix.om.types.hierachy.DoubleToInt16TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.DoubleToInt32TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.DoubleToInt64TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.DoubleToInt8TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.FloatToDoubleTypeConvertComputer;
import org.apache.asterix.om.types.hierachy.FloatToInt16TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.FloatToInt32TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.FloatToInt64TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.FloatToInt8TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToDoubleTypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToFloatTypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToInt16TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToInt32TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToInt64TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToInt8TypeConvertComputer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;

public class ATypeHierarchy {
    private static final BitSet typePromotionHierachyMap = new BitSet(ATypeTag.TYPE_COUNT * ATypeTag.TYPE_COUNT);
    private static final BitSet typeDemotionHierachyMap = new BitSet(ATypeTag.TYPE_COUNT * ATypeTag.TYPE_COUNT);
    private static final Map<Integer, ITypeConvertComputer> promoteComputerMap = new HashMap<Integer, ITypeConvertComputer>();
    private static final Map<Integer, Pair<ITypeConvertComputer, ITypeConvertComputer>> demoteComputerMap = new HashMap<Integer, Pair<ITypeConvertComputer, ITypeConvertComputer>>();
    private static Map<ATypeTag, Domain> hierarchyDomains = new EnumMap<ATypeTag, Domain>(ATypeTag.class);

    public static Domain getTypeDomain(ATypeTag tag) {
        return hierarchyDomains.get(tag);
    }

    public static boolean isSameTypeDomain(ATypeTag tag1, ATypeTag tag2, boolean useListDomain) {
        Domain tagHierarchy1 = hierarchyDomains.get(tag1);
        Domain tagHierarchy2 = hierarchyDomains.get(tag2);
        if (tagHierarchy1 == null || tagHierarchy2 == null) {
            return false;
        }
        if (useListDomain && tagHierarchy1 == Domain.LIST && tagHierarchy2 == Domain.LIST) {
            return true;
        }
        return tagHierarchy1.equals((Object)tagHierarchy2) && !useListDomain;
    }

    private static void addPromotionRule(ATypeTag type1, ATypeTag type2, ITypeConvertComputer promoteComputer) {
        int index = type1.ordinal() * ATypeTag.TYPE_COUNT + type2.ordinal();
        typePromotionHierachyMap.set(index);
        promoteComputerMap.put(index, promoteComputer);
    }

    private static void addDemotionRule(ATypeTag type1, ATypeTag type2, ITypeConvertComputer demoteStrictComputer, ITypeConvertComputer demoteLenientComputer) {
        int index = type1.ordinal() * ATypeTag.TYPE_COUNT + type2.ordinal();
        typeDemotionHierachyMap.set(index);
        demoteComputerMap.put(index, (Pair<ITypeConvertComputer, ITypeConvertComputer>)Pair.of((Object)demoteStrictComputer, (Object)demoteLenientComputer));
    }

    public static ITypeConvertComputer getTypePromoteComputer(ATypeTag type1, ATypeTag type2) {
        if (ATypeHierarchy.canPromote(type1, type2)) {
            return promoteComputerMap.get(type1.ordinal() * ATypeTag.TYPE_COUNT + type2.ordinal());
        }
        return null;
    }

    public static ITypeConvertComputer getTypeDemoteComputer(ATypeTag type1, ATypeTag type2, boolean strict) {
        if (ATypeHierarchy.canDemote(type1, type2)) {
            Pair<ITypeConvertComputer, ITypeConvertComputer> pair = demoteComputerMap.get(type1.ordinal() * ATypeTag.TYPE_COUNT + type2.ordinal());
            return strict ? (ITypeConvertComputer)pair.getLeft() : (ITypeConvertComputer)pair.getRight();
        }
        return null;
    }

    public static boolean canPromote(ATypeTag type1, ATypeTag type2) {
        return typePromotionHierachyMap.get(type1.ordinal() * ATypeTag.TYPE_COUNT + type2.ordinal());
    }

    public static boolean canDemote(ATypeTag type1, ATypeTag type2) {
        return typeDemotionHierachyMap.get(type1.ordinal() * ATypeTag.TYPE_COUNT + type2.ordinal());
    }

    public static boolean isCompatible(ATypeTag type1, ATypeTag type2) {
        return type1 == ATypeTag.ANY || type2 == ATypeTag.ANY || ATypeHierarchy.canPromote(type1, type2) || ATypeHierarchy.canPromote(type2, type1);
    }

    public static AsterixConstantValue getAsterixConstantValueFromNumericTypeObject(IAObject sourceObject, ATypeTag targetTypeTag) throws HyracksDataException {
        return ATypeHierarchy.getAsterixConstantValueFromNumericTypeObject(sourceObject, targetTypeTag, false, TypeCastingMathFunctionType.NONE);
    }

    public static AsterixConstantValue getAsterixConstantValueFromNumericTypeObject(IAObject sourceObject, ATypeTag targetTypeTag, boolean strictDemote, TypeCastingMathFunctionType mathFunction) throws HyracksDataException {
        ATypeTag sourceTypeTag = sourceObject.getType().getTypeTag();
        if (sourceTypeTag == targetTypeTag) {
            return new AsterixConstantValue(sourceObject);
        }
        ITypeConvertComputer convertComputer = null;
        if (ATypeHierarchy.canPromote(sourceTypeTag, targetTypeTag)) {
            convertComputer = ATypeHierarchy.getTypePromoteComputer(sourceTypeTag, targetTypeTag);
        } else if (ATypeHierarchy.canDemote(sourceTypeTag, targetTypeTag)) {
            convertComputer = ATypeHierarchy.getTypeDemoteComputer(sourceTypeTag, targetTypeTag, strictDemote);
        }
        if (convertComputer == null) {
            return null;
        }
        IAObject targetObject = convertComputer.convertType(sourceObject, mathFunction);
        return new AsterixConstantValue(targetObject);
    }

    public static IAObject convertNumericTypeObject(IAObject sourceObject, ATypeTag targetTypeTag) throws HyracksDataException {
        return ATypeHierarchy.convertNumericTypeObject(sourceObject, targetTypeTag, false, TypeCastingMathFunctionType.NONE);
    }

    public static IAObject convertNumericTypeObject(IAObject sourceObject, ATypeTag targetTypeTag, boolean strictDemote, TypeCastingMathFunctionType mathFunction) throws HyracksDataException {
        ATypeTag sourceTypeTag = sourceObject.getType().getTypeTag();
        if (sourceTypeTag == targetTypeTag) {
            return sourceObject;
        }
        ITypeConvertComputer convertComputer = null;
        if (ATypeHierarchy.canPromote(sourceTypeTag, targetTypeTag)) {
            convertComputer = ATypeHierarchy.getTypePromoteComputer(sourceTypeTag, targetTypeTag);
        } else if (ATypeHierarchy.canDemote(sourceTypeTag, targetTypeTag)) {
            convertComputer = ATypeHierarchy.getTypeDemoteComputer(sourceTypeTag, targetTypeTag, strictDemote);
        }
        if (convertComputer == null) {
            throw new RuntimeDataException(ErrorCode.TYPE_CONVERT, new Serializable[]{sourceTypeTag, targetTypeTag});
        }
        return convertComputer.convertType(sourceObject, mathFunction);
    }

    public static void convertNumericTypeByteArray(byte[] sourceByteArray, int s1, int l1, ATypeTag targetTypeTag, DataOutput out) throws IOException {
        ATypeHierarchy.convertNumericTypeByteArray(sourceByteArray, s1, l1, targetTypeTag, out, false);
    }

    public static void convertNumericTypeByteArray(byte[] sourceByteArray, int s1, int l1, ATypeTag targetTypeTag, DataOutput out, boolean strictDemote) throws IOException {
        ATypeTag sourceTypeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(sourceByteArray[s1]);
        if (sourceTypeTag != targetTypeTag) {
            if (ATypeHierarchy.canPromote(sourceTypeTag, targetTypeTag)) {
                ITypeConvertComputer convertComputer = ATypeHierarchy.getTypePromoteComputer(sourceTypeTag, targetTypeTag);
                convertComputer.convertType(sourceByteArray, s1 + 1, l1 - 1, out);
            } else if (ATypeHierarchy.canDemote(sourceTypeTag, targetTypeTag)) {
                ITypeConvertComputer convertComputer = ATypeHierarchy.getTypeDemoteComputer(sourceTypeTag, targetTypeTag, strictDemote);
                convertComputer.convertType(sourceByteArray, s1 + 1, l1 - 1, out);
            } else {
                throw new RuntimeDataException(ErrorCode.TYPE_CONVERT, new Serializable[]{sourceTypeTag, targetTypeTag});
            }
        }
    }

    public static int getIntegerValue(String name, int argIndex, byte[] bytes, int offset) throws HyracksDataException {
        return ATypeHierarchy.getIntegerValue(name, argIndex, bytes, offset, false);
    }

    public static int getIntegerValue(String name, int argIndex, byte[] bytes, int offset, boolean strictDemote) throws HyracksDataException {
        return ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition(name, argIndex, bytes, offset + 1, offset, strictDemote);
    }

    public static int getIntegerValueWithDifferentTypeTagPosition(String name, int argIndex, byte[] bytes, int offset, int typeTagPosition) throws HyracksDataException {
        return ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition(name, argIndex, bytes, offset, typeTagPosition, false);
    }

    public static int getIntegerValueWithDifferentTypeTagPosition(String name, int argIndex, byte[] bytes, int offset, int typeTagPosition, boolean strictDemote) throws HyracksDataException {
        ATypeTag sourceTypeTag = ATypeTag.VALUE_TYPE_MAPPING[bytes[typeTagPosition]];
        if (sourceTypeTag == null) {
            throw new RuntimeDataException(ErrorCode.INVALID_FORMAT, new Serializable[]{name, Integer.valueOf(argIndex)});
        }
        switch (sourceTypeTag) {
            case INTEGER: {
                return IntegerPointable.getInteger((byte[])bytes, (int)offset);
            }
            case TINYINT: 
            case SMALLINT: 
            case BIGINT: {
                return (int)IntegerToInt32TypeConvertComputer.getInstance(strictDemote).convertIntegerType(bytes, offset, sourceTypeTag, ATypeTag.INTEGER);
            }
            case FLOAT: {
                return FloatToInt32TypeConvertComputer.getInstance(strictDemote).convertType(bytes, offset);
            }
            case DOUBLE: {
                return DoubleToInt32TypeConvertComputer.getInstance(strictDemote).convertType(bytes, offset);
            }
        }
        throw ATypeHierarchy.createTypeMismatchException(name, argIndex, sourceTypeTag, ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT, ATypeTag.FLOAT, ATypeTag.DOUBLE);
    }

    public static long getLongValue(String name, int argIndex, byte[] bytes, int offset) throws HyracksDataException {
        return ATypeHierarchy.getLongValue(name, argIndex, bytes, offset, false);
    }

    public static long getLongValue(String name, int argIndex, byte[] bytes, int offset, boolean strictDemote) throws HyracksDataException {
        return ATypeHierarchy.getLongValueWithDifferentTypeTagPosition(name, argIndex, bytes, offset + 1, offset, strictDemote);
    }

    private static long getLongValueWithDifferentTypeTagPosition(String name, int argIndex, byte[] bytes, int offset, int typeTagPosition, boolean strictDemote) throws HyracksDataException {
        ATypeTag sourceTypeTag = ATypeTag.VALUE_TYPE_MAPPING[bytes[typeTagPosition]];
        if (sourceTypeTag == null) {
            throw new RuntimeDataException(ErrorCode.INVALID_FORMAT, new Serializable[]{name, Integer.valueOf(argIndex)});
        }
        switch (sourceTypeTag) {
            case BIGINT: {
                return LongPointable.getLong((byte[])bytes, (int)offset);
            }
            case INTEGER: 
            case TINYINT: 
            case SMALLINT: {
                return IntegerToInt64TypeConvertComputer.getInstance().convertIntegerType(bytes, offset, sourceTypeTag, ATypeTag.BIGINT);
            }
            case FLOAT: {
                return FloatToInt64TypeConvertComputer.getInstance(strictDemote).convertType(bytes, offset);
            }
            case DOUBLE: {
                return DoubleToInt64TypeConvertComputer.getInstance(strictDemote).convertType(bytes, offset);
            }
        }
        throw ATypeHierarchy.createTypeMismatchException(name, argIndex, sourceTypeTag, ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT, ATypeTag.FLOAT, ATypeTag.DOUBLE);
    }

    public static double getDoubleValue(String name, int argIndex, byte[] bytes, int offset) throws HyracksDataException {
        return ATypeHierarchy.getDoubleValueWithDifferentTypeTagPosition(name, argIndex, bytes, offset + 1, offset);
    }

    private static double getDoubleValueWithDifferentTypeTagPosition(String name, int argIndex, byte[] bytes, int offset, int typeTagPosition) throws HyracksDataException {
        ATypeTag sourceTypeTag = ATypeTag.VALUE_TYPE_MAPPING[bytes[typeTagPosition]];
        if (sourceTypeTag == null) {
            throw new RuntimeDataException(ErrorCode.INVALID_FORMAT, new Serializable[]{name, Integer.valueOf(argIndex)});
        }
        switch (sourceTypeTag) {
            case DOUBLE: {
                return DoublePointable.getDouble((byte[])bytes, (int)offset);
            }
            case FLOAT: {
                return FloatToDoubleTypeConvertComputer.getInstance().convertType(bytes, offset);
            }
            case INTEGER: 
            case TINYINT: 
            case SMALLINT: 
            case BIGINT: {
                return IntegerToDoubleTypeConvertComputer.getInstance().convertType(bytes, offset, sourceTypeTag);
            }
        }
        throw ATypeHierarchy.createTypeMismatchException(name, argIndex, sourceTypeTag, ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT, ATypeTag.FLOAT, ATypeTag.DOUBLE);
    }

    public static double applyMathFunctionToDoubleValue(IAObject sourceObject, TypeCastingMathFunctionType mathFunction) {
        switch (mathFunction) {
            case CEIL: {
                return Math.ceil(((ADouble)sourceObject).getDoubleValue());
            }
            case FLOOR: {
                return Math.floor(((ADouble)sourceObject).getDoubleValue());
            }
        }
        return ((ADouble)sourceObject).getDoubleValue();
    }

    public static float applyMathFunctionToFloatValue(IAObject sourceObject, TypeCastingMathFunctionType mathFunction) {
        switch (mathFunction) {
            case CEIL: {
                return (float)Math.ceil(((AFloat)sourceObject).getFloatValue());
            }
            case FLOOR: {
                return (float)Math.floor(((AFloat)sourceObject).getFloatValue());
            }
        }
        return ((AFloat)sourceObject).getFloatValue();
    }

    private static RuntimeDataException createTypeMismatchException(String functionName, int argIdx, ATypeTag actualTypeTag, ATypeTag ... expectedTypeTags) {
        return new RuntimeDataException(ErrorCode.TYPE_MISMATCH_FUNCTION, new Serializable[]{functionName, ExceptionUtil.indexToPosition(argIdx), ExceptionUtil.toExpectedTypeString(expectedTypeTags), actualTypeTag});
    }

    static {
        for (int i = 0; i < ATypeTag.TYPE_COUNT; ++i) {
            typePromotionHierachyMap.set(i * ATypeTag.TYPE_COUNT + i);
            typeDemotionHierachyMap.set(i * ATypeTag.TYPE_COUNT + i);
        }
        ATypeHierarchy.addPromotionRule(ATypeTag.TINYINT, ATypeTag.SMALLINT, IntegerToInt16TypeConvertComputer.getInstance(true));
        ATypeHierarchy.addPromotionRule(ATypeTag.TINYINT, ATypeTag.INTEGER, IntegerToInt32TypeConvertComputer.getInstance(true));
        ATypeHierarchy.addPromotionRule(ATypeTag.TINYINT, ATypeTag.BIGINT, IntegerToInt64TypeConvertComputer.getInstance());
        ATypeHierarchy.addPromotionRule(ATypeTag.SMALLINT, ATypeTag.INTEGER, IntegerToInt32TypeConvertComputer.getInstance(true));
        ATypeHierarchy.addPromotionRule(ATypeTag.SMALLINT, ATypeTag.BIGINT, IntegerToInt64TypeConvertComputer.getInstance());
        ATypeHierarchy.addPromotionRule(ATypeTag.INTEGER, ATypeTag.BIGINT, IntegerToInt64TypeConvertComputer.getInstance());
        ATypeHierarchy.addPromotionRule(ATypeTag.TINYINT, ATypeTag.DOUBLE, IntegerToDoubleTypeConvertComputer.getInstance());
        ATypeHierarchy.addPromotionRule(ATypeTag.SMALLINT, ATypeTag.DOUBLE, IntegerToDoubleTypeConvertComputer.getInstance());
        ATypeHierarchy.addPromotionRule(ATypeTag.INTEGER, ATypeTag.DOUBLE, IntegerToDoubleTypeConvertComputer.getInstance());
        ATypeHierarchy.addPromotionRule(ATypeTag.BIGINT, ATypeTag.DOUBLE, IntegerToDoubleTypeConvertComputer.getInstance());
        ATypeHierarchy.addPromotionRule(ATypeTag.FLOAT, ATypeTag.DOUBLE, FloatToDoubleTypeConvertComputer.getInstance());
        ATypeHierarchy.addPromotionRule(ATypeTag.TINYINT, ATypeTag.FLOAT, IntegerToFloatTypeConvertComputer.getInstance());
        ATypeHierarchy.addPromotionRule(ATypeTag.SMALLINT, ATypeTag.FLOAT, IntegerToFloatTypeConvertComputer.getInstance());
        ATypeHierarchy.addPromotionRule(ATypeTag.INTEGER, ATypeTag.FLOAT, IntegerToFloatTypeConvertComputer.getInstance());
        ATypeHierarchy.addPromotionRule(ATypeTag.BIGINT, ATypeTag.FLOAT, IntegerToFloatTypeConvertComputer.getInstance());
        ATypeHierarchy.addDemotionRule(ATypeTag.SMALLINT, ATypeTag.TINYINT, IntegerToInt8TypeConvertComputer.getInstance(true), IntegerToInt8TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.INTEGER, ATypeTag.TINYINT, IntegerToInt8TypeConvertComputer.getInstance(true), IntegerToInt8TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.BIGINT, ATypeTag.TINYINT, IntegerToInt8TypeConvertComputer.getInstance(true), IntegerToInt8TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.INTEGER, ATypeTag.SMALLINT, IntegerToInt16TypeConvertComputer.getInstance(true), IntegerToInt16TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.BIGINT, ATypeTag.SMALLINT, IntegerToInt16TypeConvertComputer.getInstance(true), IntegerToInt16TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.BIGINT, ATypeTag.INTEGER, IntegerToInt32TypeConvertComputer.getInstance(true), IntegerToInt32TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.FLOAT, ATypeTag.TINYINT, FloatToInt8TypeConvertComputer.getInstance(true), FloatToInt8TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.FLOAT, ATypeTag.SMALLINT, FloatToInt16TypeConvertComputer.getInstance(true), FloatToInt16TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.FLOAT, ATypeTag.INTEGER, FloatToInt32TypeConvertComputer.getInstance(true), FloatToInt32TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.FLOAT, ATypeTag.BIGINT, FloatToInt64TypeConvertComputer.getInstance(true), FloatToInt64TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.DOUBLE, ATypeTag.TINYINT, DoubleToInt8TypeConvertComputer.getInstance(true), DoubleToInt8TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.DOUBLE, ATypeTag.SMALLINT, DoubleToInt16TypeConvertComputer.getInstance(true), DoubleToInt16TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.DOUBLE, ATypeTag.INTEGER, DoubleToInt32TypeConvertComputer.getInstance(true), DoubleToInt32TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.DOUBLE, ATypeTag.BIGINT, DoubleToInt64TypeConvertComputer.getInstance(true), DoubleToInt64TypeConvertComputer.getInstance(false));
        ATypeHierarchy.addDemotionRule(ATypeTag.DOUBLE, ATypeTag.FLOAT, DoubleToFloatTypeConvertComputer.getInstance(true), DoubleToFloatTypeConvertComputer.getInstance(false));
        hierarchyDomains.put(ATypeTag.POINT, Domain.SPATIAL);
        hierarchyDomains.put(ATypeTag.LINE, Domain.SPATIAL);
        hierarchyDomains.put(ATypeTag.CIRCLE, Domain.SPATIAL);
        hierarchyDomains.put(ATypeTag.POLYGON, Domain.SPATIAL);
        hierarchyDomains.put(ATypeTag.RECTANGLE, Domain.SPATIAL);
        hierarchyDomains.put(ATypeTag.GEOMETRY, Domain.SPATIAL);
        hierarchyDomains.put(ATypeTag.TINYINT, Domain.NUMERIC);
        hierarchyDomains.put(ATypeTag.SMALLINT, Domain.NUMERIC);
        hierarchyDomains.put(ATypeTag.INTEGER, Domain.NUMERIC);
        hierarchyDomains.put(ATypeTag.BIGINT, Domain.NUMERIC);
        hierarchyDomains.put(ATypeTag.FLOAT, Domain.NUMERIC);
        hierarchyDomains.put(ATypeTag.DOUBLE, Domain.NUMERIC);
        hierarchyDomains.put(ATypeTag.ARRAY, Domain.LIST);
        hierarchyDomains.put(ATypeTag.MULTISET, Domain.LIST);
    }

    public static enum Domain {
        SPATIAL,
        NUMERIC,
        LIST,
        ANY;

    }

    public static enum TypeCastingMathFunctionType {
        CEIL,
        FLOOR,
        NONE;

    }
}

