/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class AInt16
implements IAObject {
    protected short value;

    public AInt16(short value) {
        this.value = value;
    }

    @Override
    public IAType getType() {
        return BuiltinType.AINT16;
    }

    public short getShortValue() {
        return this.value;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof AInt16)) {
            return false;
        }
        return this.value == ((AInt16)obj).getShortValue();
    }

    @Override
    public int hash() {
        return this.value;
    }

    public String toString() {
        return Short.toString(this.value);
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("AInt16", this.value);
        return json;
    }
}

