/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.asterix.algebra.operators.physical.SpatialJoinPOperator;
import org.apache.asterix.common.annotations.SpatialJoinAnnotation;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.ARectangle;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.operators.joins.spatial.utils.ISpatialJoinUtilFactory;
import org.apache.asterix.runtime.operators.joins.spatial.utils.IntersectSpatialJoinUtilFactory;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AggregatePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AssignPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.BroadcastExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.NestedLoopJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.OneToOneExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.RandomPartitionExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.ReplicatePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StreamProjectPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.UnnestPOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SpatialJoinUtils {
    private static final int DEFAULT_ROWS = 100;
    private static final int DEFAULT_COLUMNS = 100;

    protected static boolean trySpatialJoinAssignment(AbstractBinaryJoinOperator op, IOptimizationContext context, ILogicalExpression joinCondition, int left, int right) throws AlgebricksException {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)joinCondition;
        AbstractFunctionCallExpression spatialJoinFuncExpr = null;
        ArrayList<Mutable<ILogicalExpression>> conditionExprs = new ArrayList<Mutable<ILogicalExpression>>();
        if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.AND)) {
            List inputExprs = funcExpr.getArguments();
            if (inputExprs.size() == 0) {
                return false;
            }
            boolean spatialIntersectExists = false;
            for (Mutable exp : inputExprs) {
                AbstractFunctionCallExpression funcCallExp = (AbstractFunctionCallExpression)exp.getValue();
                if (funcCallExp.getFunctionIdentifier().equals((Object)BuiltinFunctions.SPATIAL_INTERSECT)) {
                    spatialJoinFuncExpr = funcCallExp;
                    spatialIntersectExists = true;
                    continue;
                }
                conditionExprs.add((Mutable<ILogicalExpression>)exp);
            }
            if (!spatialIntersectExists) {
                return false;
            }
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.SPATIAL_INTERSECT)) {
            spatialJoinFuncExpr = funcExpr;
        } else {
            return false;
        }
        SpatialJoinAnnotation spatialJoinAnn = (SpatialJoinAnnotation)spatialJoinFuncExpr.getAnnotation(SpatialJoinAnnotation.class);
        return SpatialJoinUtils.updateJoinPlan(op, spatialJoinFuncExpr, conditionExprs, spatialJoinAnn, context, left, right);
    }

    private static void setSpatialJoinOp(AbstractBinaryJoinOperator op, List<LogicalVariable> keysLeftBranch, List<LogicalVariable> keysRightBranch, IOptimizationContext context) throws AlgebricksException {
        IntersectSpatialJoinUtilFactory isjuf = new IntersectSpatialJoinUtilFactory();
        op.setPhysicalOperator((IPhysicalOperator)new SpatialJoinPOperator(op.getJoinKind(), AbstractJoinPOperator.JoinPartitioningType.PAIRWISE, keysLeftBranch, keysRightBranch, context.getPhysicalOptimizationConfig().getMaxFramesForJoin(), (ISpatialJoinUtilFactory)isjuf));
        op.recomputeSchema();
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
    }

    private static LogicalVariable injectSpatialTileUnnestOperator(IOptimizationContext context, Mutable<ILogicalOperator> op, LogicalVariable unnestVar, Mutable<ILogicalExpression> unnestMBRExpr, int numRows, int numColumns) throws AlgebricksException {
        SourceLocation srcLoc = ((ILogicalOperator)op.getValue()).getSourceLocation();
        LogicalVariable tileIdVar = context.newVar();
        VariableReferenceExpression unnestVarRef = new VariableReferenceExpression(unnestVar);
        unnestVarRef.setSourceLocation(srcLoc);
        UnnestingFunctionCallExpression spatialTileFuncExpr = new UnnestingFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.SPATIAL_TILE), new Mutable[]{new MutableObject((Object)unnestVarRef), unnestMBRExpr, new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt64((long)numRows)))), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt64((long)numColumns))))});
        spatialTileFuncExpr.setSourceLocation(srcLoc);
        UnnestOperator unnestOp = new UnnestOperator(tileIdVar, (Mutable)new MutableObject((Object)spatialTileFuncExpr));
        unnestOp.setPhysicalOperator((IPhysicalOperator)new UnnestPOperator());
        unnestOp.setSourceLocation(srcLoc);
        unnestOp.getInputs().add(new MutableObject((Object)((ILogicalOperator)op.getValue())));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unnestOp);
        unnestOp.recomputeSchema();
        op.setValue((Object)unnestOp);
        return tileIdVar;
    }

    protected static boolean updateJoinPlan(AbstractBinaryJoinOperator op, AbstractFunctionCallExpression spatialJoinFuncExpr, List<Mutable<ILogicalExpression>> conditionExprs, SpatialJoinAnnotation spatialJoinAnn, IOptimizationContext context, int left, int right) throws AlgebricksException {
        LogicalVariable rightInputVar;
        LogicalVariable leftInputVar;
        List spatialJoinArgs = spatialJoinFuncExpr.getArguments();
        if (spatialJoinArgs.size() != 2) {
            return false;
        }
        ILogicalExpression spatialJoinLeftArg = (ILogicalExpression)((Mutable)spatialJoinArgs.get(left)).getValue();
        ILogicalExpression spatialJoinRightArg = (ILogicalExpression)((Mutable)spatialJoinArgs.get(right)).getValue();
        if (spatialJoinLeftArg.getExpressionTag() != LogicalExpressionTag.VARIABLE || spatialJoinRightArg.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        IVariableTypeEnvironment typeEnvironment = op.computeInputTypeEnvironment((ITypingContext)context);
        IAType leftType = (IAType)context.getExpressionTypeComputer().getType(spatialJoinLeftArg, context.getMetadataProvider(), typeEnvironment);
        IAType rightType = (IAType)context.getExpressionTypeComputer().getType(spatialJoinRightArg, context.getMetadataProvider(), typeEnvironment);
        if (leftType.getTypeTag() != BuiltinType.ARECTANGLE.getTypeTag() || rightType.getTypeTag() != BuiltinType.ARECTANGLE.getTypeTag()) {
            return false;
        }
        Mutable leftInputOp = (Mutable)op.getInputs().get(left);
        Mutable rightInputOp = (Mutable)op.getInputs().get(right);
        LogicalVariable spatialJoinVar0 = ((VariableReferenceExpression)spatialJoinLeftArg).getVariableReference();
        LogicalVariable spatialJoinVar1 = ((VariableReferenceExpression)spatialJoinRightArg).getVariableReference();
        HashSet liveVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)leftInputOp.getValue()), liveVars);
        if (liveVars.contains(spatialJoinVar0)) {
            leftInputVar = spatialJoinVar0;
            rightInputVar = spatialJoinVar1;
        } else {
            leftInputVar = spatialJoinVar1;
            rightInputVar = spatialJoinVar0;
        }
        if (spatialJoinAnn == null) {
            SpatialJoinUtils.buildSpatialJoinPlanWithDynamicMbr(op, context, spatialJoinFuncExpr, conditionExprs, (Mutable<ILogicalOperator>)leftInputOp, (Mutable<ILogicalOperator>)rightInputOp, leftInputVar, rightInputVar);
        } else {
            SpatialJoinUtils.buildSpatialJoinPlanWithStaticMbr(op, context, spatialJoinFuncExpr, conditionExprs, (Mutable<ILogicalOperator>)leftInputOp, (Mutable<ILogicalOperator>)rightInputOp, leftInputVar, rightInputVar, spatialJoinAnn);
        }
        return true;
    }

    private static void buildSpatialJoinPlanWithStaticMbr(AbstractBinaryJoinOperator op, IOptimizationContext context, AbstractFunctionCallExpression spatialJoinFuncExpr, List<Mutable<ILogicalExpression>> conditionExprs, Mutable<ILogicalOperator> leftInputOp, Mutable<ILogicalOperator> rightInputOp, LogicalVariable leftInputVar, LogicalVariable rightInputVar, SpatialJoinAnnotation spatialJoinAnn) throws AlgebricksException {
        Mutable<ILogicalExpression> leftIntersectionMBRExpr = SpatialJoinUtils.createRectangleExpression(spatialJoinAnn);
        Mutable<ILogicalExpression> rightIntersectionMBRExpr = SpatialJoinUtils.createRectangleExpression(spatialJoinAnn);
        Mutable<ILogicalExpression> referencePointTestMBRExpr = SpatialJoinUtils.createRectangleExpression(spatialJoinAnn);
        int numRows = spatialJoinAnn.getNumRows();
        int numColumns = spatialJoinAnn.getNumColumns();
        LogicalVariable leftTileIdVar = SpatialJoinUtils.injectSpatialTileUnnestOperator(context, leftInputOp, leftInputVar, leftIntersectionMBRExpr, numRows, numColumns);
        LogicalVariable rightTileIdVar = SpatialJoinUtils.injectSpatialTileUnnestOperator(context, rightInputOp, rightInputVar, rightIntersectionMBRExpr, numRows, numColumns);
        ScalarFunctionCallExpression referenceIdEquiJoinCondition = SpatialJoinUtils.createReferencePointTestCondition(op, referencePointTestMBRExpr, leftTileIdVar, rightTileIdVar, leftInputVar, rightInputVar, numRows, numColumns);
        conditionExprs.add((Mutable<ILogicalExpression>)new MutableObject((Object)referenceIdEquiJoinCondition));
        conditionExprs.add((Mutable<ILogicalExpression>)new MutableObject((Object)spatialJoinFuncExpr));
        ScalarFunctionCallExpression updatedJoinCondition = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), conditionExprs);
        updatedJoinCondition.setSourceLocation(op.getSourceLocation());
        Mutable joinConditionRef = op.getCondition();
        joinConditionRef.setValue((Object)updatedJoinCondition);
        ArrayList<LogicalVariable> keysLeftBranch = new ArrayList<LogicalVariable>();
        keysLeftBranch.add(leftTileIdVar);
        keysLeftBranch.add(leftInputVar);
        ArrayList<LogicalVariable> keysRightBranch = new ArrayList<LogicalVariable>();
        keysRightBranch.add(rightTileIdVar);
        keysRightBranch.add(rightInputVar);
        SpatialJoinUtils.setSpatialJoinOp(op, keysLeftBranch, keysRightBranch, context);
    }

    private static void buildSpatialJoinPlanWithDynamicMbr(AbstractBinaryJoinOperator op, IOptimizationContext context, AbstractFunctionCallExpression spatialJoinFuncExpr, List<Mutable<ILogicalExpression>> conditionExprs, Mutable<ILogicalOperator> leftInputOp, Mutable<ILogicalOperator> rightInputOp, LogicalVariable leftInputVar, LogicalVariable rightInputVar) throws AlgebricksException {
        ScalarFunctionCallExpression updatedJoinCondition;
        Triple<MutableObject<ILogicalOperator>, List<LogicalVariable>, MutableObject<ILogicalOperator>> leftMBRCalculator = SpatialJoinUtils.createDynamicMBRCalculator(op, context, leftInputOp, leftInputVar);
        MutableObject leftGlobalAgg = (MutableObject)leftMBRCalculator.first;
        List leftGlobalAggResultVars = (List)leftMBRCalculator.second;
        MutableObject leftExchToJoinOpRef = (MutableObject)leftMBRCalculator.third;
        LogicalVariable leftMBRVar = (LogicalVariable)leftGlobalAggResultVars.get(0);
        Triple<MutableObject<ILogicalOperator>, List<LogicalVariable>, MutableObject<ILogicalOperator>> rightMBRCalculator = SpatialJoinUtils.createDynamicMBRCalculator(op, context, rightInputOp, rightInputVar);
        MutableObject rightGlobalAgg = (MutableObject)rightMBRCalculator.first;
        List rightGlobalAggResultVars = (List)rightMBRCalculator.second;
        MutableObject rightExchToJoinOpRef = (MutableObject)rightMBRCalculator.third;
        LogicalVariable rightMBRVar = (LogicalVariable)rightGlobalAggResultVars.get(0);
        MutableObject trueCondition = new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)ABoolean.TRUE)));
        InnerJoinOperator unionMBRJoinOp = new InnerJoinOperator((Mutable)trueCondition, (Mutable)leftGlobalAgg, (Mutable)rightGlobalAgg);
        unionMBRJoinOp.setSourceLocation(op.getSourceLocation());
        unionMBRJoinOp.setPhysicalOperator((IPhysicalOperator)new NestedLoopJoinPOperator(AbstractBinaryJoinOperator.JoinKind.INNER, AbstractJoinPOperator.JoinPartitioningType.BROADCAST));
        MutableObject unionMBRJoinOpRef = new MutableObject((Object)unionMBRJoinOp);
        unionMBRJoinOp.recomputeSchema();
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unionMBRJoinOp);
        ArrayList<MutableObject> getIntersectionFuncInputExprs = new ArrayList<MutableObject>();
        getIntersectionFuncInputExprs.add(new MutableObject((Object)new VariableReferenceExpression(leftMBRVar)));
        getIntersectionFuncInputExprs.add(new MutableObject((Object)new VariableReferenceExpression(rightMBRVar)));
        ScalarFunctionCallExpression getIntersectionFuncExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.GET_INTERSECTION), getIntersectionFuncInputExprs);
        getIntersectionFuncExpr.setSourceLocation(op.getSourceLocation());
        MutableObject intersectionMBRExpr = new MutableObject((Object)getIntersectionFuncExpr);
        LogicalVariable intersectionMBR = context.newVar();
        AssignOperator intersectionMBRAssignOperator = new AssignOperator(intersectionMBR, (Mutable)intersectionMBRExpr);
        intersectionMBRAssignOperator.setSourceLocation(op.getSourceLocation());
        intersectionMBRAssignOperator.setExecutionMode(op.getExecutionMode());
        intersectionMBRAssignOperator.setPhysicalOperator((IPhysicalOperator)new AssignPOperator());
        intersectionMBRAssignOperator.getInputs().add(new MutableObject((Object)((ILogicalOperator)unionMBRJoinOpRef.getValue())));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)intersectionMBRAssignOperator);
        intersectionMBRAssignOperator.recomputeSchema();
        MutableObject intersectionMBRAssignOperatorRef = new MutableObject((Object)intersectionMBRAssignOperator);
        ReplicateOperator intersectionMBRReplicateOperator = SpatialJoinUtils.createReplicateOperator((Mutable<ILogicalOperator>)intersectionMBRAssignOperatorRef, context, op.getSourceLocation(), 3);
        ExchangeOperator exchMBRToJoinOpLeft = SpatialJoinUtils.createBroadcastExchangeOp(intersectionMBRReplicateOperator, context, op.getSourceLocation());
        MutableObject exchMBRToJoinOpLeftRef = new MutableObject((Object)exchMBRToJoinOpLeft);
        Pair<LogicalVariable, Mutable<ILogicalOperator>> createLeftAssignProjectOperatorResult = SpatialJoinUtils.createAssignProjectOperator(op, intersectionMBR, intersectionMBRReplicateOperator, (MutableObject<ILogicalOperator>)exchMBRToJoinOpLeftRef, context);
        LogicalVariable leftIntersectionMBRVar = (LogicalVariable)createLeftAssignProjectOperatorResult.getFirst();
        Mutable leftIntersectionMBRRef = (Mutable)createLeftAssignProjectOperatorResult.getSecond();
        ExchangeOperator exchMBRToJoinOpRight = SpatialJoinUtils.createBroadcastExchangeOp(intersectionMBRReplicateOperator, context, op.getSourceLocation());
        MutableObject exchMBRToJoinOpRightRef = new MutableObject((Object)exchMBRToJoinOpRight);
        Pair<LogicalVariable, Mutable<ILogicalOperator>> createRightAssignProjectOperatorResult = SpatialJoinUtils.createAssignProjectOperator(op, intersectionMBR, intersectionMBRReplicateOperator, (MutableObject<ILogicalOperator>)exchMBRToJoinOpRightRef, context);
        LogicalVariable rightIntersectionMBRVar = (LogicalVariable)createRightAssignProjectOperatorResult.getFirst();
        Mutable rightIntersectionMBRRef = (Mutable)createRightAssignProjectOperatorResult.getSecond();
        ExchangeOperator exchMBRToReferencePointTestJoinOp = SpatialJoinUtils.createBroadcastExchangeOp(intersectionMBRReplicateOperator, context, op.getSourceLocation());
        MutableObject exchMBRToReferencePointTestJoinOpRef = new MutableObject((Object)exchMBRToReferencePointTestJoinOp);
        MutableObject leftTrueCondition = new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)ABoolean.TRUE)));
        InnerJoinOperator leftJoinOp = new InnerJoinOperator((Mutable)leftTrueCondition, (Mutable)leftExchToJoinOpRef, leftIntersectionMBRRef);
        leftJoinOp.setSourceLocation(op.getSourceLocation());
        leftJoinOp.setPhysicalOperator((IPhysicalOperator)new NestedLoopJoinPOperator(AbstractBinaryJoinOperator.JoinKind.INNER, AbstractJoinPOperator.JoinPartitioningType.BROADCAST));
        MutableObject leftJoinRef = new MutableObject((Object)leftJoinOp);
        leftJoinOp.recomputeSchema();
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)leftJoinOp);
        leftInputOp.setValue((Object)((ILogicalOperator)leftJoinRef.getValue()));
        MutableObject rightTrueCondition = new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)ABoolean.TRUE)));
        InnerJoinOperator rightJoinOp = new InnerJoinOperator((Mutable)rightTrueCondition, (Mutable)rightExchToJoinOpRef, rightIntersectionMBRRef);
        rightJoinOp.setSourceLocation(op.getSourceLocation());
        rightJoinOp.setPhysicalOperator((IPhysicalOperator)new NestedLoopJoinPOperator(AbstractBinaryJoinOperator.JoinKind.INNER, AbstractJoinPOperator.JoinPartitioningType.BROADCAST));
        MutableObject rightJoinRef = new MutableObject((Object)rightJoinOp);
        rightJoinOp.recomputeSchema();
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)rightJoinOp);
        rightInputOp.setValue((Object)((ILogicalOperator)rightJoinRef.getValue()));
        MutableObject leftIntersectionMBRExpr = new MutableObject((Object)new VariableReferenceExpression(leftIntersectionMBRVar));
        MutableObject rightIntersectionMBRExpr = new MutableObject((Object)new VariableReferenceExpression(rightIntersectionMBRVar));
        MutableObject referencePointTestMBRExpr = new MutableObject((Object)new VariableReferenceExpression(intersectionMBR));
        LogicalVariable leftTileIdVar = SpatialJoinUtils.injectSpatialTileUnnestOperator(context, leftInputOp, leftInputVar, (Mutable<ILogicalExpression>)leftIntersectionMBRExpr, 100, 100);
        LogicalVariable rightTileIdVar = SpatialJoinUtils.injectSpatialTileUnnestOperator(context, rightInputOp, rightInputVar, (Mutable<ILogicalExpression>)rightIntersectionMBRExpr, 100, 100);
        ScalarFunctionCallExpression referenceIdEquiJoinCondition = SpatialJoinUtils.createReferencePointTestCondition(op, (Mutable<ILogicalExpression>)referencePointTestMBRExpr, leftTileIdVar, rightTileIdVar, leftInputVar, rightInputVar, 100, 100);
        conditionExprs.add((Mutable<ILogicalExpression>)new MutableObject((Object)spatialJoinFuncExpr));
        if (conditionExprs.size() > 1) {
            updatedJoinCondition = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), conditionExprs);
            updatedJoinCondition.setSourceLocation(op.getSourceLocation());
        } else {
            updatedJoinCondition = (ScalarFunctionCallExpression)spatialJoinFuncExpr;
        }
        Mutable joinConditionRef = op.getCondition();
        joinConditionRef.setValue((Object)updatedJoinCondition);
        ArrayList<LogicalVariable> keysLeftBranch = new ArrayList<LogicalVariable>();
        keysLeftBranch.add(leftTileIdVar);
        keysLeftBranch.add(leftInputVar);
        ArrayList<LogicalVariable> keysRightBranch = new ArrayList<LogicalVariable>();
        keysRightBranch.add(rightTileIdVar);
        keysRightBranch.add(rightInputVar);
        InnerJoinOperator spatialJoinOp = new InnerJoinOperator((Mutable)new MutableObject((Object)updatedJoinCondition), leftInputOp, rightInputOp);
        spatialJoinOp.setSourceLocation(op.getSourceLocation());
        SpatialJoinUtils.setSpatialJoinOp((AbstractBinaryJoinOperator)spatialJoinOp, keysLeftBranch, keysRightBranch, context);
        spatialJoinOp.setSchema(op.getSchema());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)spatialJoinOp);
        MutableObject opRef = new MutableObject((Object)op);
        MutableObject spatialJoinOpRef = new MutableObject((Object)spatialJoinOp);
        InnerJoinOperator referencePointTestJoinOp = new InnerJoinOperator((Mutable)new MutableObject((Object)referenceIdEquiJoinCondition), (Mutable)spatialJoinOpRef, (Mutable)exchMBRToReferencePointTestJoinOpRef);
        referencePointTestJoinOp.setPhysicalOperator((IPhysicalOperator)new NestedLoopJoinPOperator(AbstractBinaryJoinOperator.JoinKind.INNER, AbstractJoinPOperator.JoinPartitioningType.BROADCAST));
        MutableObject referencePointTestJoinOpRef = new MutableObject((Object)referencePointTestJoinOp);
        referencePointTestJoinOp.setSourceLocation(op.getSourceLocation());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)referencePointTestJoinOp);
        referencePointTestJoinOp.recomputeSchema();
        opRef.setValue((Object)((ILogicalOperator)referencePointTestJoinOpRef.getValue()));
        op.getInputs().clear();
        op.getInputs().addAll(referencePointTestJoinOp.getInputs());
        op.setPhysicalOperator(referencePointTestJoinOp.getPhysicalOperator());
        op.getCondition().setValue((Object)((ILogicalExpression)referencePointTestJoinOp.getCondition().getValue()));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
        op.recomputeSchema();
    }

    private static ScalarFunctionCallExpression createReferencePointTestCondition(AbstractBinaryJoinOperator op, Mutable<ILogicalExpression> referencePointTestMBRExpr, LogicalVariable leftTileIdVar, LogicalVariable rightTileIdVar, LogicalVariable leftInputVar, LogicalVariable rightInputVar, int numRows, int numColumns) {
        ScalarFunctionCallExpression referenceTileId = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.REFERENCE_TILE), new Mutable[]{new MutableObject((Object)new VariableReferenceExpression(leftInputVar)), new MutableObject((Object)new VariableReferenceExpression(rightInputVar)), referencePointTestMBRExpr, new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt64((long)numRows)))), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt64((long)numColumns)))), new MutableObject((Object)new VariableReferenceExpression(rightTileIdVar))});
        referenceTileId.setSourceLocation(op.getSourceLocation());
        ScalarFunctionCallExpression referenceIdEquiJoinCondition = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.EQ), new Mutable[]{new MutableObject((Object)new VariableReferenceExpression(leftTileIdVar)), new MutableObject((Object)referenceTileId)});
        referenceIdEquiJoinCondition.setSourceLocation(op.getSourceLocation());
        return referenceIdEquiJoinCondition;
    }

    private static Pair<LogicalVariable, Mutable<ILogicalOperator>> createAssignProjectOperator(AbstractBinaryJoinOperator op, LogicalVariable inputVar, ReplicateOperator replicateOperator, MutableObject<ILogicalOperator> exchMBRToForwardRef, IOptimizationContext context) throws AlgebricksException {
        LogicalVariable newFinalMbrVar = context.newVar();
        ArrayList<LogicalVariable> finalMBRLiveVars = new ArrayList<LogicalVariable>();
        finalMBRLiveVars.add(newFinalMbrVar);
        ListSet finalMBRLiveVarsSet = new ListSet();
        finalMBRLiveVarsSet.add((Object)newFinalMbrVar);
        MutableObject finalMBRExpr = new MutableObject((Object)new VariableReferenceExpression(inputVar));
        AssignOperator assignOperator = new AssignOperator(newFinalMbrVar, (Mutable)finalMBRExpr);
        assignOperator.setSourceLocation(op.getSourceLocation());
        assignOperator.setExecutionMode(replicateOperator.getExecutionMode());
        assignOperator.setPhysicalOperator((IPhysicalOperator)new AssignPOperator());
        ProjectOperator projectOperator = new ProjectOperator(finalMBRLiveVars);
        projectOperator.setSourceLocation(op.getSourceLocation());
        projectOperator.setPhysicalOperator((IPhysicalOperator)new StreamProjectPOperator());
        projectOperator.setExecutionMode(replicateOperator.getExecutionMode());
        assignOperator.getInputs().add(exchMBRToForwardRef);
        projectOperator.getInputs().add(new MutableObject((Object)assignOperator));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOperator);
        assignOperator.recomputeSchema();
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)projectOperator);
        projectOperator.recomputeSchema();
        MutableObject projectOperatorRef = new MutableObject((Object)projectOperator);
        return new Pair((Object)newFinalMbrVar, (Object)projectOperatorRef);
    }

    private static ReplicateOperator createReplicateOperator(Mutable<ILogicalOperator> inputOperator, IOptimizationContext context, SourceLocation sourceLocation, int outputArity) throws AlgebricksException {
        ReplicateOperator replicateOperator = new ReplicateOperator(outputArity);
        replicateOperator.setPhysicalOperator((IPhysicalOperator)new ReplicatePOperator());
        replicateOperator.setSourceLocation(sourceLocation);
        replicateOperator.getInputs().add(new MutableObject((Object)((ILogicalOperator)inputOperator.getValue())));
        OperatorManipulationUtil.setOperatorMode((AbstractLogicalOperator)replicateOperator);
        replicateOperator.recomputeSchema();
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)replicateOperator);
        return replicateOperator;
    }

    private static ExchangeOperator createOneToOneExchangeOp(ReplicateOperator replicateOperator, IOptimizationContext context, SourceLocation sourceLocation) throws AlgebricksException {
        ExchangeOperator exchangeOperator = new ExchangeOperator();
        exchangeOperator.setSourceLocation(sourceLocation);
        exchangeOperator.setPhysicalOperator((IPhysicalOperator)new OneToOneExchangePOperator());
        replicateOperator.getOutputs().add(new MutableObject((Object)exchangeOperator));
        exchangeOperator.getInputs().add(new MutableObject((Object)replicateOperator));
        exchangeOperator.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        exchangeOperator.setSchema(replicateOperator.getSchema());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)exchangeOperator);
        return exchangeOperator;
    }

    private static ExchangeOperator createRandomPartitionExchangeOp(ReplicateOperator replicateOperator, IOptimizationContext context, SourceLocation sourceLocation) throws AlgebricksException {
        ExchangeOperator exchangeOperator = new ExchangeOperator();
        exchangeOperator.setSourceLocation(sourceLocation);
        exchangeOperator.setPhysicalOperator((IPhysicalOperator)new RandomPartitionExchangePOperator(context.getComputationNodeDomain()));
        replicateOperator.getOutputs().add(new MutableObject((Object)exchangeOperator));
        exchangeOperator.getInputs().add(new MutableObject((Object)replicateOperator));
        exchangeOperator.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        exchangeOperator.setSchema(replicateOperator.getSchema());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)exchangeOperator);
        return exchangeOperator;
    }

    private static ExchangeOperator createBroadcastExchangeOp(ReplicateOperator replicateOperator, IOptimizationContext context, SourceLocation sourceLocation) throws AlgebricksException {
        ExchangeOperator exchangeOperator = new ExchangeOperator();
        exchangeOperator.setSourceLocation(sourceLocation);
        exchangeOperator.setPhysicalOperator((IPhysicalOperator)new BroadcastExchangePOperator(context.getComputationNodeDomain()));
        replicateOperator.getOutputs().add(new MutableObject((Object)exchangeOperator));
        exchangeOperator.getInputs().add(new MutableObject((Object)replicateOperator));
        exchangeOperator.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        exchangeOperator.setSchema(replicateOperator.getSchema());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)exchangeOperator);
        return exchangeOperator;
    }

    private static Pair<MutableObject<ILogicalOperator>, List<LogicalVariable>> createLocalAndGlobalAggregateOperators(AbstractBinaryJoinOperator op, IOptimizationContext context, LogicalVariable inputVar, MutableObject<ILogicalOperator> exchToLocalAggRef) throws AlgebricksException {
        VariableReferenceExpression inputVarRef = new VariableReferenceExpression(inputVar, op.getSourceLocation());
        ArrayList<MutableObject> fields = new ArrayList<MutableObject>(1);
        fields.add(new MutableObject((Object)inputVarRef));
        IFunctionInfo localAggFunc = context.getMetadataProvider().lookupFunction(BuiltinFunctions.LOCAL_UNION_MBR);
        AggregateFunctionCallExpression localAggExpr = new AggregateFunctionCallExpression(localAggFunc, false, fields);
        localAggExpr.setSourceLocation(op.getSourceLocation());
        localAggExpr.setOpaqueParameters(new Object[0]);
        ArrayList<LogicalVariable> localAggResultVars = new ArrayList<LogicalVariable>(1);
        ArrayList<Mutable<ILogicalExpression>> localAggFuncs = new ArrayList<Mutable<ILogicalExpression>>(1);
        LogicalVariable localOutVariable = context.newVar();
        localAggResultVars.add(localOutVariable);
        localAggFuncs.add((Mutable<ILogicalExpression>)new MutableObject((Object)localAggExpr));
        AggregateOperator localAggOperator = SpatialJoinUtils.createAggregate(localAggResultVars, false, localAggFuncs, exchToLocalAggRef, context, op.getSourceLocation());
        MutableObject localAgg = new MutableObject((Object)localAggOperator);
        return SpatialJoinUtils.createGlobalAggregateOperator(op, context, localOutVariable, (MutableObject<ILogicalOperator>)localAgg);
    }

    private static Pair<MutableObject<ILogicalOperator>, List<LogicalVariable>> createGlobalAggregateOperator(AbstractBinaryJoinOperator op, IOptimizationContext context, LogicalVariable inputVar, MutableObject<ILogicalOperator> inputOperator) throws AlgebricksException {
        ArrayList<MutableObject> globalAggFuncArgs = new ArrayList<MutableObject>(1);
        VariableReferenceExpression inputVarRef = new VariableReferenceExpression(inputVar, op.getSourceLocation());
        globalAggFuncArgs.add(new MutableObject((Object)inputVarRef));
        IFunctionInfo globalAggFunc = context.getMetadataProvider().lookupFunction(BuiltinFunctions.GLOBAL_UNION_MBR);
        AggregateFunctionCallExpression globalAggExpr = new AggregateFunctionCallExpression(globalAggFunc, true, globalAggFuncArgs);
        globalAggExpr.setStepOneAggregate(globalAggFunc);
        globalAggExpr.setStepTwoAggregate(globalAggFunc);
        globalAggExpr.setSourceLocation(op.getSourceLocation());
        globalAggExpr.setOpaqueParameters(new Object[0]);
        ArrayList<LogicalVariable> globalAggResultVars = new ArrayList<LogicalVariable>(1);
        globalAggResultVars.add(context.newVar());
        ArrayList<Mutable<ILogicalExpression>> globalAggFuncs = new ArrayList<Mutable<ILogicalExpression>>(1);
        globalAggFuncs.add((Mutable<ILogicalExpression>)new MutableObject((Object)globalAggExpr));
        AggregateOperator globalAggOperator = SpatialJoinUtils.createAggregate(globalAggResultVars, true, globalAggFuncs, inputOperator, context, op.getSourceLocation());
        globalAggOperator.recomputeSchema();
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)globalAggOperator);
        MutableObject globalAgg = new MutableObject((Object)globalAggOperator);
        return new Pair((Object)globalAgg, globalAggResultVars);
    }

    private static Triple<MutableObject<ILogicalOperator>, List<LogicalVariable>, MutableObject<ILogicalOperator>> createDynamicMBRCalculator(AbstractBinaryJoinOperator op, IOptimizationContext context, Mutable<ILogicalOperator> inputOp, LogicalVariable inputVar) throws AlgebricksException {
        SourceLocation sourceLocation = op.getSourceLocation();
        ReplicateOperator replicateOperator = SpatialJoinUtils.createReplicateOperator(inputOp, context, sourceLocation, 2);
        ExchangeOperator exchToForward = SpatialJoinUtils.createRandomPartitionExchangeOp(replicateOperator, context, sourceLocation);
        MutableObject exchToForwardRef = new MutableObject((Object)exchToForward);
        ExchangeOperator exchToLocalAgg = SpatialJoinUtils.createOneToOneExchangeOp(replicateOperator, context, op.getSourceLocation());
        MutableObject exchToLocalAggRef = new MutableObject((Object)exchToLocalAgg);
        replicateOperator.getOutputMaterializationFlags()[0] = true;
        Pair<MutableObject<ILogicalOperator>, List<LogicalVariable>> createLocalAndGlobalAggResult = SpatialJoinUtils.createLocalAndGlobalAggregateOperators(op, context, inputVar, (MutableObject<ILogicalOperator>)exchToLocalAggRef);
        return new Triple((Object)((MutableObject)createLocalAndGlobalAggResult.first), (Object)((List)createLocalAndGlobalAggResult.second), (Object)exchToForwardRef);
    }

    private static AggregateOperator createAggregate(List<LogicalVariable> resultVariables, boolean isGlobal, List<Mutable<ILogicalExpression>> expressions, MutableObject<ILogicalOperator> inputOperator, IOptimizationContext context, SourceLocation sourceLocation) throws AlgebricksException {
        AggregateOperator aggregateOperator = new AggregateOperator(resultVariables, expressions);
        aggregateOperator.setPhysicalOperator((IPhysicalOperator)new AggregatePOperator());
        aggregateOperator.setSourceLocation(sourceLocation);
        aggregateOperator.getInputs().add(inputOperator);
        aggregateOperator.setGlobal(isGlobal);
        if (!isGlobal) {
            aggregateOperator.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
        } else {
            aggregateOperator.setExecutionMode(AbstractLogicalOperator.ExecutionMode.UNPARTITIONED);
        }
        aggregateOperator.recomputeSchema();
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)aggregateOperator);
        return aggregateOperator;
    }

    private static Mutable<ILogicalExpression> createRectangleExpression(SpatialJoinAnnotation spatialJoinAnn) {
        return new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new ARectangle(new APoint(spatialJoinAnn.getMinX(), spatialJoinAnn.getMinY()), new APoint(spatialJoinAnn.getMaxX(), spatialJoinAnn.getMaxY())))));
    }
}

