/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import org.apache.asterix.builders.ArrayListFactory;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.AbstractArrayProcessArraysEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;

@MissingNullInOutFunction
public class ArrayUnionDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private IAType[] argTypes;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ArrayUnionDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_ARGUMENTS_TYPE;
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_UNION;
    }

    public void setImmutableStates(Object ... states) {
        this.argTypes = (IAType[])states;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ArrayUnionEval(args, ctx);
            }
        };
    }

    public class ArrayUnionEval
    extends AbstractArrayProcessArraysEval {
        private final IObjectPool<List<IPointable>, ATypeTag> pointableListAllocator;
        private final IBinaryHashFunction binaryHashFunction;
        private final Int2ObjectMap<List<IPointable>> hashes;
        private final IBinaryComparator comp;

        ArrayUnionEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            super(args, ctx, ArrayUnionDescriptor.this.sourceLoc, ArrayUnionDescriptor.this.argTypes);
            this.pointableListAllocator = new ListObjectPool((IObjectFactory)new ArrayListFactory());
            this.hashes = new Int2ObjectOpenHashMap();
            this.comp = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)BuiltinType.ANY, (Object)BuiltinType.ANY, true).createBinaryComparator();
            this.binaryHashFunction = BinaryHashFunctionFactoryProvider.INSTANCE.getBinaryHashFunctionFactory((Object)BuiltinType.ANY).createBinaryHashFunction();
        }

        @Override
        protected void init() {
            this.hashes.clear();
        }

        @Override
        protected void finish(IAsterixListBuilder listBuilder) {
        }

        @Override
        protected void release() {
            this.pointableListAllocator.reset();
        }

        @Override
        protected boolean processItem(IPointable item, int listIndex, IAsterixListBuilder listBuilder) throws HyracksDataException {
            int hash = this.binaryHashFunction.hash(item.getByteArray(), item.getStartOffset(), item.getLength());
            List sameHashes = (List)this.hashes.get(hash);
            if (sameHashes == null) {
                sameHashes = (List)this.pointableListAllocator.allocate(null);
                sameHashes.clear();
                this.addItem(listBuilder, item, sameHashes);
                this.hashes.put(hash, (Object)sameHashes);
                return true;
            }
            if (PointableHelper.findItem((IValueReference)item, sameHashes, this.comp) == null) {
                this.addItem(listBuilder, item, sameHashes);
                return true;
            }
            return false;
        }

        private void addItem(IAsterixListBuilder listBuilder, IPointable item, List<IPointable> sameHashes) throws HyracksDataException {
            listBuilder.addItem((IValueReference)item);
            sameHashes.add(item);
        }
    }
}

