/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.AbstractConstVarFunVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class InlineAssignIntoAggregateRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.GROUP && op.getOperatorTag() != LogicalOperatorTag.WINDOW) {
            return false;
        }
        boolean changed = false;
        AbstractOperatorWithNestedPlans opWithNestedPlan = (AbstractOperatorWithNestedPlans)op;
        for (ILogicalPlan p : opWithNestedPlan.getNestedPlans()) {
            for (Mutable r : p.getRoots()) {
                changed |= this.inlined((ILogicalOperator)r.getValue(), opWithNestedPlan);
            }
        }
        return changed;
    }

    private boolean inlined(ILogicalOperator planRootOp, AbstractOperatorWithNestedPlans opWithNestedPlan) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)planRootOp;
        if (op1.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AggregateOperator aggOp = (AggregateOperator)op1;
        boolean inlined = this.inlineInputAssignIntoAgg(aggOp);
        if (opWithNestedPlan.getOperatorTag() == LogicalOperatorTag.WINDOW) {
            inlined |= this.inlineOuterInputAssignIntoAgg(aggOp, opWithNestedPlan);
        }
        return inlined;
    }

    private boolean inlineInputAssignIntoAgg(AggregateOperator aggOp) throws AlgebricksException {
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)((Mutable)aggOp.getInputs().get(0)).getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator assignOp = (AssignOperator)op2;
        VarExprSubstitution ves = new VarExprSubstitution(assignOp.getVariables(), assignOp.getExpressions());
        this.inlineVariables(aggOp, ves);
        List op1InpList = aggOp.getInputs();
        op1InpList.clear();
        op1InpList.add((Mutable)op2.getInputs().get(0));
        return true;
    }

    private boolean inlineOuterInputAssignIntoAgg(AggregateOperator aggOp, AbstractOperatorWithNestedPlans opWithNestedPlans) throws AlgebricksException {
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)((Mutable)opWithNestedPlans.getInputs().get(0)).getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator assignOp = (AssignOperator)op2;
        VarExprSubstitution ves = new VarExprSubstitution(assignOp.getVariables(), assignOp.getExpressions());
        return this.inlineVariables(aggOp, ves);
    }

    private boolean inlineVariables(AggregateOperator aggOp, VarExprSubstitution ves) throws AlgebricksException {
        boolean inlined = false;
        for (Mutable exprRef : aggOp.getExpressions()) {
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            Pair p = (Pair)expr.accept((ILogicalExpressionVisitor)ves, null);
            if (!((Boolean)p.first).booleanValue()) continue;
            exprRef.setValue((Object)((ILogicalExpression)p.second));
            inlined = true;
        }
        return inlined;
    }

    private class VarExprSubstitution
    extends AbstractConstVarFunVisitor<Pair<Boolean, ILogicalExpression>, Void> {
        private List<LogicalVariable> variables;
        private List<Mutable<ILogicalExpression>> expressions;

        public VarExprSubstitution(List<LogicalVariable> variables, List<Mutable<ILogicalExpression>> expressions) {
            this.variables = variables;
            this.expressions = expressions;
        }

        public Pair<Boolean, ILogicalExpression> visitConstantExpression(ConstantExpression expr, Void arg) {
            return new Pair((Object)false, (Object)expr);
        }

        public Pair<Boolean, ILogicalExpression> visitFunctionCallExpression(AbstractFunctionCallExpression expr, Void arg) throws AlgebricksException {
            boolean changed = false;
            for (Mutable eRef : expr.getArguments()) {
                ILogicalExpression e = (ILogicalExpression)eRef.getValue();
                Pair p = (Pair)e.accept((ILogicalExpressionVisitor)this, (Object)arg);
                if (!((Boolean)p.first).booleanValue()) continue;
                eRef.setValue((Object)((ILogicalExpression)p.second).cloneExpression());
                changed = true;
            }
            return new Pair((Object)changed, (Object)expr);
        }

        public Pair<Boolean, ILogicalExpression> visitVariableReferenceExpression(VariableReferenceExpression expr, Void arg) {
            LogicalVariable v = expr.getVariableReference();
            int idx = this.variables.indexOf(v);
            if (idx < 0) {
                return new Pair((Object)false, (Object)expr);
            }
            return new Pair((Object)true, (Object)((ILogicalExpression)this.expressions.get(idx).getValue()));
        }
    }
}

