/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.compression.file;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hyracks.api.compression.ICompressorDecompressor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.ICachedPageInternal;
import org.apache.hyracks.storage.common.compression.file.CompressedFileReference;
import org.apache.hyracks.storage.common.compression.file.ICompressedPageWriter;
import org.apache.hyracks.storage.common.compression.file.LAFWriter;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class CompressedFileManager {
    protected static final int SIZE_ENTRY_OFFSET = 8;
    protected static final int ENTRY_LENGTH = 16;
    protected static final int EOF = -1;
    private static final EnumSet<State> CLOSED = EnumSet.of(State.CLOSED);
    private static final EnumSet<State> CLOSED_OR_INVALID = EnumSet.of(State.CLOSED, State.INVALID);
    private static final EnumSet<State> OPEN = EnumSet.of(State.READABLE, State.WRITABLE);
    private static final EnumSet<State> OPEN_OR_INVALID = EnumSet.of(State.READABLE, State.WRITABLE, State.INVALID);
    private static final EnumSet<State> READABLE = EnumSet.of(State.READABLE);
    private static final EnumSet<State> WRITABLE = EnumSet.of(State.WRITABLE);
    private final IBufferCache bufferCache;
    private final ICompressorDecompressor compressorDecompressor;
    private final CompressedFileReference fileRef;
    private int fileId;
    private State state = State.CLOSED;
    private int totalNumOfPages = 0;
    private LAFWriter lafWriter;

    public CompressedFileManager(IBufferCache bufferCache, CompressedFileReference fileRef) {
        this.bufferCache = bufferCache;
        this.fileRef = fileRef;
        this.compressorDecompressor = fileRef.getCompressorDecompressor();
    }

    public boolean open() throws HyracksDataException {
        this.ensureState(CLOSED);
        boolean open = false;
        if (this.fileRef.getLAFFileReference().getFile().exists()) {
            this.fileId = this.bufferCache.openFile(this.fileRef.getLAFFileReference());
            open = true;
        } else {
            this.fileId = -1;
        }
        this.changeToFunctionalState();
        return open;
    }

    public boolean close() throws HyracksDataException {
        this.ensureState(OPEN_OR_INVALID);
        boolean closed = false;
        if (this.state != State.INVALID) {
            this.bufferCache.closeFile(this.fileId);
            this.state = State.CLOSED;
            closed = true;
        }
        return closed;
    }

    public void purge() throws HyracksDataException {
        if (this.close()) {
            this.bufferCache.purgeHandle(this.fileId);
        }
    }

    public void delete() throws HyracksDataException {
        this.ensureState(CLOSED_OR_INVALID);
        if (this.state != State.INVALID) {
            this.bufferCache.deleteFile(this.fileId);
        }
    }

    public void force(boolean metadata) throws HyracksDataException {
        this.ensureState(OPEN);
        this.bufferCache.force(this.fileId, metadata);
    }

    int getFileId() {
        return this.fileId;
    }

    public ICompressedPageWriter getCompressedPageWriter() {
        this.ensureState(WRITABLE);
        return this.lafWriter;
    }

    public long writePageInfo(long dpid, long size) throws HyracksDataException {
        int pageId = BufferedFileHandle.getPageId(dpid);
        return this.writeExtraPageInfo(pageId, size, 0);
    }

    public long writeExtraPageInfo(int extraPageId, long size, int extraPageIndex) throws HyracksDataException {
        long compressedPageOffset;
        this.ensureState(WRITABLE);
        try {
            compressedPageOffset = this.lafWriter.writePageInfo(extraPageId + extraPageIndex, size);
        }
        catch (HyracksDataException e) {
            this.lafWriter.abort();
            throw e;
        }
        return compressedPageOffset;
    }

    void endWriting(int totalNumOfPages) {
        this.ensureState(WRITABLE);
        this.totalNumOfPages = totalNumOfPages;
        this.lafWriter = null;
        this.state = State.READABLE;
    }

    public void setCompressedPageInfo(ICachedPageInternal compressedPage) throws HyracksDataException {
        this.setCompressedPageInfo(BufferedFileHandle.getPageId(compressedPage.getDiskPageId()), compressedPage);
    }

    public void setExtraCompressedPageInfo(ICachedPageInternal compressedPage, int extraPageIndex) throws HyracksDataException {
        this.setCompressedPageInfo(compressedPage.getExtraBlockPageId() + extraPageIndex, compressedPage);
    }

    public int getNumberOfPages() {
        return this.totalNumOfPages;
    }

    public ICompressorDecompressor getCompressorDecompressor() {
        return this.compressorDecompressor;
    }

    private void ensureState(EnumSet<State> expectedStates) {
        if (!expectedStates.contains((Object)this.state)) {
            throw new IllegalStateException("Expecting the state to be " + expectedStates + ". Currently it is " + this.state);
        }
    }

    private void changeToFunctionalState() throws HyracksDataException {
        if (this.fileId == -1) {
            this.state = State.INVALID;
        } else if (this.bufferCache.getNumPagesOfFile(this.fileId) == 0) {
            this.state = State.WRITABLE;
            this.lafWriter = new LAFWriter(this, this.bufferCache);
        } else {
            this.state = State.READABLE;
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws HyracksDataException {
        int numOfPages = this.bufferCache.getNumPagesOfFile(this.fileId);
        int numOfEntriesPerPage = this.bufferCache.getPageSize() / 16;
        long dpid = this.getDiskPageId(numOfPages - 1);
        ICachedPage page = this.bufferCache.pin(dpid, false);
        try {
            int i;
            ByteBuffer buf = page.getBuffer();
            for (i = 1; i < numOfEntriesPerPage && buf.getLong(i * 16) != -1L; ++i) {
            }
            this.totalNumOfPages = (numOfPages - 1) * numOfEntriesPerPage + i;
        }
        finally {
            this.bufferCache.unpin(page);
        }
    }

    private ICachedPage pinAndGetPage(int compressedPageId) throws HyracksDataException {
        int pageId = compressedPageId * 16 / this.bufferCache.getPageSize();
        return this.bufferCache.pin(this.getDiskPageId(pageId), false);
    }

    private long getDiskPageId(int pageId) {
        return BufferedFileHandle.getDiskPageId(this.fileId, pageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCompressedPageInfo(int compressedPageId, ICachedPageInternal compressedPage) throws HyracksDataException {
        this.ensureState(READABLE);
        if (this.totalNumOfPages == 0) {
            compressedPage.setCompressedPageOffset(0L);
            compressedPage.setCompressedPageSize(this.bufferCache.getPageSize());
            return;
        }
        ICachedPage page = this.pinAndGetPage(compressedPageId);
        try {
            ByteBuffer buf = page.getBuffer();
            int entryOffset = compressedPageId * 16 % this.bufferCache.getPageSize();
            compressedPage.setCompressedPageOffset(buf.getLong(entryOffset));
            compressedPage.setCompressedPageSize((int)buf.getLong(entryOffset + 8));
        }
        finally {
            this.bufferCache.unpin(page);
        }
    }

    private static enum State {
        READABLE,
        WRITABLE,
        INVALID,
        CLOSED;

    }
}

