/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.union;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractPushRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class MicroUnionAllRuntimeFactory
extends AbstractPushRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int inputArity;

    public MicroUnionAllRuntimeFactory(int inputArity) {
        this.inputArity = inputArity;
    }

    @Override
    public IPushRuntime[] createPushRuntime(IHyracksTaskContext ctx) {
        MutableObject failedShared = new MutableObject((Object)Boolean.FALSE);
        IPushRuntime[] result = new IPushRuntime[this.inputArity];
        for (int i = 0; i < this.inputArity; ++i) {
            result[i] = new MicroUnionAllPushRuntime(i, (Mutable<Boolean>)failedShared);
        }
        return result;
    }

    public String toString() {
        return "union-all";
    }

    private final class MicroUnionAllPushRuntime
    implements IPushRuntime {
        private final int idx;
        private final Mutable<Boolean> failedShared;
        private IFrameWriter writer;

        MicroUnionAllPushRuntime(int idx, Mutable<Boolean> failedShared) {
            this.idx = idx;
            this.failedShared = failedShared;
        }

        @Override
        public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) {
            if (index != 0) {
                throw new IllegalArgumentException(String.valueOf(index));
            }
            this.writer = writer;
        }

        @Override
        public void setInputRecordDescriptor(int index, RecordDescriptor recordDescriptor) {
        }

        public void open() throws HyracksDataException {
            if (this.idx == 0) {
                this.writer.open();
            }
        }

        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            this.writer.nextFrame(buffer);
        }

        public void fail() throws HyracksDataException {
            boolean failed = (Boolean)this.failedShared.getValue();
            this.failedShared.setValue((Object)Boolean.TRUE);
            if (!failed) {
                this.writer.fail();
            }
        }

        public void close() throws HyracksDataException {
            if (this.idx == 0) {
                this.writer.close();
            }
        }
    }
}

