/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.marshalling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class FloatSerializerDeserializer
implements ISerializerDeserializer<Float> {
    private static final long serialVersionUID = 1L;
    public static final FloatSerializerDeserializer INSTANCE = new FloatSerializerDeserializer();

    private FloatSerializerDeserializer() {
    }

    public Float deserialize(DataInput in) throws HyracksDataException {
        return Float.valueOf(FloatSerializerDeserializer.read(in));
    }

    public void serialize(Float instance, DataOutput out) throws HyracksDataException {
        FloatSerializerDeserializer.write(instance.floatValue(), out);
    }

    public static float read(DataInput in) throws HyracksDataException {
        try {
            return in.readFloat();
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static void write(float instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeFloat(instance);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

