/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.clause;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class LetClause
extends AbstractClause {
    private VariableExpr varExpr;
    private Expression bindExpr;

    public LetClause() {
    }

    public LetClause(VariableExpr varExpr, Expression bindExpr) {
        this.varExpr = varExpr;
        this.bindExpr = bindExpr;
    }

    public VariableExpr getVarExpr() {
        return this.varExpr;
    }

    public void setVarExpr(VariableExpr varExpr) {
        this.varExpr = varExpr;
    }

    public Expression getBindingExpr() {
        return this.bindExpr;
    }

    public void setBindingExpr(Expression bindExpr) {
        this.bindExpr = bindExpr;
    }

    @Override
    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.LET_CLAUSE;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int hashCode() {
        return Objects.hash(this.bindExpr, this.varExpr);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LetClause)) {
            return false;
        }
        LetClause target = (LetClause)object;
        return this.bindExpr.equals(target.getBindingExpr()) && this.varExpr.equals(target.getVarExpr());
    }
}

