/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.plan;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.PlanStabilityVerifier;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;

public final class PlanStructureVerifier {
    private static final String ERROR_MESSAGE_TEMPLATE_1 = "shared %s (%s) in %s";
    private static final String ERROR_MESSAGE_TEMPLATE_2 = "shared %s (%s) between %s and %s";
    private static final String ERROR_MESSAGE_TEMPLATE_3 = "missing output type environment in %s";
    private static final String ERROR_MESSAGE_TEMPLATE_4 = "missing schema in %s";
    private static final String ERROR_MESSAGE_TEMPLATE_5 = "produced variables %s that intersect used variables %s on %s in %s";
    private static final String ERROR_MESSAGE_TEMPLATE_6 = "undefined used variables %s in %s";
    private static final String ERROR_MESSAGE_TEMPLATE_7 = "unexpected source operator in NestedTupleSourceOperator: %s. Expected source operator %s";
    private static final String ERROR_MESSAGE_TEMPLATE_8 = "unexpected leaf operator in nested plan: %s";
    public static final Comparator<LogicalVariable> VARIABLE_CMP = Comparator.comparing(LogicalVariable::toString);
    private final ExpressionReferenceVerifierVisitor exprVisitor = new ExpressionReferenceVerifierVisitor();
    private final Map<Mutable<ILogicalOperator>, ILogicalOperator> opRefMap = new IdentityHashMap<Mutable<ILogicalOperator>, ILogicalOperator>();
    private final Map<ILogicalOperator, ILogicalOperator> opMap = new IdentityHashMap<ILogicalOperator, ILogicalOperator>();
    private final Map<Mutable<ILogicalExpression>, ILogicalOperator> exprRefMap = new IdentityHashMap<Mutable<ILogicalExpression>, ILogicalOperator>();
    private final Map<ILogicalExpression, ILogicalOperator> exprMap = new IdentityHashMap<ILogicalExpression, ILogicalOperator>();
    private final Deque<Pair<Mutable<ILogicalOperator>, ILogicalOperator>> workQueue = new ArrayDeque<Pair<Mutable<ILogicalOperator>, ILogicalOperator>>();
    private final Set<LogicalVariable> tmpVarSet1 = new HashSet<LogicalVariable>();
    private final Set<LogicalVariable> tmpVarSet2 = new HashSet<LogicalVariable>();
    private final IPlanPrettyPrinter prettyPrinter;
    private final ITypingContext typeEnvProvider;
    private boolean ensureTypeEnv;
    private boolean ensureSchema;

    public PlanStructureVerifier(IPlanPrettyPrinter prettyPrinter, ITypingContext typeEnvProvider) {
        this.prettyPrinter = prettyPrinter;
        this.typeEnvProvider = typeEnvProvider;
    }

    public void verifyPlanStructure(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        this.reset();
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        this.ensureTypeEnv = this.typeEnvProvider.getOutputTypeEnvironment(op) != null;
        this.ensureSchema = op.getSchema() != null;
        this.walk(opRef);
        this.reset();
    }

    private void reset() {
        this.opRefMap.clear();
        this.opMap.clear();
        this.exprRefMap.clear();
        this.exprMap.clear();
        this.ensureTypeEnv = false;
        this.ensureSchema = false;
    }

    private void walk(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        Pair<Mutable<ILogicalOperator>, ILogicalOperator> p;
        if (!this.workQueue.isEmpty()) {
            throw new IllegalStateException();
        }
        this.workQueue.add((Pair<Mutable<ILogicalOperator>, ILogicalOperator>)new Pair(opRef, null));
        while ((p = this.workQueue.pollFirst()) != null) {
            Mutable currentOpRef = (Mutable)p.first;
            ILogicalOperator currentOp = (ILogicalOperator)currentOpRef.getValue();
            ILogicalOperator parentOp = (ILogicalOperator)p.second;
            List<Mutable<ILogicalOperator>> childOps = this.visitOp((Mutable<ILogicalOperator>)currentOpRef, parentOp);
            for (Mutable<ILogicalOperator> childOpRef : childOps) {
                ILogicalOperator childOp = (ILogicalOperator)childOpRef.getValue();
                if (!OperatorPropertiesUtil.isMultiOutputOperator(childOp) && this.opMap.containsKey(childOp)) {
                    throw new AlgebricksException("cycle: " + PlanStabilityVerifier.printOperator(childOp, this.prettyPrinter));
                }
                this.workQueue.add((Pair<Mutable<ILogicalOperator>, ILogicalOperator>)new Pair(childOpRef, (Object)currentOp));
            }
        }
    }

    private List<Mutable<ILogicalOperator>> visitOp(Mutable<ILogicalOperator> opRef, ILogicalOperator parentOp) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        ILogicalOperator firstParentOp = this.opRefMap.put(opRef, parentOp);
        if (firstParentOp != null) {
            this.raiseException("operator reference (Mutable) to", PlanStabilityVerifier.printOperator(op, this.prettyPrinter), firstParentOp, parentOp);
        }
        if (OperatorPropertiesUtil.isMultiOutputOperator(op) && this.opMap.containsKey(op)) {
            return Collections.emptyList();
        }
        firstParentOp = this.opMap.put(op, parentOp);
        if (firstParentOp != null) {
            this.raiseException("operator instance", PlanStabilityVerifier.printOperator(op, this.prettyPrinter), firstParentOp, parentOp);
        }
        this.exprVisitor.setOperator(op);
        op.acceptExpressionTransform(this.exprVisitor);
        this.checkOperatorTypeEnvironment(op);
        this.checkOperatorSchema(op);
        this.checkOperatorVariables(op);
        List<Mutable<ILogicalOperator>> children = op.getInputs();
        if (op instanceof AbstractOperatorWithNestedPlans) {
            children = new ArrayList<Mutable<ILogicalOperator>>(children);
            for (ILogicalPlan nestedPlan : ((AbstractOperatorWithNestedPlans)op).getNestedPlans()) {
                for (Mutable<ILogicalOperator> nestedRootRef : nestedPlan.getRoots()) {
                    this.checkLeafOperatorsInNestedPlan(op, nestedRootRef);
                    children.add(nestedRootRef);
                }
            }
        }
        return children;
    }

    private void checkOperatorTypeEnvironment(ILogicalOperator op) throws AlgebricksException {
        if (this.ensureTypeEnv && this.typeEnvProvider.getOutputTypeEnvironment(op) == null) {
            throw new AlgebricksException(String.format(ERROR_MESSAGE_TEMPLATE_3, PlanStabilityVerifier.printOperator(op, this.prettyPrinter)));
        }
    }

    private void checkOperatorSchema(ILogicalOperator op) throws AlgebricksException {
        if (this.ensureSchema && op.getSchema() == null) {
            throw new AlgebricksException(String.format(ERROR_MESSAGE_TEMPLATE_4, PlanStabilityVerifier.printOperator(op, this.prettyPrinter)));
        }
    }

    private void checkOperatorVariables(ILogicalOperator op) throws AlgebricksException {
        if (op instanceof AbstractOperatorWithNestedPlans) {
            return;
        }
        this.tmpVarSet1.clear();
        VariableUtilities.getUsedVariables(op, this.tmpVarSet1);
        if (!this.tmpVarSet1.isEmpty()) {
            this.ensureUsedVarsAreDefined(op, this.tmpVarSet1);
            this.ensureProducedVarsDisjointFromUsedVars(op, this.tmpVarSet1);
        }
    }

    private void ensureUsedVarsAreDefined(ILogicalOperator op, Collection<LogicalVariable> usedVars) throws AlgebricksException {
        if (!this.ensureTypeEnv) {
            return;
        }
        this.tmpVarSet2.clear();
        this.tmpVarSet2.addAll(usedVars);
        Set<LogicalVariable> usedVarsCopy = this.tmpVarSet2;
        for (Mutable<ILogicalOperator> childRef : op.getInputs()) {
            ILogicalOperator childOp = (ILogicalOperator)childRef.getValue();
            IVariableTypeEnvironment childOpTypeEnv = this.typeEnvProvider.getOutputTypeEnvironment(childOp);
            if (childOpTypeEnv == null) {
                throw new AlgebricksException(String.format(ERROR_MESSAGE_TEMPLATE_3, PlanStabilityVerifier.printOperator(childOp, this.prettyPrinter)));
            }
            Iterator<LogicalVariable> i = usedVarsCopy.iterator();
            while (i.hasNext()) {
                LogicalVariable usedVar = i.next();
                if (childOpTypeEnv.getVarType(usedVar) == null) continue;
                i.remove();
            }
        }
        if (!usedVarsCopy.isEmpty()) {
            throw new AlgebricksException(String.format(ERROR_MESSAGE_TEMPLATE_6, this.sorted(usedVarsCopy, VARIABLE_CMP), PlanStabilityVerifier.printOperator(op, this.prettyPrinter)));
        }
    }

    private void ensureProducedVarsDisjointFromUsedVars(ILogicalOperator op, Set<LogicalVariable> usedVars) throws AlgebricksException {
        this.tmpVarSet2.clear();
        VariableUtilities.getProducedVariables(op, this.tmpVarSet2);
        Set<LogicalVariable> producedVars = this.tmpVarSet2;
        Collection intersection = CollectionUtils.intersection(producedVars, usedVars);
        if (!intersection.isEmpty()) {
            throw new AlgebricksException(String.format(ERROR_MESSAGE_TEMPLATE_5, this.sorted(producedVars, VARIABLE_CMP), this.sorted(usedVars, VARIABLE_CMP), this.sorted(intersection, VARIABLE_CMP), PlanStabilityVerifier.printOperator(op, this.prettyPrinter)));
        }
    }

    private void checkLeafOperatorsInNestedPlan(ILogicalOperator op, Mutable<ILogicalOperator> rootRef) throws AlgebricksException {
        block4: for (Mutable<ILogicalOperator> leafRef : OperatorManipulationUtil.findLeafDescendantsOrSelf(rootRef)) {
            ILogicalOperator leafOp = (ILogicalOperator)leafRef.getValue();
            switch (leafOp.getOperatorTag()) {
                case EMPTYTUPLESOURCE: {
                    continue block4;
                }
                case NESTEDTUPLESOURCE: {
                    NestedTupleSourceOperator ntsOp = (NestedTupleSourceOperator)leafOp;
                    ILogicalOperator ntsSrcOp = (ILogicalOperator)ntsOp.getDataSourceReference().getValue();
                    if (ntsSrcOp == op) continue block4;
                    throw new AlgebricksException(String.format(ERROR_MESSAGE_TEMPLATE_7, PlanStabilityVerifier.printOperator(ntsSrcOp, this.prettyPrinter), PlanStabilityVerifier.printOperator(op, this.prettyPrinter)));
                }
            }
            throw new AlgebricksException(String.format(ERROR_MESSAGE_TEMPLATE_8, PlanStabilityVerifier.printOperator(leafOp, this.prettyPrinter)));
        }
    }

    private void raiseException(String sharedReferenceKind, String sharedEntity, ILogicalOperator firstOp, ILogicalOperator secondOp) throws AlgebricksException {
        String errorMessage = firstOp == secondOp ? String.format(ERROR_MESSAGE_TEMPLATE_1, sharedReferenceKind, sharedEntity, PlanStabilityVerifier.printOperator(firstOp, this.prettyPrinter)) : String.format(ERROR_MESSAGE_TEMPLATE_2, sharedReferenceKind, sharedEntity, PlanStabilityVerifier.printOperator(firstOp, this.prettyPrinter), PlanStabilityVerifier.printOperator(secondOp, this.prettyPrinter));
        throw new AlgebricksException(errorMessage);
    }

    private <T> List<T> sorted(Collection<T> inColl, Comparator<T> comparator) {
        return inColl.stream().sorted(comparator).collect(Collectors.toList());
    }

    private final class ExpressionReferenceVerifierVisitor
    implements ILogicalExpressionReferenceTransform {
        private ILogicalOperator currentOp;

        private ExpressionReferenceVerifierVisitor() {
        }

        void setOperator(ILogicalOperator currentOp) {
            this.currentOp = Objects.requireNonNull(currentOp);
        }

        @Override
        public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            ILogicalOperator firstOp = PlanStructureVerifier.this.exprRefMap.put(exprRef, this.currentOp);
            if (firstOp != null) {
                PlanStructureVerifier.this.raiseException("expression reference (Mutable) to", PlanStabilityVerifier.printExpression(expr, PlanStructureVerifier.this.prettyPrinter), firstOp, this.currentOp);
            }
            if (expr.getExpressionTag() != LogicalExpressionTag.CONSTANT && (firstOp = PlanStructureVerifier.this.exprMap.put(expr, this.currentOp)) != null) {
                PlanStructureVerifier.this.raiseException("expression instance", PlanStabilityVerifier.printExpression(expr, PlanStructureVerifier.this.prettyPrinter), firstOp, this.currentOp);
            }
            if (expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                AbstractFunctionCallExpression callExpr = (AbstractFunctionCallExpression)expr;
                for (Mutable<ILogicalExpression> argRef : callExpr.getArguments()) {
                    this.transform(argRef);
                }
            }
            return false;
        }
    }
}

