/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.java.base;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.io.DataOutput;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.api.IJType;
import org.apache.asterix.external.library.java.base.JList;
import org.apache.asterix.external.library.java.base.JObject;
import org.apache.asterix.om.base.AMutableUnorderedList;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public final class JUnorderedList
extends JList<Multiset<? extends Object>> {
    private AUnorderedListType listType;

    public JUnorderedList(IJType elementType) {
        this.jObjects = HashMultiset.create();
        this.listType = new AUnorderedListType(elementType.getIAType(), null);
    }

    public JUnorderedList(IAType elementType) {
        this.jObjects = HashMultiset.create();
        this.listType = new AUnorderedListType(elementType, null);
    }

    @Override
    public Multiset<? extends Object> getValueGeneric() {
        return (Multiset)this.jObjects;
    }

    @Override
    public IAType getIAType() {
        return this.listType;
    }

    @Override
    public IAObject getIAObject() {
        AMutableUnorderedList v = new AMutableUnorderedList(this.listType);
        for (IJObject jObj : this.jObjects) {
            v.add(jObj.getIAObject());
        }
        return v;
    }

    @Override
    public void setValueGeneric(Multiset<? extends Object> vals) throws HyracksDataException {
        this.reset();
        for (Object v : vals) {
            IAType asxClass = JObject.convertType(v.getClass());
            IJObject obj = (IJObject)this.pool.allocate((Object)asxClass);
            if (this.listType == null) {
                this.listType = new AUnorderedListType(obj.getIAType(), "");
            }
            obj.setValueGeneric(v);
            this.add(obj);
        }
    }

    @Override
    public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
        UnorderedListBuilder listBuilder = new UnorderedListBuilder();
        listBuilder.reset((AbstractCollectionType)this.listType);
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        for (IJObject jObject : this.jObjects) {
            fieldValue.reset();
            jObject.serialize(fieldValue.getDataOutput(), writeTypeTag);
            listBuilder.addItem((IValueReference)fieldValue);
        }
        listBuilder.write(dataOutput, writeTypeTag);
    }

    @Override
    public void reset() {
        this.jObjects.clear();
    }
}

