/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import org.apache.commons.beanutils2.BeanToPropertyValueTransformer;
import org.apache.commons.beanutils2.TestBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanToPropertyValueTransformerTest {
    private static final Integer expectedIntegerValue = 123;
    private static final Long expectedLongValue = 123L;
    private static final Float expectedFloatValue = Float.valueOf(123.123f);
    private static final Double expectedDoubleValue = 567879.12344;
    private static final Boolean expectedBooleanValue = Boolean.TRUE;
    private static final Byte expectedByteValue = Byte.valueOf("12");

    @Test
    public void testTransformWithIndexedProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("intIndexed[0]");
        TestBean testBean = new TestBean();
        testBean.setIntIndexed(0, expectedIntegerValue);
        Assertions.assertEquals((Integer)expectedIntegerValue, (Integer)((Integer)transformer.apply((Object)testBean)));
        BeanToPropertyValueTransformer transformer2 = new BeanToPropertyValueTransformer("intIndexed[9999]");
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> transformer2.apply((Object)testBean));
    }

    @Test
    public void testTransformWithInvalidProperty() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanToPropertyValueTransformer("bogusProperty").apply((Object)new TestBean()));
    }

    @Test
    public void testTransformWithMappedProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("mappedProperty(test-key)");
        TestBean testBean = new TestBean();
        testBean.setMappedProperty("test-key", "test-value");
        Assertions.assertEquals((Object)"test-value", (Object)transformer.apply((Object)testBean));
        transformer = new BeanToPropertyValueTransformer("mappedProperty(bogus-key)");
        Assertions.assertNull((Object)transformer.apply((Object)testBean));
    }

    @Test
    public void testTransformWithNestedIndexedProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("anotherNested.intIndexed[0]");
        TestBean testBean = new TestBean();
        TestBean nestedBean = new TestBean();
        nestedBean.setIntIndexed(0, expectedIntegerValue);
        testBean.setAnotherNested(nestedBean);
        Assertions.assertEquals((Integer)expectedIntegerValue, (Integer)((Integer)transformer.apply((Object)testBean)));
    }

    @Test
    public void testTransformWithNestedProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("anotherNested.stringProperty");
        TestBean testBean = new TestBean();
        TestBean nestedBean = new TestBean("foo");
        testBean.setAnotherNested(nestedBean);
        Assertions.assertEquals((Object)"foo", (Object)transformer.apply((Object)testBean));
    }

    @Test
    public void testTransformWithNullInPath() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("anotherNested.stringProperty");
        Assertions.assertThrows(IllegalArgumentException.class, () -> transformer.apply((Object)new TestBean()));
    }

    @Test
    public void testTransformWithNullInPathAndIgnoreTrue() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("anotherNested.stringProperty", true);
        Assertions.assertNull((Object)transformer.apply((Object)new TestBean()));
    }

    @Test
    public void testTransformWithReadOnlyProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("readOnlyProperty");
        TestBean testBean = new TestBean();
        Assertions.assertEquals((Object)testBean.getReadOnlyProperty(), (Object)transformer.apply((Object)testBean));
    }

    @Test
    public void testTransformWithSimpleBooleanProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("booleanProperty");
        TestBean testBean = new TestBean((boolean)expectedBooleanValue);
        Assertions.assertEquals((Object)expectedBooleanValue, (Object)transformer.apply((Object)testBean));
    }

    @Test
    public void testTransformWithSimpleByteProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("byteProperty");
        TestBean testBean = new TestBean();
        testBean.setByteProperty(expectedByteValue);
        Assertions.assertEquals((Byte)expectedByteValue, (Byte)((Byte)transformer.apply((Object)testBean)));
    }

    @Test
    public void testTransformWithSimpleDoubleProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("doubleProperty");
        TestBean testBean = new TestBean(expectedDoubleValue);
        Assertions.assertEquals((Double)expectedDoubleValue, (Double)((Double)transformer.apply((Object)testBean)));
    }

    @Test
    public void testTransformWithSimpleFloatProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("floatProperty");
        TestBean testBean = new TestBean(expectedFloatValue.floatValue());
        Assertions.assertEquals((Float)expectedFloatValue, (Float)((Float)transformer.apply((Object)testBean)));
    }

    @Test
    public void testTransformWithSimpleIntProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("intProperty");
        TestBean testBean = new TestBean((int)expectedIntegerValue);
        Assertions.assertEquals((Integer)expectedIntegerValue, (Integer)((Integer)transformer.apply((Object)testBean)));
    }

    @Test
    public void testTransformWithSimpleLongProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("longProperty");
        TestBean testBean = new TestBean();
        testBean.setLongProperty(expectedLongValue);
        Assertions.assertEquals((Long)expectedLongValue, (Long)((Long)transformer.apply((Object)testBean)));
    }

    @Test
    public void testTransformWithSimpleStringProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("stringProperty");
        TestBean testBean = new TestBean("foo");
        Assertions.assertEquals((Object)"foo", (Object)transformer.apply((Object)testBean));
    }

    @Test
    public void testTransformWithSimpleStringPropertyAndNullValue() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("stringProperty");
        TestBean testBean = new TestBean((String)null);
        Assertions.assertNull((Object)transformer.apply((Object)testBean));
    }

    @Test
    public void testTransformWithWriteOnlyProperty() {
        try {
            new BeanToPropertyValueTransformer("writeOnlyProperty").apply((Object)new TestBean());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

