/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.beans.IntrospectionException;
import org.apache.commons.beanutils2.BeanUtils;
import org.apache.commons.beanutils2.MappedPropertyChildBean;
import org.apache.commons.beanutils2.MappedPropertyChildInterface;
import org.apache.commons.beanutils2.MappedPropertyDescriptor;
import org.apache.commons.beanutils2.MappedPropertyTestBean;
import org.apache.commons.beanutils2.MappedPropertyTestInterface;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MappedPropertyTest {
    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void testAnyArgsProperty() throws Exception {
        String property = "anyMapped";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        MappedPropertyDescriptor desc = new MappedPropertyDescriptor("anyMapped", clazz);
        Assertions.assertNull((Object)desc.getMappedReadMethod(), (String)"Getter is found");
        Assertions.assertNotNull((Object)desc.getMappedWriteMethod(), (String)"Setter is missing");
    }

    @Test
    public void testBooleanMapped() throws Exception {
        String property = "mappedBoolean";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mappedBoolean", clazz);
        Assertions.assertNotNull((Object)desc.getMappedReadMethod(), (String)"Getter is missing");
        Assertions.assertNotNull((Object)desc.getMappedWriteMethod(), (String)"Setter is missing");
    }

    @Test
    public void testChildInterfaceMapped() throws Exception {
        String property = "mapproperty";
        Class<MappedPropertyChildInterface> clazz = MappedPropertyChildInterface.class;
        MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mapproperty", clazz);
        Assertions.assertNotNull((Object)desc.getMappedReadMethod(), (String)"Getter is missing");
        Assertions.assertNotNull((Object)desc.getMappedWriteMethod(), (String)"Setter is missing");
    }

    @Test
    public void testDifferentTypes() throws Exception {
        String property = "differentTypes";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        MappedPropertyDescriptor desc = new MappedPropertyDescriptor("differentTypes", clazz);
        Assertions.assertNotNull((Object)desc.getMappedReadMethod(), (String)"Getter is missing");
        Assertions.assertNull((Object)desc.getMappedWriteMethod(), (String)"Setter is found");
    }

    @Test
    public void testFound() throws Exception {
        String property = "mapproperty";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mapproperty", clazz);
        Assertions.assertNotNull((Object)desc.getMappedReadMethod(), (String)"Getter is missing");
        Assertions.assertNotNull((Object)desc.getMappedWriteMethod(), (String)"Setter is missing");
    }

    @Test
    public void testInterfaceMapped() throws Exception {
        String property = "mapproperty";
        Class<MappedPropertyTestInterface> clazz = MappedPropertyTestInterface.class;
        MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mapproperty", clazz);
        Assertions.assertNotNull((Object)desc.getMappedReadMethod(), (String)"Getter is missing");
        Assertions.assertNotNull((Object)desc.getMappedWriteMethod(), (String)"Setter is missing");
    }

    @Test
    public void testInterfaceNotFound() {
        String property = "XXXXXX";
        Class<MappedPropertyTestInterface> clazz = MappedPropertyTestInterface.class;
        Assertions.assertThrows(IntrospectionException.class, () -> new MappedPropertyDescriptor("XXXXXX", clazz));
    }

    @Test
    public void testInvalidGetter() throws Exception {
        String property = "invalidGetter";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        MappedPropertyDescriptor desc = new MappedPropertyDescriptor("invalidGetter", clazz);
        Assertions.assertNull((Object)desc.getMappedReadMethod(), (String)"Getter is found");
        Assertions.assertNotNull((Object)desc.getMappedWriteMethod(), (String)"Setter is missing");
    }

    @Test
    public void testInvalidSetter() throws Exception {
        String property = "invalidSetter";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        MappedPropertyDescriptor desc = new MappedPropertyDescriptor("invalidSetter", clazz);
        Assertions.assertNotNull((Object)desc.getMappedReadMethod(), (String)"Getter is missing");
        Assertions.assertNull((Object)desc.getMappedWriteMethod(), (String)"Setter is found");
    }

    @Test
    public void testMapGetter() throws Exception {
        MappedPropertyTestBean bean = new MappedPropertyTestBean();
        String testValue = "test value";
        String testKey = "testKey";
        BeanUtils.setProperty((Object)bean, (String)"myMap(testKey)", (Object)"test value");
        Assertions.assertEquals((Object)"test value", (Object)bean.getMyMap().get("testKey"), (String)"Map getter");
    }

    @Test
    public void testMappedGetterOnly() throws Exception {
        String property = "mappedGetterOnly";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mappedGetterOnly", clazz);
        Assertions.assertNotNull((Object)desc.getMappedReadMethod(), (String)"Getter is missing");
        Assertions.assertNull((Object)desc.getMappedWriteMethod(), (String)"Setter is found");
    }

    @Test
    public void testMappedSetterOnly() throws Exception {
        String property = "mappedSetterOnly";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mappedSetterOnly", clazz);
        Assertions.assertNull((Object)desc.getMappedReadMethod(), (String)"Getter is found");
        Assertions.assertNotNull((Object)desc.getMappedWriteMethod(), (String)"Setter is missing");
    }

    @Test
    public void testNotFound() {
        String property = "xxxxxxx";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        Assertions.assertThrows(IntrospectionException.class, () -> new MappedPropertyDescriptor("xxxxxxx", clazz));
    }

    @Test
    public void testPrimitiveArgsProperty() throws Exception {
        String property = "mappedPrimitive";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mappedPrimitive", clazz);
        Assertions.assertNull((Object)desc.getMappedReadMethod(), (String)"Getter is found");
        Assertions.assertNotNull((Object)desc.getMappedWriteMethod(), (String)"Setter is missing");
    }

    @Test
    public void testProtected() {
        String property = "protectedProperty";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        Assertions.assertThrows(IntrospectionException.class, () -> new MappedPropertyDescriptor("protectedProperty", clazz));
    }

    @Test
    public void testProtectedParentMethod() {
        String property = "protectedMapped";
        Class<MappedPropertyChildBean> clazz = MappedPropertyChildBean.class;
        Assertions.assertThrows(IntrospectionException.class, () -> new MappedPropertyDescriptor("protectedMapped", clazz));
    }

    @Test
    public void testPublicParentMethod() throws Exception {
        String property = "mapproperty";
        Class<MappedPropertyChildBean> clazz = MappedPropertyChildBean.class;
        MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mapproperty", clazz);
        Assertions.assertNotNull((Object)desc.getMappedReadMethod(), (String)"Getter is missing");
        Assertions.assertNotNull((Object)desc.getMappedWriteMethod(), (String)"Setter is missing");
    }
}

