/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.random.Well1024a;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldVector3DTest {
    @Test
    public void testConstructors() throws DimensionMismatchException {
        double cosAlpha = 0.5;
        double sinAlpha = FastMath.sqrt((double)3.0) / 2.0;
        double cosDelta = FastMath.sqrt((double)2.0) / 2.0;
        double sinDelta = -FastMath.sqrt((double)2.0) / 2.0;
        FieldVector3D u = new FieldVector3D(2.0, new FieldVector3D((RealFieldElement)new DerivativeStructure(2, 1, 0, 1.0471975511965976), (RealFieldElement)new DerivativeStructure(2, 1, 1, -0.7853981633974483)));
        this.checkVector((FieldVector3D<DerivativeStructure>)u, 2.0 * cosAlpha * cosDelta, 2.0 * sinAlpha * cosDelta, 2.0 * sinDelta);
        Assert.assertEquals((double)(-2.0 * sinAlpha * cosDelta), (double)((DerivativeStructure)u.getX()).getPartialDerivative(new int[]{1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)(2.0 * cosAlpha * cosDelta), (double)((DerivativeStructure)u.getY()).getPartialDerivative(new int[]{1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)u.getZ()).getPartialDerivative(new int[]{1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)(-2.0 * cosAlpha * sinDelta), (double)((DerivativeStructure)u.getX()).getPartialDerivative(new int[]{0, 1}), (double)1.0E-12);
        Assert.assertEquals((double)(-2.0 * sinAlpha * sinDelta), (double)((DerivativeStructure)u.getY()).getPartialDerivative(new int[]{0, 1}), (double)1.0E-12);
        Assert.assertEquals((double)(2.0 * cosDelta), (double)((DerivativeStructure)u.getZ()).getPartialDerivative(new int[]{0, 1}), (double)1.0E-12);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D(2.0, this.createVector(1.0, 0.0, 0.0, 3)), 2.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 2.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement)new DerivativeStructure(4, 1, 3, 2.0), this.createVector(1.0, 0.0, 0.0, 4)), 2.0, 0.0, 0.0, 2.0, 0.0, 0.0, 1.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement)new DerivativeStructure(4, 1, 3, 2.0), new Vector3D(1.0, 0.0, 0.0)), 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D(2.0, this.createVector(1.0, 0.0, 0.0, 3), -3.0, this.createVector(0.0, 0.0, -1.0, 3)), 2.0, 0.0, 3.0, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement)new DerivativeStructure(4, 1, 3, 2.0), this.createVector(1.0, 0.0, 0.0, 4), (RealFieldElement)new DerivativeStructure(4, 1, 3, -3.0), this.createVector(0.0, 0.0, -1.0, 4)), 2.0, 0.0, 3.0, -1.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0, -1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement)new DerivativeStructure(4, 1, 3, 2.0), new Vector3D(1.0, 0.0, 0.0), (RealFieldElement)new DerivativeStructure(4, 1, 3, -3.0), new Vector3D(0.0, 0.0, -1.0)), 2.0, 0.0, 3.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D(2.0, this.createVector(1.0, 0.0, 0.0, 3), 5.0, this.createVector(0.0, 1.0, 0.0, 3), -3.0, this.createVector(0.0, 0.0, -1.0, 3)), 2.0, 5.0, 3.0, 4.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0, 0.0, 4.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement)new DerivativeStructure(4, 1, 3, 2.0), this.createVector(1.0, 0.0, 0.0, 4), (RealFieldElement)new DerivativeStructure(4, 1, 3, 5.0), this.createVector(0.0, 1.0, 0.0, 4), (RealFieldElement)new DerivativeStructure(4, 1, 3, -3.0), this.createVector(0.0, 0.0, -1.0, 4)), 2.0, 5.0, 3.0, 4.0, 0.0, 0.0, 1.0, 0.0, 4.0, 0.0, 1.0, 0.0, 0.0, 4.0, -1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement)new DerivativeStructure(4, 1, 3, 2.0), new Vector3D(1.0, 0.0, 0.0), (RealFieldElement)new DerivativeStructure(4, 1, 3, 5.0), new Vector3D(0.0, 1.0, 0.0), (RealFieldElement)new DerivativeStructure(4, 1, 3, -3.0), new Vector3D(0.0, 0.0, -1.0)), 2.0, 5.0, 3.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D(2.0, this.createVector(1.0, 0.0, 0.0, 3), 5.0, this.createVector(0.0, 1.0, 0.0, 3), 5.0, this.createVector(0.0, -1.0, 0.0, 3), -3.0, this.createVector(0.0, 0.0, -1.0, 3)), 2.0, 0.0, 3.0, 9.0, 0.0, 0.0, 0.0, 9.0, 0.0, 0.0, 0.0, 9.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement)new DerivativeStructure(4, 1, 3, 2.0), this.createVector(1.0, 0.0, 0.0, 4), (RealFieldElement)new DerivativeStructure(4, 1, 3, 5.0), this.createVector(0.0, 1.0, 0.0, 4), (RealFieldElement)new DerivativeStructure(4, 1, 3, 5.0), this.createVector(0.0, -1.0, 0.0, 4), (RealFieldElement)new DerivativeStructure(4, 1, 3, -3.0), this.createVector(0.0, 0.0, -1.0, 4)), 2.0, 0.0, 3.0, 9.0, 0.0, 0.0, 1.0, 0.0, 9.0, 0.0, 0.0, 0.0, 0.0, 9.0, -1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement)new DerivativeStructure(4, 1, 3, 2.0), new Vector3D(1.0, 0.0, 0.0), (RealFieldElement)new DerivativeStructure(4, 1, 3, 5.0), new Vector3D(0.0, 1.0, 0.0), (RealFieldElement)new DerivativeStructure(4, 1, 3, 5.0), new Vector3D(0.0, -1.0, 0.0), (RealFieldElement)new DerivativeStructure(4, 1, 3, -3.0), new Vector3D(0.0, 0.0, -1.0)), 2.0, 0.0, 3.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)new FieldVector3D((RealFieldElement[])new DerivativeStructure[]{new DerivativeStructure(3, 1, 2, 2.0), new DerivativeStructure(3, 1, 1, 5.0), new DerivativeStructure(3, 1, 0, -3.0)}), 2.0, 5.0, -3.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0);
    }

    @Test
    public void testEquals() {
        FieldVector3D<DerivativeStructure> u1 = this.createVector(1.0, 2.0, 3.0, 3);
        FieldVector3D<DerivativeStructure> v = this.createVector(1.0, 2.0, 3.0 + 10.0 * Precision.EPSILON, 3);
        Assert.assertTrue((boolean)u1.equals(u1));
        Assert.assertTrue((boolean)u1.equals((Object)new FieldVector3D((RealFieldElement)new DerivativeStructure(3, 1, 0, 1.0), (RealFieldElement)new DerivativeStructure(3, 1, 1, 2.0), (RealFieldElement)new DerivativeStructure(3, 1, 2, 3.0))));
        Assert.assertFalse((boolean)u1.equals((Object)new FieldVector3D((RealFieldElement)new DerivativeStructure(3, 1, 1.0), (RealFieldElement)new DerivativeStructure(3, 1, 1, 2.0), (RealFieldElement)new DerivativeStructure(3, 1, 2, 3.0))));
        Assert.assertFalse((boolean)u1.equals((Object)new FieldVector3D((RealFieldElement)new DerivativeStructure(3, 1, 0, 1.0), (RealFieldElement)new DerivativeStructure(3, 1, 2.0), (RealFieldElement)new DerivativeStructure(3, 1, 2, 3.0))));
        Assert.assertFalse((boolean)u1.equals((Object)new FieldVector3D((RealFieldElement)new DerivativeStructure(3, 1, 0, 1.0), (RealFieldElement)new DerivativeStructure(3, 1, 1, 2.0), (RealFieldElement)new DerivativeStructure(3, 1, 3.0))));
        Assert.assertFalse((boolean)u1.equals(v));
        Assert.assertFalse((boolean)u1.equals((Object)u1.toVector3D()));
        Assert.assertTrue((boolean)this.createVector(0.0, Double.NaN, 0.0, 3).equals(this.createVector(0.0, 0.0, Double.NaN, 3)));
    }

    @Test
    public void testHash() {
        Assert.assertEquals((long)this.createVector(0.0, Double.NaN, 0.0, 3).hashCode(), (long)this.createVector(0.0, 0.0, Double.NaN, 3).hashCode());
        FieldVector3D<DerivativeStructure> u = this.createVector(1.0, 2.0, 3.0, 3);
        FieldVector3D<DerivativeStructure> v = this.createVector(1.0, 2.0, 3.0 + 10.0 * Precision.EPSILON, 3);
        Assert.assertTrue((u.hashCode() != v.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testInfinite() {
        Assert.assertTrue((boolean)this.createVector(1.0, 1.0, Double.NEGATIVE_INFINITY, 3).isInfinite());
        Assert.assertTrue((boolean)this.createVector(1.0, Double.NEGATIVE_INFINITY, 1.0, 3).isInfinite());
        Assert.assertTrue((boolean)this.createVector(Double.NEGATIVE_INFINITY, 1.0, 1.0, 3).isInfinite());
        Assert.assertFalse((boolean)this.createVector(1.0, 1.0, 2.0, 3).isInfinite());
        Assert.assertFalse((boolean)this.createVector(1.0, Double.NaN, Double.NEGATIVE_INFINITY, 3).isInfinite());
    }

    @Test
    public void testNaN() {
        Assert.assertTrue((boolean)this.createVector(1.0, 1.0, Double.NaN, 3).isNaN());
        Assert.assertTrue((boolean)this.createVector(1.0, Double.NaN, 1.0, 3).isNaN());
        Assert.assertTrue((boolean)this.createVector(Double.NaN, 1.0, 1.0, 3).isNaN());
        Assert.assertFalse((boolean)this.createVector(1.0, 1.0, 2.0, 3).isNaN());
        Assert.assertFalse((boolean)this.createVector(1.0, 1.0, Double.NEGATIVE_INFINITY, 3).isNaN());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"{3; 2; 1}", (Object)this.createVector(3.0, 2.0, 1.0, 3).toString());
        DecimalFormat format = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        Assert.assertEquals((Object)"{3.000; 2.000; 1.000}", (Object)this.createVector(3.0, 2.0, 1.0, 3).toString((NumberFormat)format));
    }

    @Test(expected=DimensionMismatchException.class)
    public void testWrongDimension() throws DimensionMismatchException {
        new FieldVector3D((RealFieldElement[])new DerivativeStructure[]{new DerivativeStructure(3, 1, 0, 2.0), new DerivativeStructure(3, 1, 0, 5.0)});
    }

    @Test
    public void testCoordinates() {
        FieldVector3D<DerivativeStructure> v = this.createVector(1.0, 2.0, 3.0, 3);
        Assert.assertTrue((FastMath.abs((double)(((DerivativeStructure)v.getX()).getReal() - 1.0)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(((DerivativeStructure)v.getY()).getReal() - 2.0)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(((DerivativeStructure)v.getZ()).getReal() - 3.0)) < 1.0E-12 ? 1 : 0) != 0);
        DerivativeStructure[] coordinates = (DerivativeStructure[])v.toArray();
        Assert.assertTrue((FastMath.abs((double)(coordinates[0].getReal() - 1.0)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(coordinates[1].getReal() - 2.0)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(coordinates[2].getReal() - 3.0)) < 1.0E-12 ? 1 : 0) != 0);
    }

    @Test
    public void testNorm1() {
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(0.0, 0.0, 0.0, 3).getNorm1()).getReal(), (double)0.0);
        Assert.assertEquals((double)6.0, (double)((DerivativeStructure)this.createVector(1.0, -2.0, 3.0, 3).getNorm1()).getReal(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)((DerivativeStructure)this.createVector(1.0, -2.0, 3.0, 3).getNorm1()).getPartialDerivative(new int[]{1, 0, 0}), (double)0.0);
        Assert.assertEquals((double)-1.0, (double)((DerivativeStructure)this.createVector(1.0, -2.0, 3.0, 3).getNorm1()).getPartialDerivative(new int[]{0, 1, 0}), (double)0.0);
        Assert.assertEquals((double)1.0, (double)((DerivativeStructure)this.createVector(1.0, -2.0, 3.0, 3).getNorm1()).getPartialDerivative(new int[]{0, 0, 1}), (double)0.0);
    }

    @Test
    public void testNorm() {
        double r = FastMath.sqrt((double)14.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(0.0, 0.0, 0.0, 3).getNorm()).getReal(), (double)0.0);
        Assert.assertEquals((double)r, (double)((DerivativeStructure)this.createVector(1.0, 2.0, 3.0, 3).getNorm()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)(1.0 / r), (double)((DerivativeStructure)this.createVector(1.0, 2.0, 3.0, 3).getNorm()).getPartialDerivative(new int[]{1, 0, 0}), (double)0.0);
        Assert.assertEquals((double)(2.0 / r), (double)((DerivativeStructure)this.createVector(1.0, 2.0, 3.0, 3).getNorm()).getPartialDerivative(new int[]{0, 1, 0}), (double)0.0);
        Assert.assertEquals((double)(3.0 / r), (double)((DerivativeStructure)this.createVector(1.0, 2.0, 3.0, 3).getNorm()).getPartialDerivative(new int[]{0, 0, 1}), (double)0.0);
    }

    @Test
    public void testNormSq() {
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(0.0, 0.0, 0.0, 3).getNormSq()).getReal(), (double)0.0);
        Assert.assertEquals((double)14.0, (double)((DerivativeStructure)this.createVector(1.0, 2.0, 3.0, 3).getNormSq()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)2.0, (double)((DerivativeStructure)this.createVector(1.0, 2.0, 3.0, 3).getNormSq()).getPartialDerivative(new int[]{1, 0, 0}), (double)0.0);
        Assert.assertEquals((double)4.0, (double)((DerivativeStructure)this.createVector(1.0, 2.0, 3.0, 3).getNormSq()).getPartialDerivative(new int[]{0, 1, 0}), (double)0.0);
        Assert.assertEquals((double)6.0, (double)((DerivativeStructure)this.createVector(1.0, 2.0, 3.0, 3).getNormSq()).getPartialDerivative(new int[]{0, 0, 1}), (double)0.0);
    }

    @Test
    public void testNormInf() {
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(0.0, 0.0, 0.0, 3).getNormInf()).getReal(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)((DerivativeStructure)this.createVector(1.0, -2.0, 3.0, 3).getNormInf()).getReal(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(1.0, -2.0, 3.0, 3).getNormInf()).getPartialDerivative(new int[]{1, 0, 0}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(1.0, -2.0, 3.0, 3).getNormInf()).getPartialDerivative(new int[]{0, 1, 0}), (double)0.0);
        Assert.assertEquals((double)1.0, (double)((DerivativeStructure)this.createVector(1.0, -2.0, 3.0, 3).getNormInf()).getPartialDerivative(new int[]{0, 0, 1}), (double)0.0);
        Assert.assertEquals((double)3.0, (double)((DerivativeStructure)this.createVector(2.0, -1.0, 3.0, 3).getNormInf()).getReal(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(2.0, -1.0, 3.0, 3).getNormInf()).getPartialDerivative(new int[]{1, 0, 0}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(2.0, -1.0, 3.0, 3).getNormInf()).getPartialDerivative(new int[]{0, 1, 0}), (double)0.0);
        Assert.assertEquals((double)1.0, (double)((DerivativeStructure)this.createVector(2.0, -1.0, 3.0, 3).getNormInf()).getPartialDerivative(new int[]{0, 0, 1}), (double)0.0);
        Assert.assertEquals((double)3.0, (double)((DerivativeStructure)this.createVector(1.0, -3.0, 2.0, 3).getNormInf()).getReal(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(1.0, -3.0, 2.0, 3).getNormInf()).getPartialDerivative(new int[]{1, 0, 0}), (double)0.0);
        Assert.assertEquals((double)-1.0, (double)((DerivativeStructure)this.createVector(1.0, -3.0, 2.0, 3).getNormInf()).getPartialDerivative(new int[]{0, 1, 0}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(1.0, -3.0, 2.0, 3).getNormInf()).getPartialDerivative(new int[]{0, 0, 1}), (double)0.0);
        Assert.assertEquals((double)3.0, (double)((DerivativeStructure)this.createVector(2.0, -3.0, 1.0, 3).getNormInf()).getReal(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(2.0, -3.0, 1.0, 3).getNormInf()).getPartialDerivative(new int[]{1, 0, 0}), (double)0.0);
        Assert.assertEquals((double)-1.0, (double)((DerivativeStructure)this.createVector(2.0, -3.0, 1.0, 3).getNormInf()).getPartialDerivative(new int[]{0, 1, 0}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(2.0, -3.0, 1.0, 3).getNormInf()).getPartialDerivative(new int[]{0, 0, 1}), (double)0.0);
        Assert.assertEquals((double)3.0, (double)((DerivativeStructure)this.createVector(3.0, -1.0, 2.0, 3).getNormInf()).getReal(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)((DerivativeStructure)this.createVector(3.0, -1.0, 2.0, 3).getNormInf()).getPartialDerivative(new int[]{1, 0, 0}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(3.0, -1.0, 2.0, 3).getNormInf()).getPartialDerivative(new int[]{0, 1, 0}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(3.0, -1.0, 2.0, 3).getNormInf()).getPartialDerivative(new int[]{0, 0, 1}), (double)0.0);
        Assert.assertEquals((double)3.0, (double)((DerivativeStructure)this.createVector(3.0, -2.0, 1.0, 3).getNormInf()).getReal(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)((DerivativeStructure)this.createVector(3.0, -2.0, 1.0, 3).getNormInf()).getPartialDerivative(new int[]{1, 0, 0}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(3.0, -2.0, 1.0, 3).getNormInf()).getPartialDerivative(new int[]{0, 1, 0}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(3.0, -2.0, 1.0, 3).getNormInf()).getPartialDerivative(new int[]{0, 0, 1}), (double)0.0);
    }

    @Test
    public void testDistance1() {
        FieldVector3D<DerivativeStructure> v1 = this.createVector(1.0, -2.0, 3.0, 3);
        FieldVector3D<DerivativeStructure> v2 = this.createVector(-4.0, 2.0, 0.0, 3);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldVector3D.distance1(this.createVector(-1.0, 0.0, 0.0, 3), this.createVector(-1.0, 0.0, 0.0, 3))).getReal(), (double)0.0);
        DerivativeStructure distance = (DerivativeStructure)FieldVector3D.distance1(v1, v2);
        Assert.assertEquals((double)12.0, (double)distance.getReal(), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
        distance = (DerivativeStructure)FieldVector3D.distance1(v1, (Vector3D)new Vector3D(-4.0, 2.0, 0.0));
        Assert.assertEquals((double)12.0, (double)distance.getReal(), (double)1.0E-12);
        Assert.assertEquals((double)1.0, (double)distance.getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)-1.0, (double)distance.getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)1.0, (double)distance.getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
        distance = (DerivativeStructure)FieldVector3D.distance1((Vector3D)new Vector3D(-4.0, 2.0, 0.0), v1);
        Assert.assertEquals((double)12.0, (double)distance.getReal(), (double)1.0E-12);
        Assert.assertEquals((double)1.0, (double)distance.getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)-1.0, (double)distance.getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)1.0, (double)distance.getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
    }

    @Test
    public void testDistance() {
        FieldVector3D<DerivativeStructure> v1 = this.createVector(1.0, -2.0, 3.0, 3);
        FieldVector3D<DerivativeStructure> v2 = this.createVector(-4.0, 2.0, 0.0, 3);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldVector3D.distance(this.createVector(-1.0, 0.0, 0.0, 3), this.createVector(-1.0, 0.0, 0.0, 3))).getReal(), (double)0.0);
        DerivativeStructure distance = (DerivativeStructure)FieldVector3D.distance(v1, v2);
        Assert.assertEquals((double)FastMath.sqrt((double)50.0), (double)distance.getReal(), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
        distance = (DerivativeStructure)FieldVector3D.distance(v1, (Vector3D)new Vector3D(-4.0, 2.0, 0.0));
        Assert.assertEquals((double)FastMath.sqrt((double)50.0), (double)distance.getReal(), (double)1.0E-12);
        Assert.assertEquals((double)(5.0 / FastMath.sqrt((double)50.0)), (double)distance.getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)(-4.0 / FastMath.sqrt((double)50.0)), (double)distance.getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)(3.0 / FastMath.sqrt((double)50.0)), (double)distance.getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
        distance = (DerivativeStructure)FieldVector3D.distance((Vector3D)new Vector3D(-4.0, 2.0, 0.0), v1);
        Assert.assertEquals((double)FastMath.sqrt((double)50.0), (double)distance.getReal(), (double)1.0E-12);
        Assert.assertEquals((double)(5.0 / FastMath.sqrt((double)50.0)), (double)distance.getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)(-4.0 / FastMath.sqrt((double)50.0)), (double)distance.getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)(3.0 / FastMath.sqrt((double)50.0)), (double)distance.getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
    }

    @Test
    public void testDistanceSq() {
        FieldVector3D<DerivativeStructure> v1 = this.createVector(1.0, -2.0, 3.0, 3);
        FieldVector3D<DerivativeStructure> v2 = this.createVector(-4.0, 2.0, 0.0, 3);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldVector3D.distanceSq(this.createVector(-1.0, 0.0, 0.0, 3), this.createVector(-1.0, 0.0, 0.0, 3))).getReal(), (double)0.0);
        DerivativeStructure distanceSq = (DerivativeStructure)FieldVector3D.distanceSq(v1, v2);
        Assert.assertEquals((double)50.0, (double)distanceSq.getReal(), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distanceSq.getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distanceSq.getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distanceSq.getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
        distanceSq = (DerivativeStructure)FieldVector3D.distanceSq(v1, (Vector3D)new Vector3D(-4.0, 2.0, 0.0));
        Assert.assertEquals((double)50.0, (double)distanceSq.getReal(), (double)1.0E-12);
        Assert.assertEquals((double)10.0, (double)distanceSq.getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)-8.0, (double)distanceSq.getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)6.0, (double)distanceSq.getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
        distanceSq = (DerivativeStructure)FieldVector3D.distanceSq((Vector3D)new Vector3D(-4.0, 2.0, 0.0), v1);
        Assert.assertEquals((double)50.0, (double)distanceSq.getReal(), (double)1.0E-12);
        Assert.assertEquals((double)10.0, (double)distanceSq.getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)-8.0, (double)distanceSq.getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)6.0, (double)distanceSq.getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
    }

    @Test
    public void testDistanceInf() {
        FieldVector3D<DerivativeStructure> v1 = this.createVector(1.0, -2.0, 3.0, 3);
        FieldVector3D<DerivativeStructure> v2 = this.createVector(-4.0, 2.0, 0.0, 3);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(-1.0, 0.0, 0.0, 3), this.createVector(-1.0, 0.0, 0.0, 3))).getReal(), (double)0.0);
        DerivativeStructure distance = (DerivativeStructure)FieldVector3D.distanceInf(v1, v2);
        Assert.assertEquals((double)5.0, (double)distance.getReal(), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
        distance = (DerivativeStructure)FieldVector3D.distanceInf(v1, (Vector3D)new Vector3D(-4.0, 2.0, 0.0));
        Assert.assertEquals((double)5.0, (double)distance.getReal(), (double)1.0E-12);
        Assert.assertEquals((double)1.0, (double)distance.getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
        distance = (DerivativeStructure)FieldVector3D.distanceInf((Vector3D)new Vector3D(-4.0, 2.0, 0.0), v1);
        Assert.assertEquals((double)5.0, (double)distance.getReal(), (double)1.0E-12);
        Assert.assertEquals((double)1.0, (double)distance.getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)distance.getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
        Assert.assertEquals((double)((DerivativeStructure)v1.subtract(v2).getNormInf()).getReal(), (double)((DerivativeStructure)FieldVector3D.distanceInf(v1, v2)).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)5.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(1.0, -2.0, 3.0, 3), this.createVector(-4.0, 2.0, 0.0, 3))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)5.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(1.0, 3.0, -2.0, 3), this.createVector(-4.0, 0.0, 2.0, 3))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)5.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(-2.0, 1.0, 3.0, 3), this.createVector(2.0, -4.0, 0.0, 3))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)5.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(-2.0, 3.0, 1.0, 3), this.createVector(2.0, 0.0, -4.0, 3))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)5.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(3.0, -2.0, 1.0, 3), this.createVector(0.0, 2.0, -4.0, 3))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)5.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(3.0, 1.0, -2.0, 3), this.createVector(0.0, -4.0, 2.0, 3))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)5.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(1.0, -2.0, 3.0, 3), (Vector3D)new Vector3D(-4.0, 2.0, 0.0))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)5.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(1.0, 3.0, -2.0, 3), (Vector3D)new Vector3D(-4.0, 0.0, 2.0))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)5.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(-2.0, 1.0, 3.0, 3), (Vector3D)new Vector3D(2.0, -4.0, 0.0))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)5.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(-2.0, 3.0, 1.0, 3), (Vector3D)new Vector3D(2.0, 0.0, -4.0))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)5.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(3.0, -2.0, 1.0, 3), (Vector3D)new Vector3D(0.0, 2.0, -4.0))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)5.0, (double)((DerivativeStructure)FieldVector3D.distanceInf(this.createVector(3.0, 1.0, -2.0, 3), (Vector3D)new Vector3D(0.0, -4.0, 2.0))).getReal(), (double)1.0E-12);
    }

    @Test
    public void testSubtract() {
        FieldVector3D v1 = this.createVector(1.0, 2.0, 3.0, 3);
        FieldVector3D<DerivativeStructure> v2 = this.createVector(-3.0, -2.0, -1.0, 3);
        v1 = v1.subtract(v2);
        this.checkVector((FieldVector3D<DerivativeStructure>)v1, 4.0, 4.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)v2.subtract(v1), -7.0, -6.0, -5.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)v2.subtract(new Vector3D(4.0, 4.0, 4.0)), -7.0, -6.0, -5.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)v2.subtract(3.0, v1), -15.0, -14.0, -13.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)v2.subtract(3.0, new Vector3D(4.0, 4.0, 4.0)), -15.0, -14.0, -13.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)v2.subtract((RealFieldElement)new DerivativeStructure(3, 1, 2, 3.0), new Vector3D(4.0, 4.0, 4.0)), -15.0, -14.0, -13.0, 1.0, 0.0, -4.0, 0.0, 1.0, -4.0, 0.0, 0.0, -3.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)this.createVector(1.0, 2.0, 3.0, 4).subtract((RealFieldElement)new DerivativeStructure(4, 1, 3, 5.0), this.createVector(3.0, -2.0, 1.0, 4)), -14.0, 12.0, -2.0, -4.0, 0.0, 0.0, -3.0, 0.0, -4.0, 0.0, 2.0, 0.0, 0.0, -4.0, -1.0);
    }

    @Test
    public void testAdd() {
        FieldVector3D v1 = this.createVector(1.0, 2.0, 3.0, 3);
        FieldVector3D<DerivativeStructure> v2 = this.createVector(-3.0, -2.0, -1.0, 3);
        v1 = v1.add(v2);
        this.checkVector((FieldVector3D<DerivativeStructure>)v1, -2.0, 0.0, 2.0, 2.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 2.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)v2.add(v1), -5.0, -2.0, 1.0, 3.0, 0.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 3.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)v2.add(new Vector3D(-2.0, 0.0, 2.0)), -5.0, -2.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)v2.add(3.0, v1), -9.0, -2.0, 5.0, 7.0, 0.0, 0.0, 0.0, 7.0, 0.0, 0.0, 0.0, 7.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)v2.add(3.0, new Vector3D(-2.0, 0.0, 2.0)), -9.0, -2.0, 5.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)v2.add((RealFieldElement)new DerivativeStructure(3, 1, 2, 3.0), new Vector3D(-2.0, 0.0, 2.0)), -9.0, -2.0, 5.0, 1.0, 0.0, -2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 3.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)this.createVector(1.0, 2.0, 3.0, 4).add((RealFieldElement)new DerivativeStructure(4, 1, 3, 5.0), this.createVector(3.0, -2.0, 1.0, 4)), 16.0, -8.0, 8.0, 6.0, 0.0, 0.0, 3.0, 0.0, 6.0, 0.0, -2.0, 0.0, 0.0, 6.0, 1.0);
    }

    @Test
    public void testScalarProduct() {
        FieldVector3D v = this.createVector(1.0, 2.0, 3.0, 3);
        v = v.scalarMultiply(3.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)v, 3.0, 6.0, 9.0);
        this.checkVector((FieldVector3D<DerivativeStructure>)v.scalarMultiply(0.5), 1.5, 3.0, 4.5);
    }

    @Test
    public void testVectorialProducts() {
        FieldVector3D<DerivativeStructure> v2;
        FieldVector3D<DerivativeStructure> v1 = this.createVector(2.0, 1.0, -4.0, 3);
        Assert.assertTrue((FastMath.abs((double)(((DerivativeStructure)FieldVector3D.dotProduct(v1, v2 = this.createVector(3.0, 1.0, -1.0, 3))).getReal() - 11.0)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(((DerivativeStructure)FieldVector3D.dotProduct(v1, (Vector3D)v2.toVector3D())).getReal() - 11.0)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(((DerivativeStructure)FieldVector3D.dotProduct((Vector3D)v1.toVector3D(), v2)).getReal() - 11.0)) < 1.0E-12 ? 1 : 0) != 0);
        FieldVector3D v3 = FieldVector3D.crossProduct(v1, v2);
        this.checkVector((FieldVector3D<DerivativeStructure>)v3, 3.0, -10.0, -1.0);
        Assert.assertTrue((FastMath.abs((double)((DerivativeStructure)FieldVector3D.dotProduct(v1, (FieldVector3D)v3)).getReal()) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)((DerivativeStructure)FieldVector3D.dotProduct(v2, (FieldVector3D)v3)).getReal()) < 1.0E-12 ? 1 : 0) != 0);
        v3 = FieldVector3D.crossProduct(v1, (Vector3D)v2.toVector3D());
        this.checkVector((FieldVector3D<DerivativeStructure>)v3, 3.0, -10.0, -1.0);
        Assert.assertTrue((FastMath.abs((double)((DerivativeStructure)FieldVector3D.dotProduct(v1, (FieldVector3D)v3)).getReal()) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)((DerivativeStructure)FieldVector3D.dotProduct(v2, (FieldVector3D)v3)).getReal()) < 1.0E-12 ? 1 : 0) != 0);
        v3 = FieldVector3D.crossProduct((Vector3D)v1.toVector3D(), v2);
        this.checkVector((FieldVector3D<DerivativeStructure>)v3, 3.0, -10.0, -1.0);
        Assert.assertTrue((FastMath.abs((double)((DerivativeStructure)FieldVector3D.dotProduct(v1, (FieldVector3D)v3)).getReal()) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)((DerivativeStructure)FieldVector3D.dotProduct(v2, (FieldVector3D)v3)).getReal()) < 1.0E-12 ? 1 : 0) != 0);
    }

    @Test
    public void testCrossProductCancellation() {
        FieldVector3D<DerivativeStructure> v1 = this.createVector(9.070467121E9, 4.53523356E9, 1.0, 3);
        FieldVector3D<DerivativeStructure> v2 = this.createVector(9.070467123E9, 4.535233561E9, 1.0, 3);
        this.checkVector((FieldVector3D<DerivativeStructure>)FieldVector3D.crossProduct(v1, v2), -1.0, 2.0, 1.0);
        double scale = FastMath.scalb((double)1.0, (int)100);
        FieldVector3D big1 = new FieldVector3D(scale, v1);
        FieldVector3D small2 = new FieldVector3D(1.0 / scale, v2);
        this.checkVector((FieldVector3D<DerivativeStructure>)FieldVector3D.crossProduct((FieldVector3D)big1, (FieldVector3D)small2), -1.0, 2.0, 1.0);
    }

    @Test
    public void testAngular() {
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(1.0, 0.0, 0.0, 3).getAlpha()).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(1.0, 0.0, 0.0, 3).getDelta()).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)((DerivativeStructure)this.createVector(0.0, 1.0, 0.0, 3).getAlpha()).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)this.createVector(0.0, 1.0, 0.0, 3).getDelta()).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)((DerivativeStructure)this.createVector(0.0, 0.0, 1.0, 3).getDelta()).getReal(), (double)1.0E-10);
        FieldVector3D<DerivativeStructure> u = this.createVector(-1.0, 1.0, -1.0, 3);
        Assert.assertEquals((double)2.356194490192345, (double)((DerivativeStructure)u.getAlpha()).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)(-1.0 / FastMath.sqrt((double)3.0)), (double)((DerivativeStructure)u.getDelta()).sin().getReal(), (double)1.0E-10);
    }

    @Test
    public void testAngularSeparation() throws MathArithmeticException {
        FieldVector3D<DerivativeStructure> v1 = this.createVector(2.0, -1.0, 4.0, 3);
        FieldVector3D k = v1.normalize();
        FieldVector3D i = k.orthogonal();
        FieldVector3D v2 = k.scalarMultiply(FastMath.cos((double)1.2)).add(i.scalarMultiply(FastMath.sin((double)1.2)));
        Assert.assertTrue((FastMath.abs((double)(((DerivativeStructure)FieldVector3D.angle(v1, (FieldVector3D)v2)).getReal() - 1.2)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(((DerivativeStructure)FieldVector3D.angle(v1, (Vector3D)v2.toVector3D())).getReal() - 1.2)) < 1.0E-12 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(((DerivativeStructure)FieldVector3D.angle((Vector3D)v1.toVector3D(), (FieldVector3D)v2)).getReal() - 1.2)) < 1.0E-12 ? 1 : 0) != 0);
        try {
            FieldVector3D.angle(v1, (Vector3D)Vector3D.ZERO);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldVector3D.angle(v1, (Vector3D)v1.toVector3D())).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)Math.PI, (double)((DerivativeStructure)FieldVector3D.angle(v1, (Vector3D)v1.negate().toVector3D())).getReal(), (double)1.0E-15);
    }

    @Test
    public void testNormalize() throws MathArithmeticException {
        Assert.assertEquals((double)1.0, (double)((DerivativeStructure)this.createVector(5.0, -4.0, 2.0, 3).normalize().getNorm()).getReal(), (double)1.0E-12);
        try {
            this.createVector(0.0, 0.0, 0.0, 3).normalize();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testNegate() {
        this.checkVector((FieldVector3D<DerivativeStructure>)this.createVector(0.1, 2.5, 1.3, 3).negate(), -0.1, -2.5, -1.3, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0);
    }

    @Test
    public void testOrthogonal() throws MathArithmeticException {
        FieldVector3D<DerivativeStructure> v1 = this.createVector(0.1, 2.5, 1.3, 3);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldVector3D.dotProduct(v1, (FieldVector3D)v1.orthogonal())).getReal(), (double)1.0E-12);
        FieldVector3D<DerivativeStructure> v2 = this.createVector(2.3, -0.003, 7.6, 3);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldVector3D.dotProduct(v2, (FieldVector3D)v2.orthogonal())).getReal(), (double)1.0E-12);
        FieldVector3D<DerivativeStructure> v3 = this.createVector(-1.7, 1.4, 0.2, 3);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldVector3D.dotProduct(v3, (FieldVector3D)v3.orthogonal())).getReal(), (double)1.0E-12);
        FieldVector3D<DerivativeStructure> v4 = this.createVector(4.2, 0.1, -1.8, 3);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldVector3D.dotProduct(v4, (FieldVector3D)v4.orthogonal())).getReal(), (double)1.0E-12);
        try {
            this.createVector(0.0, 0.0, 0.0, 3).orthogonal();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testAngle() throws MathArithmeticException {
        Assert.assertEquals((double)0.22572612855273394, (double)((DerivativeStructure)FieldVector3D.angle(this.createVector(1.0, 2.0, 3.0, 3), this.createVector(4.0, 5.0, 6.0, 3))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)7.985956206861066E-8, (double)((DerivativeStructure)FieldVector3D.angle(this.createVector(1.0, 2.0, 3.0, 3), this.createVector(2.0, 4.0, 6.000001, 3))).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)3.141592573730231, (double)((DerivativeStructure)FieldVector3D.angle(this.createVector(1.0, 2.0, 3.0, 3), this.createVector(-2.0, -4.0, -6.000001, 3))).getReal(), (double)1.0E-12);
        try {
            FieldVector3D.angle(this.createVector(0.0, 0.0, 0.0, 3), this.createVector(1.0, 0.0, 0.0, 3));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testAccurateDotProduct() {
        FieldVector3D<DerivativeStructure> u1 = this.createVector(-4921140.837095533, -2.1512094250440013E7, -890093.2794263769, 3);
        FieldVector3D<DerivativeStructure> u2 = this.createVector(-2.7238580938724895E9, -2.1696649213418756E9, 6.7496887088853004E10, 3);
        DerivativeStructure sNaive = ((DerivativeStructure)u1.getX()).multiply((DerivativeStructure)u2.getX()).add(((DerivativeStructure)u1.getY()).multiply((DerivativeStructure)u2.getY())).add(((DerivativeStructure)u1.getZ()).multiply((DerivativeStructure)u2.getZ()));
        DerivativeStructure sAccurate = (DerivativeStructure)FieldVector3D.dotProduct(u1, u2);
        Assert.assertEquals((double)0.0, (double)sNaive.getReal(), (double)1.0E-30);
        Assert.assertEquals((double)-1.8551294182586249, (double)sAccurate.getReal(), (double)1.0E-15);
    }

    @Test
    public void testDotProduct() {
        Well1024a random = new Well1024a(553267312521321234L);
        for (int i = 0; i < 10000; ++i) {
            double ux = 10000.0 * random.nextDouble();
            double uy = 10000.0 * random.nextDouble();
            double uz = 10000.0 * random.nextDouble();
            double vx = 10000.0 * random.nextDouble();
            double vy = 10000.0 * random.nextDouble();
            double vz = 10000.0 * random.nextDouble();
            double sNaive = ux * vx + uy * vy + uz * vz;
            FieldVector3D<DerivativeStructure> uds = this.createVector(ux, uy, uz, 3);
            FieldVector3D<DerivativeStructure> vds = this.createVector(vx, vy, vz, 3);
            Vector3D v = new Vector3D(vx, vy, vz);
            DerivativeStructure sAccurate = (DerivativeStructure)FieldVector3D.dotProduct(uds, vds);
            Assert.assertEquals((double)sNaive, (double)sAccurate.getReal(), (double)(2.5E-16 * sNaive));
            Assert.assertEquals((double)(ux + vx), (double)sAccurate.getPartialDerivative(new int[]{1, 0, 0}), (double)(2.5E-16 * sNaive));
            Assert.assertEquals((double)(uy + vy), (double)sAccurate.getPartialDerivative(new int[]{0, 1, 0}), (double)(2.5E-16 * sNaive));
            Assert.assertEquals((double)(uz + vz), (double)sAccurate.getPartialDerivative(new int[]{0, 0, 1}), (double)(2.5E-16 * sNaive));
            sAccurate = (DerivativeStructure)FieldVector3D.dotProduct(uds, (Vector3D)v);
            Assert.assertEquals((double)sNaive, (double)sAccurate.getReal(), (double)(2.5E-16 * sNaive));
            Assert.assertEquals((double)vx, (double)sAccurate.getPartialDerivative(new int[]{1, 0, 0}), (double)(2.5E-16 * sNaive));
            Assert.assertEquals((double)vy, (double)sAccurate.getPartialDerivative(new int[]{0, 1, 0}), (double)(2.5E-16 * sNaive));
            Assert.assertEquals((double)vz, (double)sAccurate.getPartialDerivative(new int[]{0, 0, 1}), (double)(2.5E-16 * sNaive));
        }
    }

    @Test
    public void testAccurateCrossProduct() {
        FieldVector3D<DerivativeStructure> u1 = this.createVector(-4921140.837095533, -2.1512094250440013E7, -890093.2794263769, 3);
        FieldVector3D<DerivativeStructure> u2 = this.createVector(836593.9423062406, 3657056.0225748024, 151315.85750248405, 3);
        FieldVector3D<DerivativeStructure> u3 = this.createVector(6.913547321211624E-4, -1.2542955621103424E-4, -7.90930104102975E-4, 3);
        FieldVector3D cNaive = new FieldVector3D((RealFieldElement)((DerivativeStructure)u1.getY()).multiply((DerivativeStructure)u2.getZ()).subtract(((DerivativeStructure)u1.getZ()).multiply((DerivativeStructure)u2.getY())), (RealFieldElement)((DerivativeStructure)u1.getZ()).multiply((DerivativeStructure)u2.getX()).subtract(((DerivativeStructure)u1.getX()).multiply((DerivativeStructure)u2.getZ())), (RealFieldElement)((DerivativeStructure)u1.getX()).multiply((DerivativeStructure)u2.getY()).subtract(((DerivativeStructure)u1.getY()).multiply((DerivativeStructure)u2.getX())));
        FieldVector3D cAccurate = FieldVector3D.crossProduct(u1, u2);
        Assert.assertTrue((((DerivativeStructure)FieldVector3D.distance(u3, (FieldVector3D)cNaive)).getReal() > 2.9 * ((DerivativeStructure)u3.getNorm()).getReal() ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)((DerivativeStructure)FieldVector3D.distance(u3, (FieldVector3D)cAccurate)).getReal(), (double)(1.0E-30 * ((DerivativeStructure)cAccurate.getNorm()).getReal()));
    }

    @Test
    public void testCrossProduct() {
        Well1024a random = new Well1024a(885362227452043214L);
        for (int i = 0; i < 10000; ++i) {
            double ux = random.nextDouble();
            double uy = random.nextDouble();
            double uz = random.nextDouble();
            double vx = random.nextDouble();
            double vy = random.nextDouble();
            double vz = random.nextDouble();
            Vector3D cNaive = new Vector3D(uy * vz - uz * vy, uz * vx - ux * vz, ux * vy - uy * vx);
            FieldVector3D<DerivativeStructure> uds = this.createVector(ux, uy, uz, 3);
            FieldVector3D<DerivativeStructure> vds = this.createVector(vx, vy, vz, 3);
            Vector3D v = new Vector3D(vx, vy, vz);
            this.checkVector((FieldVector3D<DerivativeStructure>)FieldVector3D.crossProduct(uds, vds), cNaive.getX(), cNaive.getY(), cNaive.getZ(), 0.0, vz - uz, uy - vy, uz - vz, 0.0, vx - ux, vy - uy, ux - vx, 0.0);
            this.checkVector((FieldVector3D<DerivativeStructure>)FieldVector3D.crossProduct(uds, (Vector3D)v), cNaive.getX(), cNaive.getY(), cNaive.getZ(), 0.0, vz, -vy, -vz, 0.0, vx, vy, -vx, 0.0);
        }
    }

    private FieldVector3D<DerivativeStructure> createVector(double x, double y, double z, int params) {
        return new FieldVector3D((RealFieldElement)new DerivativeStructure(params, 1, 0, x), (RealFieldElement)new DerivativeStructure(params, 1, 1, y), (RealFieldElement)new DerivativeStructure(params, 1, 2, z));
    }

    private void checkVector(FieldVector3D<DerivativeStructure> v, double x, double y, double z) {
        Assert.assertEquals((double)x, (double)((DerivativeStructure)v.getX()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)y, (double)((DerivativeStructure)v.getY()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)z, (double)((DerivativeStructure)v.getZ()).getReal(), (double)1.0E-12);
    }

    private void checkVector(FieldVector3D<DerivativeStructure> v, double x, double y, double z, double dxdx, double dxdy, double dxdz, double dydx, double dydy, double dydz, double dzdx, double dzdy, double dzdz) {
        Assert.assertEquals((double)x, (double)((DerivativeStructure)v.getX()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)y, (double)((DerivativeStructure)v.getY()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)z, (double)((DerivativeStructure)v.getZ()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)dxdx, (double)((DerivativeStructure)v.getX()).getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dxdy, (double)((DerivativeStructure)v.getX()).getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dxdz, (double)((DerivativeStructure)v.getX()).getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
        Assert.assertEquals((double)dydx, (double)((DerivativeStructure)v.getY()).getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dydy, (double)((DerivativeStructure)v.getY()).getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dydz, (double)((DerivativeStructure)v.getY()).getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
        Assert.assertEquals((double)dzdx, (double)((DerivativeStructure)v.getZ()).getPartialDerivative(new int[]{1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dzdy, (double)((DerivativeStructure)v.getZ()).getPartialDerivative(new int[]{0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dzdz, (double)((DerivativeStructure)v.getZ()).getPartialDerivative(new int[]{0, 0, 1}), (double)1.0E-12);
    }

    private void checkVector(FieldVector3D<DerivativeStructure> v, double x, double y, double z, double dxdx, double dxdy, double dxdz, double dxdt, double dydx, double dydy, double dydz, double dydt, double dzdx, double dzdy, double dzdz, double dzdt) {
        Assert.assertEquals((double)x, (double)((DerivativeStructure)v.getX()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)y, (double)((DerivativeStructure)v.getY()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)z, (double)((DerivativeStructure)v.getZ()).getReal(), (double)1.0E-12);
        Assert.assertEquals((double)dxdx, (double)((DerivativeStructure)v.getX()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dxdy, (double)((DerivativeStructure)v.getX()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dxdz, (double)((DerivativeStructure)v.getX()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dxdt, (double)((DerivativeStructure)v.getX()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-12);
        Assert.assertEquals((double)dydx, (double)((DerivativeStructure)v.getY()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dydy, (double)((DerivativeStructure)v.getY()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dydz, (double)((DerivativeStructure)v.getY()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dydt, (double)((DerivativeStructure)v.getY()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-12);
        Assert.assertEquals((double)dzdx, (double)((DerivativeStructure)v.getZ()).getPartialDerivative(new int[]{1, 0, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dzdy, (double)((DerivativeStructure)v.getZ()).getPartialDerivative(new int[]{0, 1, 0, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dzdz, (double)((DerivativeStructure)v.getZ()).getPartialDerivative(new int[]{0, 0, 1, 0}), (double)1.0E-12);
        Assert.assertEquals((double)dzdt, (double)((DerivativeStructure)v.getZ()).getPartialDerivative(new int[]{0, 0, 0, 1}), (double)1.0E-12);
    }
}

