/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLYParser {
    private Vector3D[] vertices;
    private int[][] faces;
    private BufferedReader br;
    private String line;

    public PLYParser(InputStream stream) throws IOException, ParseException {
        try {
            int i;
            this.br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            List<Field> fields = this.parseNextLine();
            if (fields.size() != 1 || fields.get(0).getToken() != Token.PLY) {
                this.complain();
            }
            boolean parsing = true;
            int nbVertices = -1;
            int nbFaces = -1;
            int xIndex = -1;
            int yIndex = -1;
            int zIndex = -1;
            int vPropertiesNumber = -1;
            boolean inVertexElt = false;
            boolean inFaceElt = false;
            block9: while (parsing) {
                fields = this.parseNextLine();
                if (fields.size() < 1) {
                    this.complain();
                }
                switch (fields.get(0).getToken()) {
                    case FORMAT: {
                        if (fields.size() != 3 || fields.get(1).getToken() != Token.ASCII || fields.get(2).getToken() != Token.UNKNOWN || !Precision.equals((double)Double.parseDouble(fields.get(2).getValue()), (double)1.0, (double)0.001)) {
                            this.complain();
                        }
                        inVertexElt = false;
                        inFaceElt = false;
                        continue block9;
                    }
                    case COMMENT: {
                        continue block9;
                    }
                    case ELEMENT: {
                        if (fields.size() != 3 || fields.get(1).getToken() != Token.VERTEX && fields.get(1).getToken() != Token.FACE || fields.get(2).getToken() != Token.UNKNOWN) {
                            this.complain();
                        }
                        if (fields.get(1).getToken() == Token.VERTEX) {
                            nbVertices = Integer.parseInt(fields.get(2).getValue());
                            inVertexElt = true;
                            inFaceElt = false;
                            continue block9;
                        }
                        nbFaces = Integer.parseInt(fields.get(2).getValue());
                        inVertexElt = false;
                        inFaceElt = true;
                        continue block9;
                    }
                    case PROPERTY: {
                        if (inVertexElt) {
                            ++vPropertiesNumber;
                            if (fields.size() != 3 || fields.get(1).getToken() != Token.CHAR && fields.get(1).getToken() != Token.UCHAR && fields.get(1).getToken() != Token.SHORT && fields.get(1).getToken() != Token.USHORT && fields.get(1).getToken() != Token.INT && fields.get(1).getToken() != Token.UINT && fields.get(1).getToken() != Token.FLOAT && fields.get(1).getToken() != Token.DOUBLE) {
                                this.complain();
                            }
                            if (fields.get(2).getToken() == Token.X) {
                                xIndex = vPropertiesNumber;
                                continue block9;
                            }
                            if (fields.get(2).getToken() == Token.Y) {
                                yIndex = vPropertiesNumber;
                                continue block9;
                            }
                            if (fields.get(2).getToken() != Token.Z) continue block9;
                            zIndex = vPropertiesNumber;
                            continue block9;
                        }
                        if (inFaceElt) {
                            if (!(fields.size() != 5 || fields.get(1).getToken() != Token.LIST && fields.get(2).getToken() != Token.CHAR && fields.get(2).getToken() != Token.UCHAR && fields.get(2).getToken() != Token.SHORT && fields.get(2).getToken() != Token.USHORT && fields.get(2).getToken() != Token.INT && fields.get(2).getToken() != Token.UINT || fields.get(3).getToken() != Token.CHAR && fields.get(3).getToken() != Token.UCHAR && fields.get(3).getToken() != Token.SHORT && fields.get(3).getToken() != Token.USHORT && fields.get(3).getToken() != Token.INT && fields.get(3).getToken() != Token.UINT) && fields.get(4).getToken() == Token.VERTEX_INDICES) continue block9;
                            this.complain();
                            continue block9;
                        }
                        this.complain();
                        continue block9;
                    }
                    case END_HEADER: {
                        inVertexElt = false;
                        inFaceElt = false;
                        parsing = false;
                        continue block9;
                    }
                }
                throw new ParseException("unable to parse line: " + this.line, 0);
            }
            ++vPropertiesNumber;
            this.vertices = new Vector3D[nbVertices];
            for (i = 0; i < nbVertices; ++i) {
                fields = this.parseNextLine();
                if (fields.size() != vPropertiesNumber || fields.get(xIndex).getToken() != Token.UNKNOWN || fields.get(yIndex).getToken() != Token.UNKNOWN || fields.get(zIndex).getToken() != Token.UNKNOWN) {
                    this.complain();
                }
                this.vertices[i] = new Vector3D(Double.parseDouble(fields.get(xIndex).getValue()), Double.parseDouble(fields.get(yIndex).getValue()), Double.parseDouble(fields.get(zIndex).getValue()));
            }
            this.faces = new int[nbFaces][];
            for (i = 0; i < nbFaces; ++i) {
                fields = this.parseNextLine();
                if (fields.isEmpty() || fields.size() != Integer.parseInt(fields.get(0).getValue()) + 1) {
                    this.complain();
                }
                this.faces[i] = new int[fields.size() - 1];
                for (int j = 0; j < this.faces[i].length; ++j) {
                    this.faces[i][j] = Integer.parseInt(fields.get(j + 1).getValue());
                }
            }
        }
        catch (NumberFormatException nfe) {
            this.complain();
        }
    }

    private void complain() throws ParseException {
        throw new ParseException("unable to parse line: " + this.line, 0);
    }

    private List<Field> parseNextLine() throws IOException, ParseException {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.line = this.br.readLine();
        if (this.line == null) {
            throw new EOFException();
        }
        StringTokenizer tokenizer = new StringTokenizer(this.line);
        while (tokenizer.hasMoreTokens()) {
            fields.add(new Field(tokenizer.nextToken()));
        }
        return fields;
    }

    public List<Vector3D> getVertices() {
        return Arrays.asList(this.vertices);
    }

    public List<int[]> getFaces() {
        return Arrays.asList(this.faces);
    }

    private static class Field {
        private final Token token;
        private final String value;

        public Field(String value) {
            Token parsedToken = null;
            try {
                parsedToken = Token.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                parsedToken = Token.UNKNOWN;
            }
            this.token = parsedToken;
            this.value = value;
        }

        public Token getToken() {
            return this.token;
        }

        public String getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Token {
        PLY,
        FORMAT,
        ASCII,
        BINARY_BIG_ENDIAN,
        BINARY_LITTLE_ENDIAN,
        COMMENT,
        ELEMENT,
        VERTEX,
        FACE,
        PROPERTY,
        LIST,
        OBJ_INFO,
        CHAR,
        UCHAR,
        SHORT,
        USHORT,
        INT,
        UINT,
        FLOAT,
        DOUBLE,
        X,
        Y,
        Z,
        VERTEX_INDICES,
        END_HEADER,
        UNKNOWN;

    }
}

