/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.math3.exception.MathParseException;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2DFormat;
import org.junit.Assert;
import org.junit.Test;

public abstract class Vector2DFormatAbstractTest {
    Vector2DFormat vector2DFormat = Vector2DFormat.getInstance((Locale)this.getLocale());
    Vector2DFormat vector2DFormatSquare = null;

    protected abstract Locale getLocale();

    protected abstract char getDecimalCharacter();

    protected Vector2DFormatAbstractTest() {
        NumberFormat nf = NumberFormat.getInstance(this.getLocale());
        nf.setMaximumFractionDigits(2);
        this.vector2DFormatSquare = new Vector2DFormat("[", "]", " : ", nf);
    }

    @Test
    public void testSimpleNoDecimals() {
        Vector2D c = new Vector2D(1.0, 1.0);
        String expected = "{1; 1}";
        String actual = this.vector2DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleWithDecimals() {
        Vector2D c = new Vector2D(1.23, 1.43);
        String expected = "{1" + this.getDecimalCharacter() + "23; 1" + this.getDecimalCharacter() + "43}";
        String actual = this.vector2DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleWithDecimalsTrunc() {
        Vector2D c = new Vector2D(1.232323232323, 1.434343434343);
        String expected = "{1" + this.getDecimalCharacter() + "2323232323; 1" + this.getDecimalCharacter() + "4343434343}";
        String actual = this.vector2DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeX() {
        Vector2D c = new Vector2D(-1.232323232323, 1.43);
        String expected = "{-1" + this.getDecimalCharacter() + "2323232323; 1" + this.getDecimalCharacter() + "43}";
        String actual = this.vector2DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeY() {
        Vector2D c = new Vector2D(1.23, -1.434343434343);
        String expected = "{1" + this.getDecimalCharacter() + "23; -1" + this.getDecimalCharacter() + "4343434343}";
        String actual = this.vector2DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegativeZ() {
        Vector2D c = new Vector2D(1.23, 1.43);
        String expected = "{1" + this.getDecimalCharacter() + "23; 1" + this.getDecimalCharacter() + "43}";
        String actual = this.vector2DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNonDefaultSetting() {
        Vector2D c = new Vector2D(1.0, 1.0);
        String expected = "[1 : 1]";
        String actual = this.vector2DFormatSquare.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDefaultFormatVector2D() {
        Locale defaultLocal = Locale.getDefault();
        Locale.setDefault(this.getLocale());
        Vector2D c = new Vector2D(232.22222222222, -342.3333333333);
        String expected = "{232" + this.getDecimalCharacter() + "2222222222; -342" + this.getDecimalCharacter() + "3333333333}";
        String actual = new Vector2DFormat().format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        Locale.setDefault(defaultLocal);
    }

    @Test
    public void testNan() {
        Vector2D c = Vector2D.NaN;
        String expected = "{(NaN); (NaN)}";
        String actual = this.vector2DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testPositiveInfinity() {
        Vector2D c = Vector2D.POSITIVE_INFINITY;
        String expected = "{(Infinity); (Infinity)}";
        String actual = this.vector2DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void tesNegativeInfinity() {
        Vector2D c = Vector2D.NEGATIVE_INFINITY;
        String expected = "{(-Infinity); (-Infinity)}";
        String actual = this.vector2DFormat.format((Vector)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleNoDecimals() throws MathParseException {
        String source = "{1; 1}";
        Vector2D expected = new Vector2D(1.0, 1.0);
        Vector2D actual = this.vector2DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseIgnoredWhitespace() {
        Vector2D expected = new Vector2D(1.0, 1.0);
        ParsePosition pos1 = new ParsePosition(0);
        String source1 = "{1;1}";
        Assert.assertEquals((Object)expected, (Object)this.vector2DFormat.parse(source1, pos1));
        Assert.assertEquals((long)source1.length(), (long)pos1.getIndex());
        ParsePosition pos2 = new ParsePosition(0);
        String source2 = " { 1 ; 1 } ";
        Assert.assertEquals((Object)expected, (Object)this.vector2DFormat.parse(source2, pos2));
        Assert.assertEquals((long)(source2.length() - 1), (long)pos2.getIndex());
    }

    @Test
    public void testParseSimpleWithDecimals() throws MathParseException {
        String source = "{1" + this.getDecimalCharacter() + "23; 1" + this.getDecimalCharacter() + "43}";
        Vector2D expected = new Vector2D(1.23, 1.43);
        Vector2D actual = this.vector2DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseSimpleWithDecimalsTrunc() throws MathParseException {
        String source = "{1" + this.getDecimalCharacter() + "2323; 1" + this.getDecimalCharacter() + "4343}";
        Vector2D expected = new Vector2D(1.2323, 1.4343);
        Vector2D actual = this.vector2DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeX() throws MathParseException {
        String source = "{-1" + this.getDecimalCharacter() + "2323; 1" + this.getDecimalCharacter() + "4343}";
        Vector2D expected = new Vector2D(-1.2323, 1.4343);
        Vector2D actual = this.vector2DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeY() throws MathParseException {
        String source = "{1" + this.getDecimalCharacter() + "2323; -1" + this.getDecimalCharacter() + "4343}";
        Vector2D expected = new Vector2D(1.2323, -1.4343);
        Vector2D actual = this.vector2DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeZ() throws MathParseException {
        String source = "{1" + this.getDecimalCharacter() + "2323; 1" + this.getDecimalCharacter() + "4343}";
        Vector2D expected = new Vector2D(1.2323, 1.4343);
        Vector2D actual = this.vector2DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNegativeAll() throws MathParseException {
        String source = "{-1" + this.getDecimalCharacter() + "2323; -1" + this.getDecimalCharacter() + "4343}";
        Vector2D expected = new Vector2D(-1.2323, -1.4343);
        Vector2D actual = this.vector2DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseZeroX() throws MathParseException {
        String source = "{0" + this.getDecimalCharacter() + "0; -1" + this.getDecimalCharacter() + "4343}";
        Vector2D expected = new Vector2D(0.0, -1.4343);
        Vector2D actual = this.vector2DFormat.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNonDefaultSetting() throws MathParseException {
        String source = "[1" + this.getDecimalCharacter() + "2323 : 1" + this.getDecimalCharacter() + "4343]";
        Vector2D expected = new Vector2D(1.2323, 1.4343);
        Vector2D actual = this.vector2DFormatSquare.parse(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseNan() throws MathParseException {
        String source = "{(NaN); (NaN)}";
        Vector2D actual = this.vector2DFormat.parse(source);
        Assert.assertEquals((Object)Vector2D.NaN, (Object)actual);
    }

    @Test
    public void testParsePositiveInfinity() throws MathParseException {
        String source = "{(Infinity); (Infinity)}";
        Vector2D actual = this.vector2DFormat.parse(source);
        Assert.assertEquals((Object)Vector2D.POSITIVE_INFINITY, (Object)actual);
    }

    @Test
    public void testParseNegativeInfinity() throws MathParseException {
        String source = "{(-Infinity); (-Infinity)}";
        Vector2D actual = this.vector2DFormat.parse(source);
        Assert.assertEquals((Object)Vector2D.NEGATIVE_INFINITY, (Object)actual);
    }

    @Test
    public void testConstructorSingleFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        Vector2DFormat cf = new Vector2DFormat(nf);
        Assert.assertNotNull((Object)cf);
        Assert.assertEquals((Object)nf, (Object)cf.getFormat());
    }

    @Test
    public void testForgottenPrefix() {
        ParsePosition pos = new ParsePosition(0);
        Assert.assertNull((Object)new Vector2DFormat().parse("1; 1}", pos));
        Assert.assertEquals((long)0L, (long)pos.getErrorIndex());
    }

    @Test
    public void testForgottenSeparator() {
        ParsePosition pos = new ParsePosition(0);
        Assert.assertNull((Object)new Vector2DFormat().parse("{1 1}", pos));
        Assert.assertEquals((long)3L, (long)pos.getErrorIndex());
    }

    @Test
    public void testForgottenSuffix() {
        ParsePosition pos = new ParsePosition(0);
        Assert.assertNull((Object)new Vector2DFormat().parse("{1; 1 ", pos));
        Assert.assertEquals((long)5L, (long)pos.getErrorIndex());
    }
}

