/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ode.AbstractFieldIntegrator;
import org.apache.commons.math3.ode.FieldExpandableODE;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.FirstOrderFieldIntegrator;
import org.apache.commons.math3.ode.TestFieldProblem1;
import org.apache.commons.math3.ode.TestFieldProblem5;
import org.apache.commons.math3.ode.TestFieldProblem6;
import org.apache.commons.math3.ode.TestFieldProblemAbstract;
import org.apache.commons.math3.ode.TestFieldProblemHandler;
import org.apache.commons.math3.ode.nonstiff.AdamsFieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.DormandPrince853FieldIntegrator;
import org.apache.commons.math3.ode.sampling.FieldStepHandler;
import org.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdamsFieldIntegratorAbstractTest {
    protected abstract <T extends RealFieldElement<T>> AdamsFieldIntegrator<T> createIntegrator(Field<T> var1, int var2, double var3, double var5, double var7, double var9);

    protected abstract <T extends RealFieldElement<T>> AdamsFieldIntegrator<T> createIntegrator(Field<T> var1, int var2, double var3, double var5, double[] var7, double[] var8);

    @Test(expected=NumberIsTooSmallException.class)
    public abstract void testMinStep();

    protected <T extends RealFieldElement<T>> void doDimensionCheck(Field<T> field) {
        TestFieldProblem1<T> pb = new TestFieldProblem1<T>(field);
        double minStep = ((RealFieldElement)((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).multiply(0.1)).getReal();
        double maxStep = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
        double[] vecAbsoluteTolerance = new double[]{1.0E-15, 1.0E-16};
        double[] vecRelativeTolerance = new double[]{1.0E-15, 1.0E-16};
        AdamsFieldIntegrator<T> integ = this.createIntegrator(field, 4, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        TestFieldProblemHandler<T> handler = new TestFieldProblemHandler<T>(pb, integ);
        integ.addStepHandler(handler);
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
    }

    @Test
    public abstract void testIncreasingTolerance();

    protected <T extends RealFieldElement<T>> void doTestIncreasingTolerance(Field<T> field, double ratioMin, double ratioMax) {
        int previousCalls = Integer.MAX_VALUE;
        for (int i = -12; i < -2; ++i) {
            TestFieldProblem1<T> pb = new TestFieldProblem1<T>(field);
            double minStep = 0.0;
            double maxStep = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
            double scalAbsoluteTolerance = FastMath.pow((double)10.0, (int)i);
            double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
            AdamsFieldIntegrator<T> integ = this.createIntegrator(field, 4, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
            TestFieldProblemHandler<T> handler = new TestFieldProblemHandler<T>(pb, integ);
            integ.addStepHandler(handler);
            integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
            Assert.assertTrue((handler.getMaximalValueError().getReal() > ratioMin * scalAbsoluteTolerance ? 1 : 0) != 0);
            Assert.assertTrue((handler.getMaximalValueError().getReal() < ratioMax * scalAbsoluteTolerance ? 1 : 0) != 0);
            int calls = pb.getCalls();
            Assert.assertEquals((long)integ.getEvaluations(), (long)calls);
            Assert.assertTrue((calls <= previousCalls ? 1 : 0) != 0);
            previousCalls = calls;
        }
    }

    @Test(expected=MaxCountExceededException.class)
    public abstract void exceedMaxEvaluations();

    protected <T extends RealFieldElement<T>> void doExceedMaxEvaluations(Field<T> field, int max) {
        TestFieldProblem1<T> pb = new TestFieldProblem1<T>(field);
        double range = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
        AdamsFieldIntegrator<T> integ = this.createIntegrator(field, 2, 0.0, range, 1.0E-12, 1.0E-12);
        TestFieldProblemHandler<T> handler = new TestFieldProblemHandler<T>(pb, integ);
        integ.addStepHandler(handler);
        integ.setMaxEvaluations(max);
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
    }

    @Test
    public abstract void backward();

    protected <T extends RealFieldElement<T>> void doBackward(Field<T> field, double epsilonLast, double epsilonMaxValue, double epsilonMaxTime, String name) {
        TestFieldProblem5<T> pb = new TestFieldProblem5<T>(field);
        double range = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
        AdamsFieldIntegrator<T> integ = this.createIntegrator(field, 4, 0.0, range, 1.0E-12, 1.0E-12);
        TestFieldProblemHandler<T> handler = new TestFieldProblemHandler<T>(pb, integ);
        integ.addStepHandler(handler);
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
        Assert.assertEquals((double)0.0, (double)handler.getLastError().getReal(), (double)epsilonLast);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalValueError().getReal(), (double)epsilonMaxValue);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError().getReal(), (double)epsilonMaxTime);
        Assert.assertEquals((Object)name, (Object)integ.getName());
    }

    @Test
    public abstract void polynomial();

    protected <T extends RealFieldElement<T>> void doPolynomial(Field<T> field, int nLimit, double epsilonBad, double epsilonGood) {
        TestFieldProblem6<T> pb = new TestFieldProblem6<T>(field);
        double range = ((RealFieldElement)((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).abs()).getReal();
        for (int nSteps = 2; nSteps < 8; ++nSteps) {
            AdamsFieldIntegrator<T> integ = this.createIntegrator(field, nSteps, 1.0E-6 * range, 0.1 * range, 1.0E-4, 1.0E-4);
            integ.setStarterIntegrator(new PerfectStarter<T>(pb, nSteps));
            TestFieldProblemHandler<T> handler = new TestFieldProblemHandler<T>(pb, integ);
            integ.addStepHandler(handler);
            integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
            if (nSteps < nLimit) {
                Assert.assertTrue((handler.getMaximalValueError().getReal() > epsilonBad ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((handler.getMaximalValueError().getReal() < epsilonGood ? 1 : 0) != 0);
        }
    }

    @Test(expected=MathIllegalStateException.class)
    public abstract void testStartFailure();

    protected <T extends RealFieldElement<T>> void doTestStartFailure(Field<T> field) {
        TestFieldProblem1<T> pb = new TestFieldProblem1<T>(field);
        double minStep = ((RealFieldElement)((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).multiply(1.0E-4)).getReal();
        double maxStep = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
        double scalAbsoluteTolerance = 1.0E-6;
        double scalRelativeTolerance = 1.0E-7;
        AdamsFieldIntegrator<T> integ = this.createIntegrator(field, 6, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        integ.setStarterIntegrator((FirstOrderFieldIntegrator)new DormandPrince853FieldIntegrator(field, maxStep * 0.5, maxStep, 0.1, 0.1));
        TestFieldProblemHandler<T> handler = new TestFieldProblemHandler<T>(pb, integ);
        integ.addStepHandler(handler);
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PerfectInterpolator<T extends RealFieldElement<T>>
    implements FieldStepInterpolator<T> {
        private final TestFieldProblemAbstract<T> problem;
        private T previousTime;
        private T currentTime;

        public PerfectInterpolator(TestFieldProblemAbstract<T> problem) {
            this.problem = problem;
        }

        public void setPreviousTime(T previousTime) {
            this.previousTime = previousTime;
        }

        public void setCurrentTime(T currentTime) {
            this.currentTime = currentTime;
        }

        public T getCurrentTime() {
            return this.currentTime;
        }

        public boolean isForward() {
            return ((RealFieldElement)this.problem.getFinalTime().subtract((Object)this.problem.getInitialState().getTime())).getReal() >= 0.0;
        }

        public FieldODEStateAndDerivative<T> getPreviousState() {
            return this.getInterpolatedState(this.previousTime);
        }

        public FieldODEStateAndDerivative<T> getCurrentState() {
            return this.getInterpolatedState(this.currentTime);
        }

        public FieldODEStateAndDerivative<T> getInterpolatedState(T time) {
            RealFieldElement[] y = this.problem.computeTheoreticalState((RealFieldElement)time);
            RealFieldElement[] yDot = this.problem.computeDerivatives((RealFieldElement)time, y);
            return new FieldODEStateAndDerivative(time, y, yDot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PerfectStarter<T extends RealFieldElement<T>>
    extends AbstractFieldIntegrator<T> {
        private final PerfectInterpolator<T> interpolator;
        private final int nbSteps;

        public PerfectStarter(TestFieldProblemAbstract<T> problem, int nbSteps) {
            super(problem.getField(), "perfect-starter");
            this.interpolator = new PerfectInterpolator<T>(problem);
            this.nbSteps = nbSteps;
        }

        public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> equations, FieldODEState<T> initialState, T finalTime) {
            RealFieldElement tStart = (RealFieldElement)initialState.getTime().add(((RealFieldElement)finalTime.subtract((Object)initialState.getTime())).multiply(0.01));
            this.getEvaluationsCounter().increment(this.nbSteps);
            this.interpolator.setCurrentTime(initialState.getTime());
            for (int i = 0; i < this.nbSteps; ++i) {
                RealFieldElement tK = (RealFieldElement)((RealFieldElement)((RealFieldElement)initialState.getTime().multiply(this.nbSteps - 1 - (i + 1))).add(tStart.multiply(i + 1))).divide((double)(this.nbSteps - 1));
                this.interpolator.setPreviousTime(this.interpolator.getCurrentTime());
                this.interpolator.setCurrentTime(tK);
                for (FieldStepHandler handler : this.getStepHandlers()) {
                    handler.handleStep(this.interpolator, i == this.nbSteps - 1);
                }
            }
            return this.interpolator.getInterpolatedState(tStart);
        }
    }
}

