/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.special;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class GammaTest {
    private static final double[][] LOG_GAMMA_REF = new double[][]{{0.125, 2.019418357553796}, {0.25, 1.288022524698077}, {0.375, 0.8630739822706475}, {0.5, 0.5723649429247001}, {0.625, 0.3608294954889402}, {0.75, 0.2032809514312954}, {0.875, 0.08585870722533433}, {0.890625, 0.07353860936979656}, {0.90625, 0.06169536624059108}, {0.921875, 0.05031670080005688}, {0.9375, 0.0393909017345823}, {0.953125, 0.02890678734595923}, {0.96875, 0.01885367233441289}, {0.984375, 0.009221337197578781}, {1.0, 0.0}, {1.015625, -0.00881970970573307}, {1.03125, -0.01724677500176807}, {1.046875, -0.02528981394675729}, {1.0625, -0.03295710029357782}, {1.078125, -0.04025658272400143}, {1.09375, -0.04719590272716985}, {1.109375, -0.05378241123619192}, {1.125, -0.06002318412603958}, {1.25, -0.09827183642181316}, {1.375, -0.1177552707410788}, {1.5, -0.1207822376352452}, {1.625, -0.1091741337567954}, {1.75, -0.08440112102048555}, {1.875, -0.0476726853991883}, {1.890625, -0.04229320615532515}, {1.90625, -0.03674470657266143}, {1.921875, -0.03102893865389552}, {1.9375, -0.02514761940298887}, {1.953125, -0.01910243184040138}, {1.96875, -0.01289502598016741}, {1.984375, -0.006527019770560387}, {2.0, 0.0}, {2.015625, 0.006684476830232185}, {2.03125, 0.01352488366498562}, {2.046875, 0.02051972208453692}, {2.0625, 0.02766752152285702}, {2.078125, 0.0349668385135861}, {2.09375, 0.04241625596251728}, {2.109375, 0.05001438244545164}, {2.125, 0.05775985153034387}, {2.25, 0.1248717148923966}, {2.375, 0.2006984603774558}, {2.5, 0.2846828704729192}, {2.625, 0.3763336820249054}, {2.75, 0.4752146669149371}, {2.875, 0.5809359740231859}, {2.890625, 0.5946142560817441}, {2.90625, 0.6083932548009232}, {2.921875, 0.6222723333588501}, {2.9375, 0.6362508628423761}, {2.953125, 0.6503282221022278}, {2.96875, 0.6645037976116387}, {2.984375, 0.678776983328359}, {3.0, 0.6931471805599453}, {3.015625, 0.7076137978322324}, {3.03125, 0.7221762507608962}, {3.046875, 0.7368339619260166}, {3.0625, 0.751586360749556}, {3.078125, 0.7664328833756681}, {3.09375, 0.7813729725537568}, {3.109375, 0.7964060775242092}, {3.125, 0.811531653906724}, {3.25, 0.9358019311087253}, {3.375, 1.06569589786406}, {3.5, 1.200973602347074}, {3.625, 1.341414578068493}, {3.75, 1.486815578593417}, {3.875, 1.6369886482725}, {4.0, 1.791759469228055}, {4.125, 1.950965937095089}, {4.25, 2.114456927450371}, {4.375, 2.282091222188554}, {4.5, 2.453736570842442}, {4.625, 2.62926886637513}, {4.75, 2.808571418575736}, {4.875, 2.99153431107781}, {5.0, 3.178053830347946}, {5.125, 3.368031956881733}, {5.25, 3.561375910386697}, {5.375, 3.757997741998131}, {5.5, 3.957813967618717}, {5.625, 4.160745237339519}, {5.75, 4.366716036622286}, {5.875, 4.57565441552762}, {6.0, 4.787491742782046}, {6.125, 5.002162481906205}, {6.25, 5.219603986990229}, {6.375, 5.439756316011858}, {6.5, 5.662562059857142}, {6.625, 5.887966185430003}, {6.75, 6.115915891431546}, {6.875, 6.346360475557843}, {7.0, 6.579251212010101}, {7.125, 6.814541238336996}, {7.25, 7.05218545073854}, {7.375, 7.292140407056348}, {7.5, 7.534364236758733}, {7.625, 7.778816557302289}, {7.75, 8.025458396315983}, {7.875, 8.274252119110479}, {8.0, 8.525161361065415}, {8.125, 8.77815096449171}, {8.25, 9.033186919605123}, {8.375, 9.290236309282232}, {8.5, 9.549267257300997}, {8.625, 9.810248879795765}, {8.75, 10.07315123968124}, {8.875, 10.33794530382217}, {9.0, 10.60460290274525}, {9.125, 10.87309669270751}, {9.25, 11.14340011995171}, {9.375, 11.41548738699336}, {9.5, 11.68933342079727}, {9.625, 11.96491384271319}, {9.75, 12.24220494005076}, {9.875, 12.52118363918365}, {10.0, 12.80182748008147}, {0.8, 0.1520596783998376}, {100.0, 359.1342053695754}, {1000.0, 5905.220423209181}, {10000.0, 82099.71749644238}, {100000.0, 1051287.708973657}, {1000000.0, 1.2815504569147613E7}, {1.0E7, 1.511809493694739E8}, {1.0E8, 1.7420680661038346E9}, {1.0E9, 1.972326582750371E10}, {1.0E10, 2.202585092888106E11}};
    private static final double[][] INV_GAMMA1P_M1_REF = new double[][]{{-0.5, -0.4358104164522437}, {-0.375, -0.3029021533379859}, {-0.25, -0.183951060901737}, {-0.125, -0.08227611018520711}, {0.0, 0.0}, {0.125, 0.06186116458306091}, {0.25, 0.1032626513208373}, {0.375, 0.1249687649039041}, {0.5, 0.1283791670955126}, {0.625, 0.1153565546592225}, {0.75, 0.0880652521310173}, {0.875, 0.04882730264547758}, {1.0, 0.0}, {1.125, -0.05612340925950141}, {1.25, -0.1173898789433302}, {1.375, -0.1818408982517061}, {1.5, -0.247747221936325}};
    private static final double[][] LOG_GAMMA1P_REF = new double[][]{{-0.5, 0.5723649429247001}, {-0.375, 0.3608294954889402}, {-0.25, 0.2032809514312954}, {-0.125, 0.08585870722533433}, {0.0, 0.0}, {0.125, -0.06002318412603958}, {0.25, -0.09827183642181316}, {0.375, -0.1177552707410788}, {0.5, -0.1207822376352452}, {0.625, -0.1091741337567954}, {0.75, -0.08440112102048555}, {0.875, -0.0476726853991883}, {1.0, 0.0}, {1.125, 0.05775985153034387}, {1.25, 0.1248717148923966}, {1.375, 0.2006984603774558}, {1.5, 0.2846828704729192}};
    private static final double[][] GAMMA_REF = new double[][]{{-19.875, 4.920331854832504E-18}, {-19.75, 3.879938752480031E-18}, {-19.625, 4.323498423815027E-18}, {-19.5, 5.811045977502237E-18}, {-19.375, 9.14330910942125E-18}, {-19.25, 1.735229114436739E-17}, {-19.125, 4.653521565668223E-17}, {-18.875, -9.779159561479603E-17}, {-18.75, -7.662879036148062E-17}, {-18.625, -8.48486565673699E-17}, {-18.5, -1.133153965612936E-16}, {-18.375, -1.771516139950367E-16}, {-18.25, -3.340316045290721E-16}, {-18.125, -8.899859994340475E-16}, {-17.875, 1.845816367229275E-15}, {-17.75, 1.436789819277761E-15}, {-17.625, 1.580306228567265E-15}, {-17.5, 2.096334836383932E-15}, {-17.375, 3.255160907158799E-15}, {-17.25, 6.096076782655566E-15}, {-17.125, 1.613099623974211E-14}, {-16.875, -3.29939675642233E-14}, {-16.75, -2.550301929218027E-14}, {-16.625, -2.785289727849803E-14}, {-16.5, -3.66858596367188E-14}, {-16.375, -5.655842076188414E-14}, {-16.25, -1.051573245008085E-13}, {-16.125, -2.762433106055837E-13}, {-15.875, 5.567732026462681E-13}, {-15.75, 4.271755731440195E-13}, {-15.625, 4.630544172550298E-13}, {-15.5, 6.053166840058604E-13}, {-15.375, 9.261441399758528E-13}, {-15.25, 1.708806523138138E-12}, {-15.125, 4.454423383515037E-12}, {-14.875, -8.838774592009505E-12}, {-14.75, -6.728015277018307E-12}, {-14.625, -7.235225269609841E-12}, {-14.5, -9.382408602090835E-12}, {-14.375, -1.423946615212874E-11}, {-14.25, -2.605929947785661E-11}, {-14.125, -6.737315367566492E-11}, {-13.875, 1.314767720561414E-10}, {-13.75, 9.923822533602004E-11}, {-13.625, 1.058151695680439E-10}, {-13.5, 1.360449247303171E-10}, {-13.375, 2.046923259368506E-10}, {-13.25, 3.713450175594567E-10}, {-13.125, 9.516457956687672E-10}, {-12.875, -1.8242402122789618E-9}, {-12.75, -1.3645255983702756E-9}, {-12.625, -1.4417316853645984E-9}, {-12.5, -1.836606483859281E-9}, {-12.375, -2.7377598594053763E-9}, {-12.25, -4.920321482662802E-9}, {-12.125, -1.249035106815257E-8}, {-11.875, 2.3487092733091634E-8}, {-11.75, 1.7397701379221013E-8}, {-11.625, 1.8201862527728054E-8}, {-11.5, 2.295758104824101E-8}, {-11.375, 3.387977826014154E-8}, {-11.25, 6.027393816261932E-8}, {-11.125, 1.5144550670134987E-7}, {-10.875, -2.7890922620546314E-7}, {-10.75, -2.044229912058469E-7}, {-10.625, -2.1159665188483866E-7}, {-10.5, -2.640121820547716E-7}, {-10.375, -3.8538247770911E-7}, {-10.25, -6.780818043294673E-7}, {-10.125, -1.6848312620525174E-6}, {-9.875, 3.0331378349844124E-6}, {-9.75, 2.1975471554628537E-6}, {-9.625, 2.24821442627641E-6}, {-9.5, 2.772127911575102E-6}, {-9.375, 3.998343206232017E-6}, {-9.25, 6.95033849437704E-6}, {-9.125, 1.7058916528281738E-5}, {-8.875, -2.9952236120471066E-5}, {-8.75, -2.1426084765762827E-5}, {-8.625, -2.163906385291045E-5}, {-8.5, -2.633521515996347E-5}, {-8.375, -3.748446755842515E-5}, {-8.25, -6.429063107298763E-5}, {-8.125, -1.5566261332057086E-4}, {-7.875, 2.658260955691807E-4}, {-7.75, 1.874782417004247E-4}, {-7.625, 1.8663692573135264E-4}, {-7.5, 2.238493288596895E-4}, {-7.375, 3.1393241580181063E-4}, {-7.25, 5.303977063521479E-4}, {-7.125, 0.001264758733229638}, {-6.875, -0.002093380502607298}, {-6.75, -0.001452956373178292}, {-6.625, -0.001423106558701564}, {-6.5, -0.001678869966447671}, {-6.375, -0.002315251566538353}, {-6.25, -0.003845383371053072}, {-6.125, -0.009011405974261174}, {-5.875, 0.01439199095542518}, {-5.75, 0.009807455518953468}, {-5.625, 0.009428080951397862}, {-5.5, 0.01091265478190986}, {-5.375, 0.014759728736682}, {-5.25, 0.0240336460690817}, {-5.125, 0.05519486159234969}, {-4.875, -0.0845529468631229}, {-4.75, -0.05639286923398244}, {-4.625, -0.05303295535161297}, {-4.5, -0.06001960130050425}, {-4.375, -0.07933354195966577}, {-4.25, -0.1261766418626789}, {-4.125, -0.2828736656607921}, {-3.875, 0.4121956159577241}, {-3.75, 0.2678661288614166}, {-3.625, 0.24527741850121}, {-3.5, 0.2700882058522691}, {-3.375, 0.3470842460735378}, {-3.25, 0.5362507279163854}, {-3.125, 1.166853870850768}, {-2.875, -1.597258011836181}, {-2.75, -1.004497983230312}, {-2.625, -0.8891306420668862}, {-2.5, -0.9453087204829419}, {-2.375, -1.17140933049819}, {-2.25, -1.742814865728253}, {-2.125, -3.646418346408649}, {-1.875, 4.59211678402902}, {-1.75, 2.762369453883359}, {-1.625, 2.333967935425576}, {-1.5, 2.363271801207355}, {-1.375, 2.782097159933201}, {-1.25, 3.921333447888569}, {-1.125, 7.748638986118379}, {-0.875, -8.610218970054413}, {-0.75, -4.834146544295877}, {-0.625, -3.792697895066561}, {-0.5, -3.544907701811032}, {-0.375, -3.825383594908152}, {-0.25, -4.901666809860711}, {-0.125, -8.717218859383175}, {0.125, 7.533941598797612}, {0.25, 3.625609908221908}, {0.375, 2.370436184416601}, {0.5, 1.772453850905516}, {0.625, 1.434518848090557}, {0.75, 1.225416702465178}, {0.875, 1.089652357422897}, {1.0, 1.0}, {1.125, 0.9417426998497015}, {1.25, 0.906402477055477}, {1.375, 0.8889135691562253}, {1.5, 0.886226925452758}, {1.625, 0.896574280056598}, {1.75, 0.9190625268488832}, {1.875, 0.9534458127450348}, {2.0, 1.0}, {2.125, 1.059460537330914}, {2.25, 1.133003096319346}, {2.375, 1.22225615758981}, {2.5, 1.329340388179137}, {2.625, 1.456933205091972}, {2.75, 1.608359421985546}, {2.875, 1.78771089889694}, {3.0, 2.0}, {3.125, 2.251353641828193}, {3.25, 2.549256966718529}, {3.375, 2.902858374275799}, {3.5, 3.323350970447843}, {3.625, 3.824449663366426}, {3.75, 4.422988410460251}, {3.875, 5.139668834328703}, {4.0, 6.0}, {4.125, 7.035480130713102}, {4.25, 8.28508514183522}, {4.375, 9.797147013180819}, {4.5, 11.63172839656745}, {4.625, 13.86363002970329}, {4.75, 16.58620653922594}, {4.875, 19.91621673302373}, {5.0, 24.0}, {5.125, 29.02135553919155}, {5.25, 35.21161185279968}, {5.375, 42.86251818266609}, {5.5, 52.34277778455352}, {5.625, 64.11928888737773}, {5.75, 78.78448106132322}, {5.875, 97.09155657349066}, {6.0, 120.0}, {6.125, 148.7344471383567}, {6.25, 184.8609622271983}, {6.375, 230.3860352318302}, {6.5, 287.8852778150443}, {6.625, 360.6709999914997}, {6.75, 453.0107661026085}, {6.875, 570.4128948692577}, {7.0, 720.0}, {7.125, 910.9984887224346}, {7.25, 1155.38101391999}, {7.375, 1468.710974602918}, {7.5, 1871.254305797788}, {7.625, 2389.445374943686}, {7.75, 3057.822671192607}, {7.875, 3921.588652226146}, {8.0, 5040.0}, {8.125, 6490.864232147346}, {8.25, 8376.512350919926}, {8.375, 10831.74343769652}, {8.5, 14034.40729348341}, {8.625, 18219.5209839456}, {8.75, 23698.12570174271}, {8.875, 30882.5106362809}, {9.0, 40320.0}, {9.125, 52738.27188619719}, {9.25, 69106.22689508938}, {9.375, 90715.85129070834}, {9.5, 119292.461994609}, {9.625, 157143.3684865308}, {9.75, 207358.5998902487}, {9.875, 274082.281896993}, {10.0, 362880.0}, {10.125, 481236.7309615494}, {10.25, 639232.5987795768}, {10.375, 850461.1058503906}, {10.5, 1133278.388948786}, {10.625, 1512504.921682859}, {10.75, 2021746.348929925}, {10.875, 2706562.533732806}, {11.0, 3628800.0}, {11.125, 4872521.900985687}, {11.25, 6552134.137490662}, {11.375, 8823533.973197803}, {11.5, 1.1899423083962249E7}, {11.625, 1.6070364792880382E7}, {11.75, 2.1733773250996687E7}, {11.875, 2.943386755434427E7}, {12.0, 3.99168E7}, {12.125, 5.420680614846578E7}, {12.25, 7.371150904676995E7}, {12.375, 1.0036769894512501E8}, {12.5, 1.3684336546556586E8}, {12.625, 1.8681799071723443E8}, {12.75, 2.5537183569921106E8}, {12.875, 3.495271772078382E8}, {13.0, 4.790016E8}, {13.125, 6.572575245501475E8}, {13.25, 9.029659858229319E8}, {13.375, 1.242050274445922E9}, {13.5, 1.7105420683195732E9}, {13.625, 2.3585771328050847E9}, {13.75, 3.255990905164942E9}, {13.875, 4.500162406550916E9}, {14.0, 6.2270208E9}, {14.125, 8.626505009720684E9}, {14.25, 1.196429931215385E10}, {14.375, 1.66124224207142E10}, {14.5, 2.309231792231424E10}, {14.625, 3.213561343446927E10}, {14.75, 4.476987494601794E10}, {14.875, 6.243975339089396E10}, {15.0, 8.71782912E10}, {15.125, 1.218493832623047E11}, {15.25, 1.704912651981923E11}, {15.375, 2.388035722977667E11}, {15.5, 3.348386098735565E11}, {15.625, 4.699833464791132E11}, {15.75, 6.603556554537646E11}, {15.875, 9.287913316895475E11}, {16.0, 1.307674368E12}, {16.125, 1.842971921842358E12}, {16.25, 2.599991794272433E12}, {16.375, 3.671604924078163E12}, {16.5, 5.189998453040126E12}, {16.625, 7.343489788736144E12}, {16.75, 1.040060157339679E13}, {16.875, 1.474456239057157E13}, {17.0, 2.0922789888E13}, {17.125, 2.971792223970803E13}, {17.25, 4.224986665692704E13}, {17.375, 6.012253063177992E13}, {17.5, 8.563497447516206E13}, {17.625, 1.220855177377384E14}, {17.75, 1.742100763543963E14}, {17.875, 2.488144903408952E14}, {18.0, 3.55687428096E14}, {18.125, 5.08919418355E14}, {18.25, 7.288101998319914E14}, {18.375, 1.044628969727176E15}, {18.5, 1.498612053315336E15}, {18.625, 2.151757250127639E15}, {18.75, 3.092228855290534E15}, {18.875, 4.447559014843502E15}, {19.0, 6.402373705728E15}, {19.125, 9.224164457684374E15}, {19.25, 1.330078614693384E16}, {19.375, 1.919505731873686E16}, {19.5, 2.772432298633372E16}, {19.625, 4.007647878362728E16}, {19.75, 5.797929103669752E16}, {19.875, 8.39476764051711E16}, {20.0, 1.21645100408832E17}, {20.5, 5.406242982335075E17}, {21.0, 2.43290200817664E18}, {21.5, 1.10827981137869E19}, {22.0, 5.109094217170944E19}, {22.5, 2.382801594464184E20}, {23.0, 1.124000727777608E21}, {23.5, 5.361303587544415E21}, {24.0, 2.585201673888498E22}, {24.5, 1.259906343072938E23}, {25.0, 6.204484017332395E23}, {25.5, 3.086770540528697E24}, {26.0, 1.551121004333099E25}, {26.5, 7.871264878348176E25}, {27.0, 4.032914611266056E26}, {27.5, 2.085885192762267E27}, {28.0, 1.088886945041835E28}, {28.5, 5.736184280096234E28}, {29.0, 3.048883446117139E29}, {29.5, 1.634812519827427E30}, {30.0, 8.841761993739702E30}, {30.5, 4.822696933490909E31}, {31.0, 2.65252859812191E32}, {31.5, 1.470922564714727E33}, {32.0, 8.222838654177922E33}, {32.5, 4.633406078851391E34}, {33.0, 2.631308369336935E35}, {33.5, 1.505856975626702E36}, {34.0, 8.683317618811885E36}, {34.5, 5.044620868349451E37}, {35.0, 2.952327990396041E38}, {35.5, 1.740394199580561E39}, {36.0, 1.033314796638614E40}, {36.5, 6.178399408510991E40}, {37.0, 3.719933267899013E41}, {37.5, 2.255115784106512E42}, {38.0, 1.376375309122634E43}, {38.5, 8.456684190399419E43}, {39.0, 5.230226174666011E44}, {39.5, 3.255823413303776E45}, {40.0, 2.039788208119745E46}, {40.5, 1.286050248254992E47}, {41.0, 8.159152832478975E47}, {41.5, 5.208503505432716E48}, {42.0, 3.345252661316381E49}, {42.5, 2.161528954754577E50}, {43.0, 1.40500611775288E51}, {43.5, 9.186498057706952E51}, {44.0, 6.041526306337383E52}, {44.5, 3.996126655102524E53}, {45.0, 2.658271574788449E54}, {45.5, 1.778276361520623E55}, {46.0, 1.196222208654802E56}, {46.5, 8.091157444918836E56}, {47.0, 5.502622159812088E57}, {47.5, 3.762388211887259E58}, {48.0, 2.586232415111682E59}, {48.5, 1.787134400646448E60}, {49.0, 1.241391559253607E61}, {49.5, 8.667601843135274E61}, {50.0, 6.082818640342675E62}, {50.5, 4.290462912351959E63}, {51.0, 3.041409320171338E64}, {51.5, 2.16668377073774E65}, {52.0, 1.551118753287382E66}, {52.5, 1.115842141929936E67}, {53.0, 8.065817517094388E67}, {53.5, 5.858171245132164E68}, {54.0, 4.274883284060025E69}, {54.5, 3.134121616145708E70}, {55.0, 2.308436973392413E71}, {55.5, 1.70809628079941E72}, {56.0, 1.269640335365828E73}, {56.5, 9.479934358436727E73}, {57.0, 7.109985878048635E74}, {57.5, 5.356162912516752E75}, {58.0, 4.052691950487721E76}, {58.5, 3.079793674697132E77}, {59.0, 2.350561331282878E78}, {59.5, 1.801679299697822E79}, {60.0, 1.386831185456898E80}, {60.5, 1.071999183320204E81}, {61.0, 8.320987112741392E81}, {61.5, 6.485595059087236E82}, {62.0, 5.075802138772249E83}, {62.5, 3.98864096133865E84}, {63.0, 3.146997326038794E85}, {63.5, 2.492900600836656E86}, {64.0, 1.98260831540444E87}, {64.5, 1.582991881531277E88}, {65.0, 1.268869321858841E89}, {65.5, 1.021029763587673E90}, {66.0, 8.247650592082472E90}, {66.5, 6.687744951499262E91}, {67.0, 5.443449390774431E92}, {67.5, 4.447350392747009E93}, {68.0, 3.647111091818868E94}, {68.5, 3.001961515104231E95}, {69.0, 2.48003554243683E96}, {69.5, 2.056343637846398E97}, {70.0, 1.711224524281413E98}, {70.5, 1.429158828303247E99}, {71.0, 1.19785716699699E100}, {71.5, 1.00755697395379E101}, {72.0, 8.50478588567862E101}, {72.5, 7.20403236376959E102}, {73.0, 6.12344583768861E103}, {73.5, 5.22292346373295E104}, {74.0, 4.47011546151268E105}, {74.5, 3.83884874584372E106}, {75.0, 3.30788544151939E107}, {75.5, 2.85994231565357E108}, {76.0, 2.48091408113954E109}, {76.5, 2.15925644831845E110}, {77.0, 1.88549470166605E111}, {77.5, 1.65183118296361E112}, {78.0, 1.45183092028286E113}, {78.5, 1.2801691667968E114}, {79.0, 1.13242811782063E115}, {79.5, 1.00493279593549E116}, {80.0, 8.94618213078298E116}, {80.5, 7.98921572768712E117}, {81.0, 7.15694570462638E118}, {81.5, 6.43131866078814E119}, {82.0, 5.79712602074737E120}, {82.5, 5.24152470854233E121}, {83.0, 4.75364333701284E122}, {83.5, 4.32425788454742E123}, {84.0, 3.94552396972066E124}, {84.5, 3.6107553335971E125}, {85.0, 3.31424013456535E126}, {85.5, 3.05108825688955E127}, {86.0, 2.81710411438055E128}, {86.5, 2.60868045964056E129}, {87.0, 2.42270953836727E130}, {87.5, 2.25650859758909E131}, {88.0, 2.10775729837953E132}, {88.5, 1.97444502289045E133}, {89.0, 1.85482642257398E134}, {89.5, 1.74738384525805E135}, {90.0, 1.65079551609085E136}, {90.5, 1.56390854150595E137}, {91.0, 1.48571596448176E138}, {91.5, 1.41533723006289E139}, {92.0, 1.3520015276784E140}, {92.5, 1.29503356550754E141}, {93.0, 1.24384140546413E142}, {93.5, 1.19790604809448E143}, {94.0, 1.15677250708164E144}, {94.5, 1.12004215496834E145}, {95.0, 1.08736615665674E146}, {95.5, 1.05843983644508E147}, {96.0, 1.03299784882391E148}, {96.5, 1.01081004380505E149}, {97.0, 9.9167793487095E149}, {97.5, 9.75431692271873E150}, {98.0, 9.61927596824821E151}, {98.5, 9.51045899965076E152}, {99.0, 9.42689044888325E153}, {99.5, 9.367802114656E154}, {100.0, 9.33262154439441E155}};

    private void testRegularizedGamma(double expected, double a, double x) {
        double actualP = Gamma.regularizedGammaP((double)a, (double)x);
        double actualQ = Gamma.regularizedGammaQ((double)a, (double)x);
        TestUtils.assertEquals(expected, actualP, 1.0E-14);
        TestUtils.assertEquals(actualP, 1.0 - actualQ, 1.0E-14);
    }

    private void testLogGamma(double expected, double x) {
        double actual = Gamma.logGamma((double)x);
        TestUtils.assertEquals(expected, actual, 1.0E-14);
    }

    @Test
    public void testRegularizedGammaNanPositive() {
        this.testRegularizedGamma(Double.NaN, Double.NaN, 1.0);
    }

    @Test
    public void testRegularizedGammaPositiveNan() {
        this.testRegularizedGamma(Double.NaN, 1.0, Double.NaN);
    }

    @Test
    public void testRegularizedGammaNegativePositive() {
        this.testRegularizedGamma(Double.NaN, -1.5, 1.0);
    }

    @Test
    public void testRegularizedGammaPositiveNegative() {
        this.testRegularizedGamma(Double.NaN, 1.0, -1.0);
    }

    @Test
    public void testRegularizedGammaZeroPositive() {
        this.testRegularizedGamma(Double.NaN, 0.0, 1.0);
    }

    @Test
    public void testRegularizedGammaPositiveZero() {
        this.testRegularizedGamma(0.0, 1.0, 0.0);
    }

    @Test
    public void testRegularizedGammaPositivePositive() {
        this.testRegularizedGamma(0.632120558828558, 1.0, 1.0);
    }

    @Test
    public void testLogGammaNan() {
        this.testLogGamma(Double.NaN, Double.NaN);
    }

    @Test
    public void testLogGammaNegative() {
        this.testLogGamma(Double.NaN, -1.0);
    }

    @Test
    public void testLogGammaZero() {
        this.testLogGamma(Double.NaN, 0.0);
    }

    @Test
    public void testLogGammaPositive() {
        this.testLogGamma(0.6931471805599457, 3.0);
    }

    @Test
    public void testDigammaLargeArgs() {
        double eps = 1.0E-8;
        Assert.assertEquals((double)4.600161852738087, (double)Gamma.digamma((double)100.0), (double)eps);
        Assert.assertEquals((double)3.901989673427892, (double)Gamma.digamma((double)50.0), (double)eps);
        Assert.assertEquals((double)2.970523992242149, (double)Gamma.digamma((double)20.0), (double)eps);
        Assert.assertEquals((double)2.9958363947076467, (double)Gamma.digamma((double)20.5), (double)eps);
        Assert.assertEquals((double)2.262214357094148, (double)Gamma.digamma((double)10.1), (double)eps);
        Assert.assertEquals((double)2.116858818900438, (double)Gamma.digamma((double)8.8), (double)eps);
        Assert.assertEquals((double)1.8727843350984672, (double)Gamma.digamma((double)7.0), (double)eps);
        Assert.assertEquals((double)0.42278433509846713, (double)Gamma.digamma((double)2.0), (double)eps);
        Assert.assertEquals((double)-100.56088545786868, (double)Gamma.digamma((double)0.01), (double)eps);
        Assert.assertEquals((double)-4.039039896592188, (double)Gamma.digamma((double)-0.8), (double)eps);
        Assert.assertEquals((double)4.200321004140185, (double)Gamma.digamma((double)-6.3), (double)eps);
    }

    @Test
    public void testDigammaSmallArgs() {
        double[] expected = new double[]{-10.423754940411078, -100.56088545786868, -1000.5755719318103, -10000.577051183514, -100000.57719921568, -1000000.57721402, -1.00000005772155E7, -1.0000000057721564E8, -1.0000000005772157E9, -1.0000000000577215E10, -1.0000000000057721E11, -1.0000000000005773E12, -1.0000000000000578E13, -1.0000000000000058E14, -1.0000000000000006E15, -1.0E16, -1.0E17, -1.0E18, -1.0E19, -1.0E20, -1.0E21, -1.0E22, -1.0E23, -1.0E24, -1.0E25, -1.0E26, -1.0E27, -1.0E28, -1.0E29, -1.0E30};
        for (double n = 1.0; n < 30.0; n += 1.0) {
            this.checkRelativeError(String.format("Test %.0f: ", n), expected[(int)(n - 1.0)], Gamma.digamma((double)FastMath.pow((double)10.0, (double)(-n))), 1.0E-8);
        }
    }

    @Test
    public void testDigammaNonRealArgs() {
        Assert.assertTrue((boolean)Double.isNaN(Gamma.digamma((double)Double.NaN)));
        Assert.assertTrue((boolean)Double.isInfinite(Gamma.digamma((double)Double.POSITIVE_INFINITY)));
        Assert.assertTrue((boolean)Double.isInfinite(Gamma.digamma((double)Double.NEGATIVE_INFINITY)));
    }

    @Test
    public void testTrigamma() {
        double eps = 1.0E-8;
        double[] data = new double[]{1.0E-4, 1.0000000164469369E8, 0.001, 1000001.6425331959, 0.01, 10001.621213528313, 0.1, 101.43329915079276, 1.0, 1.6449340668482264, 2.0, 0.6449340668482264, 3.0, 0.39493406684822646, 4.0, 0.2838229557371153, 5.0, 0.22132295573711533, 10.0, 0.10516633568168575, 20.0, 0.05127082293520312, 50.0, 0.020201333226697125, 100.0, 0.010050166663333571};
        for (int i = data.length - 2; i >= 0; i -= 2) {
            Assert.assertEquals((String)String.format("trigamma %.0f", data[i]), (double)data[i + 1], (double)Gamma.trigamma((double)data[i]), (double)eps);
        }
    }

    @Test
    public void testTrigammaNonRealArgs() {
        Assert.assertTrue((boolean)Double.isNaN(Gamma.trigamma((double)Double.NaN)));
        Assert.assertTrue((boolean)Double.isInfinite(Gamma.trigamma((double)Double.POSITIVE_INFINITY)));
        Assert.assertTrue((boolean)Double.isInfinite(Gamma.trigamma((double)Double.NEGATIVE_INFINITY)));
    }

    @Test
    public void testLogGamma() {
        int ulps = 3;
        for (int i = 0; i < LOG_GAMMA_REF.length; ++i) {
            double[] data = LOG_GAMMA_REF[i];
            double x = data[0];
            double expected = data[1];
            double actual = Gamma.logGamma((double)x);
            double tol = expected == 0.0 ? 1.0E-15 : 3.0 * FastMath.ulp((double)expected);
            Assert.assertEquals((String)Double.toString(x), (double)expected, (double)actual, (double)tol);
        }
    }

    @Test
    public void testLogGammaPrecondition1() {
        Assert.assertTrue((boolean)Double.isNaN(Gamma.logGamma((double)0.0)));
    }

    @Test
    public void testLogGammaPrecondition2() {
        Assert.assertTrue((boolean)Double.isNaN(Gamma.logGamma((double)-1.0)));
    }

    @Test
    public void testInvGamma1pm1() {
        int ulps = 3;
        for (int i = 0; i < INV_GAMMA1P_M1_REF.length; ++i) {
            double[] ref = INV_GAMMA1P_M1_REF[i];
            double x = ref[0];
            double expected = ref[1];
            double actual = Gamma.invGamma1pm1((double)x);
            double tol = 3.0 * FastMath.ulp((double)expected);
            Assert.assertEquals((String)Double.toString(x), (double)expected, (double)actual, (double)tol);
        }
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testInvGamma1pm1Precondition1() {
        Gamma.invGamma1pm1((double)-0.51);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testInvGamma1pm1Precondition2() {
        Gamma.invGamma1pm1((double)1.51);
    }

    @Test
    public void testLogGamma1p() {
        int ulps = 3;
        for (int i = 0; i < LOG_GAMMA1P_REF.length; ++i) {
            double[] ref = LOG_GAMMA1P_REF[i];
            double x = ref[0];
            double expected = ref[1];
            double actual = Gamma.logGamma1p((double)x);
            double tol = 3.0 * FastMath.ulp((double)expected);
            Assert.assertEquals((String)Double.toString(x), (double)expected, (double)actual, (double)tol);
        }
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testLogGamma1pPrecondition1() {
        Gamma.logGamma1p((double)-0.51);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testLogGamma1pPrecondition2() {
        Gamma.logGamma1p((double)1.51);
    }

    @Test
    public void testGamma() {
        for (int i = 0; i < GAMMA_REF.length; ++i) {
            double[] ref = GAMMA_REF[i];
            double x = ref[0];
            double expected = ref[1];
            double actual = Gamma.gamma((double)x);
            double absX = FastMath.abs((double)x);
            int ulps = absX <= 8.0 ? 3 : (absX <= 20.0 ? 5 : (absX <= 30.0 ? 50 : (absX <= 50.0 ? 180 : 500)));
            double tol = (double)ulps * FastMath.ulp((double)expected);
            Assert.assertEquals((String)Double.toString(x), (double)expected, (double)actual, (double)tol);
        }
    }

    @Test
    public void testGammaNegativeInteger() {
        for (int i = -100; i <= 0; ++i) {
            Assert.assertTrue((String)Integer.toString(i), (boolean)Double.isNaN(Gamma.gamma((double)i)));
        }
    }

    @Test
    public void testGammaNegativeDouble() {
        double previousGamma = Gamma.gamma((double)-18.5);
        for (double x = -19.5; x > -25.0; x -= 1.0) {
            double gamma = Gamma.gamma((double)x);
            Assert.assertEquals((long)((int)FastMath.signum((double)previousGamma)), (long)(-((int)FastMath.signum((double)gamma))));
            previousGamma = gamma;
        }
    }

    private void checkRelativeError(String msg, double expected, double actual, double tolerance) {
        Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)FastMath.abs((double)(tolerance * actual)));
    }
}

