/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.solvers;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math4.legacy.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math4.legacy.exception.TooManyEvaluationsException;

public class BisectionSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public BisectionSolver() {
        this(1.0E-6);
    }

    public BisectionSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public BisectionSolver(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    @Override
    protected double doSolve() throws TooManyEvaluationsException {
        double m;
        double min = this.getMin();
        double max = this.getMax();
        this.verifyInterval(min, max);
        double absoluteAccuracy = this.getAbsoluteAccuracy();
        do {
            m = UnivariateSolverUtils.midpoint(min, max);
            double fmin = this.computeObjectiveValue(min);
            double fm = this.computeObjectiveValue(m);
            if (fm * fmin > 0.0) {
                min = m;
                continue;
            }
            max = m;
        } while (!(JdkMath.abs((double)(max - min)) <= absoluteAccuracy));
        m = UnivariateSolverUtils.midpoint(min, max);
        return m;
    }
}

