/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.genetics;

import org.apache.commons.math4.legacy.exception.NumberIsTooSmallException;
import org.apache.commons.math4.legacy.genetics.Population;
import org.apache.commons.math4.legacy.genetics.StoppingCondition;

public class FixedGenerationCount
implements StoppingCondition {
    private int numGenerations;
    private final int maxGenerations;

    public FixedGenerationCount(int maxGenerations) throws NumberIsTooSmallException {
        if (maxGenerations <= 0) {
            throw new NumberIsTooSmallException((Number)maxGenerations, (Number)1, true);
        }
        this.maxGenerations = maxGenerations;
    }

    @Override
    public boolean isSatisfied(Population population) {
        if (this.numGenerations < this.maxGenerations) {
            ++this.numGenerations;
            return false;
        }
        return true;
    }

    public int getNumGenerations() {
        return this.numGenerations;
    }
}

