/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.inference;

import java.util.stream.IntStream;
import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.exception.ConvergenceException;
import org.apache.commons.math4.legacy.exception.MaxCountExceededException;
import org.apache.commons.math4.legacy.exception.NoDataException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.stat.ranking.NaNStrategy;
import org.apache.commons.math4.legacy.stat.ranking.NaturalRanking;
import org.apache.commons.math4.legacy.stat.ranking.TiesStrategy;
import org.apache.commons.statistics.distribution.NormalDistribution;

public class MannWhitneyUTest {
    private NaturalRanking naturalRanking;

    public MannWhitneyUTest() {
        this.naturalRanking = new NaturalRanking(NaNStrategy.FIXED, TiesStrategy.AVERAGE);
    }

    public MannWhitneyUTest(NaNStrategy nanStrategy, TiesStrategy tiesStrategy) {
        this.naturalRanking = new NaturalRanking(nanStrategy, tiesStrategy);
    }

    private void ensureDataConformance(double[] x, double[] y) throws NullArgumentException, NoDataException {
        if (x == null || y == null) {
            throw new NullArgumentException();
        }
        if (x.length == 0 || y.length == 0) {
            throw new NoDataException();
        }
    }

    private double[] concatenateSamples(double[] x, double[] y) {
        double[] z = new double[x.length + y.length];
        System.arraycopy(x, 0, z, 0, x.length);
        System.arraycopy(y, 0, z, x.length, y.length);
        return z;
    }

    public double mannWhitneyU(double[] x, double[] y) throws NullArgumentException, NoDataException {
        this.ensureDataConformance(x, y);
        double[] z = this.concatenateSamples(x, y);
        double[] ranks = this.naturalRanking.rank(z);
        double sumRankX = 0.0;
        sumRankX = IntStream.range(0, x.length).mapToDouble(i -> ranks[i]).sum();
        double u1 = sumRankX - (double)((long)x.length * (long)(x.length + 1) / 2L);
        double u2 = (double)((long)x.length * (long)y.length) - u1;
        return JdkMath.min((double)u1, (double)u2);
    }

    private double calculateAsymptoticPValue(double umin, int n1, int n2) throws ConvergenceException, MaxCountExceededException {
        long n1n2prod = (long)n1 * (long)n2;
        double eU = (double)n1n2prod / 2.0;
        double varU = (double)(n1n2prod * (long)(n1 + n2 + 1)) / 12.0;
        double z = (umin - eU) / JdkMath.sqrt((double)varU);
        NormalDistribution standardNormal = NormalDistribution.of((double)0.0, (double)1.0);
        return 2.0 * standardNormal.cumulativeProbability(z);
    }

    public double mannWhitneyUTest(double[] x, double[] y) throws NullArgumentException, NoDataException, ConvergenceException, MaxCountExceededException {
        this.ensureDataConformance(x, y);
        double uMin = this.mannWhitneyU(x, y);
        return this.calculateAsymptoticPValue(uMin, x.length, y.length);
    }
}

