/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.creadur.tentacles.IOSystem;
import org.apache.creadur.tentacles.TentaclesResources;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class TemplateBuilder {
    private static final String LOG_TAG_NAME = TemplateBuilder.class.getName();
    private final TentaclesResources tentaclesResources;
    private final VelocityEngine engine;
    private final IOSystem ioSystem;
    private final String templateName;
    private final Map<String, Object> templateContextMap = new ConcurrentHashMap<String, Object>();

    public TemplateBuilder(String template, IOSystem ioSystem, VelocityEngine engine, TentaclesResources tentaclesResources) {
        this.templateName = template;
        this.ioSystem = ioSystem;
        this.engine = engine;
        this.tentaclesResources = tentaclesResources;
    }

    public TemplateBuilder add(String key, Object value) {
        this.templateContextMap.put(key, value);
        return this;
    }

    public TemplateBuilder addAll(Map<String, Object> map) {
        this.templateContextMap.putAll(map);
        return this;
    }

    public String apply() {
        StringWriter writer = new StringWriter();
        this.evaluate(writer);
        return writer.toString();
    }

    public File write(File file) throws IOException {
        this.ioSystem.writeString(file, this.apply());
        return file;
    }

    private void evaluate(Writer writer) {
        try {
            Reader templateReader = this.tentaclesResources.read(this.templateName);
            VelocityContext context = new VelocityContext(this.templateContextMap);
            this.engine.evaluate((Context)context, writer, LOG_TAG_NAME, templateReader);
        }
        catch (IOException ioe) {
            throw new RuntimeException("can't apply template " + this.templateName, ioe);
        }
    }
}

