/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.creadur.tentacles.IOSystem;

public class TentaclesResources {
    private final IOSystem ioSystem;

    public TentaclesResources(IOSystem ioSystem) {
        this.ioSystem = ioSystem;
    }

    public Reader read(String resourceName) throws IOException {
        URL resourceUrl = this.toUrl(resourceName);
        InputStreamReader templateReader = new InputStreamReader(resourceUrl.openStream());
        return templateReader;
    }

    public String readText(String resourcePath) throws IOException {
        String text = this.ioSystem.slurp(this.toUrl(resourcePath));
        return text;
    }

    public void copyTo(String resourcePath, File to) throws IOException {
        this.ioSystem.copy(this.toUrl(resourcePath).openStream(), to);
    }

    private URL toUrl(String resourcePath) {
        URL resourceUrl = this.getClass().getClassLoader().getResource(resourcePath);
        if (resourceUrl == null) {
            throw new IllegalStateException("Tentacles expects the classpath to contain " + resourcePath);
        }
        return resourceUrl;
    }
}

