/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UtilTest {
    @Test
    public void checkCombBufItemCapacity() {
        int k = 227;
        int capEl = ClassicUtil.computeCombinedBufferItemCapacity((int)k, (long)0L);
        Assert.assertEquals((int)capEl, (int)4);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkThePreLongsFlagsCap() {
        ClassicUtil.checkPreLongsFlagsCap((int)2, (int)0, (long)15L);
    }

    @Test
    public void checkHiBitPos() {
        int bitPos = ClassicUtil.hiBitPos((long)4096L);
        Assert.assertEquals((int)bitPos, (int)12);
    }

    @Test
    public void checkNumValidLevels() {
        long v = 0xFFFFFFFFL;
        int ones = ClassicUtil.computeValidLevels((long)v);
        Assert.assertEquals((int)ones, (int)32);
    }

    @Test
    public void testPositionOfLowestZeroBitStartingAt() {
        int[] answers = new int[]{9, 8, 7, 7, 7, 4, 4, 4, 1, 1};
        long v = 109L;
        int i = 0;
        int j = 9;
        while (i < 10) {
            int result = ClassicUtil.lowestZeroBitStartingAt((long)v, (int)i);
            Assert.assertTrue((answers[j] == result ? 1 : 0) != 0);
            ++i;
            --j;
        }
    }

    @Test
    public void testPositionOfLowestZeroBitStartingAt2() {
        long bits = -1L;
        int startingBit = 70;
        int result = ClassicUtil.lowestZeroBitStartingAt((long)bits, (int)startingBit);
        Assert.assertEquals((int)result, (int)64);
    }

    private static void assertMergeTestPrecondition(double[] arr, long[] brr, int arrLen, int blkSize) {
        int i;
        int violationsCount = 0;
        for (i = 0; i < arrLen - 1; ++i) {
            if ((i + 1) % blkSize == 0 || !(arr[i] > arr[i + 1])) continue;
            ++violationsCount;
        }
        for (i = 0; i < arrLen; ++i) {
            if (brr[i] == (long)(1.0E12 * (1.0 - arr[i]))) continue;
            ++violationsCount;
        }
        if (brr[arrLen] != 0L) {
            ++violationsCount;
        }
        Assert.assertEquals((int)violationsCount, (int)0);
    }

    private static void assertMergeTestPostcondition(double[] arr, long[] brr, int arrLen) {
        int i;
        int violationsCount = 0;
        for (i = 0; i < arrLen - 1; ++i) {
            if (!(arr[i] > arr[i + 1])) continue;
            ++violationsCount;
        }
        for (i = 0; i < arrLen; ++i) {
            if (brr[i] == (long)(1.0E12 * (1.0 - arr[i]))) continue;
            ++violationsCount;
        }
        if (brr[arrLen] != 0L) {
            ++violationsCount;
        }
        Assert.assertEquals((int)violationsCount, (int)0);
    }

    private static double[] makeMergeTestInput(int arrLen, int blkSize) {
        double[] arr = new double[arrLen];
        double pick = Math.random();
        for (int i = 0; i < arrLen; ++i) {
            int denom;
            int j;
            if (pick < 0.01) {
                arr[i] = 0.3;
                continue;
            }
            if (pick < 0.02) {
                j = i + 1;
                denom = arrLen + 1;
                arr[i] = (double)j / (double)denom;
                continue;
            }
            if (pick < 0.03) {
                j = i + 1;
                denom = arrLen + 1;
                arr[i] = 1.0 - (double)j / (double)denom;
                continue;
            }
            arr[i] = Math.random();
        }
        for (int start = 0; start < arrLen; start += blkSize) {
            Arrays.sort(arr, start, Math.min(arrLen, start + blkSize));
        }
        return arr;
    }

    private static long[] makeTheTandemArray(double[] arr) {
        long[] brr = new long[arr.length + 1];
        for (int i = 0; i < arr.length; ++i) {
            brr[i] = (long)(1.0E12 * (1.0 - arr[i]));
        }
        brr[arr.length] = 0L;
        return brr;
    }

    @Test
    public void checkBlockyTandemMergeSort() {
        UtilTest.testBlockyTandemMergeSort(10, 50);
    }

    private static void testBlockyTandemMergeSort(int numTries, int maxArrLen) {
        int arrLen = 0;
        double[] arr = null;
        for (arrLen = 0; arrLen <= maxArrLen; ++arrLen) {
            for (int blkSize = 1; blkSize <= arrLen + 100; ++blkSize) {
                for (int tryno = 1; tryno <= numTries; ++tryno) {
                    arr = UtilTest.makeMergeTestInput(arrLen, blkSize);
                    long[] brr = UtilTest.makeTheTandemArray(arr);
                    UtilTest.assertMergeTestPrecondition(arr, brr, arrLen, blkSize);
                    DoublesSketch.blockyTandemMergeSort((double[])arr, (long[])brr, (int)arrLen, (int)blkSize);
                    for (int i = 0; i < arrLen - 1; ++i) {
                        assert (arr[i] <= arr[i + 1]);
                    }
                    UtilTest.assertMergeTestPostcondition(arr, brr, arrLen);
                }
            }
        }
    }

    @Test
    public void printlnTest() {
        UtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

