/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.nio.ByteOrder;
import jdk.incubator.foreign.ResourceScope;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.BackwardConversions;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UnionImpl;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.apache.datasketches.thetacommon.ThetaUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionImplTest {
    @Test
    public void checkGetCurrentAndMaxBytes() {
        int lgK = 10;
        Union union = Sketches.setOperationBuilder().setLogNominalEntries(10).buildUnion();
        Assert.assertEquals((int)union.getCurrentBytes(), (int)288);
        Assert.assertEquals((int)union.getMaxUnionBytes(), (int)16416);
    }

    @Test
    public void checkUpdateWithSketch() {
        int k = 16;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[152]);
        WritableMemory mem2 = WritableMemory.writableWrap((byte[])new byte[152]);
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            sketch.update((long)i);
        }
        CompactSketch sketchInDirectOrd = sketch.compact(true, mem);
        CompactSketch sketchInDirectUnord = sketch.compact(false, mem2);
        CompactSketch sketchInHeap = sketch.compact(true, null);
        Union union = Sketches.setOperationBuilder().setNominalEntries(16).buildUnion();
        union.union((Sketch)sketchInDirectOrd);
        union.union((Sketch)sketchInHeap);
        union.union((Sketch)sketchInDirectUnord);
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)16.0, (double)0.0);
    }

    @Test
    public void checkUnorderedAndOrderedMemory() {
        int k = 16;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[152]);
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            sketch.update((long)i);
        }
        CompactSketch sketchInDirectOrd = sketch.compact(false, mem);
        Assert.assertFalse((boolean)sketchInDirectOrd.isOrdered());
        Union union = Sketches.setOperationBuilder().setNominalEntries(16).buildUnion();
        union.union((Sketch)sketchInDirectOrd);
        double est1 = union.getResult().getEstimate();
        sketch.compact(true, mem);
        Assert.assertTrue((boolean)sketchInDirectOrd.isOrdered());
        union.union((Sketch)sketchInDirectOrd);
        double est2 = union.getResult().getEstimate();
        Assert.assertEquals((double)est1, (double)est2);
        Assert.assertEquals((int)((int)est1), (int)16);
    }

    @Test
    public void checkUpdateWithMem() {
        int k = 16;
        WritableMemory skMem = WritableMemory.writableWrap((byte[])new byte[280]);
        WritableMemory dirOrdCskMem = WritableMemory.writableWrap((byte[])new byte[152]);
        WritableMemory dirUnordCskMem = WritableMemory.writableWrap((byte[])new byte[152]);
        UpdateSketch udSketch = UpdateSketch.builder().setNominalEntries(16).build(skMem);
        for (int i = 0; i < 16; ++i) {
            udSketch.update((long)i);
        }
        udSketch.compact(true, dirOrdCskMem);
        udSketch.compact(false, dirUnordCskMem);
        Union union = Sketches.setOperationBuilder().setNominalEntries(16).buildUnion();
        union.union((Memory)skMem);
        union.union((Memory)dirOrdCskMem);
        union.union((Memory)dirUnordCskMem);
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)16.0, (double)0.0);
    }

    @Test
    public void checkUpdateWithMemV4Exact() {
        int n = 1000;
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        for (int i = 0; i < n; ++i) {
            sk.update((long)i);
        }
        CompactSketch cs = sk.compact();
        Assert.assertFalse((boolean)cs.isEstimationMode());
        byte[] bytes = cs.toByteArrayCompressed();
        Union union = Sketches.setOperationBuilder().buildUnion();
        union.union(Memory.wrap((byte[])bytes));
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)n, (double)0.0);
    }

    @Test
    public void checkFastWrap() {
        int k = 16;
        long seed = 9001L;
        int unionSize = Sketches.getMaxUnionBytes((int)16);
        WritableMemory srcMem = WritableMemory.writableWrap((byte[])new byte[unionSize]);
        Union union = Sketches.setOperationBuilder().setNominalEntries(16).buildUnion(srcMem);
        for (int i = 0; i < 16; ++i) {
            union.update((long)i);
        }
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)16.0, (double)0.0);
        UnionImpl union2 = UnionImpl.fastWrap((WritableMemory)srcMem, (long)9001L);
        Assert.assertEquals((double)union2.getResult().getEstimate(), (double)16.0, (double)0.0);
        WritableMemory srcMemR = srcMem;
        UnionImpl union3 = UnionImpl.fastWrap((Memory)srcMemR, (long)9001L);
        Assert.assertEquals((double)union3.getResult().getEstimate(), (double)16.0, (double)0.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCorruptFamilyException() {
        int k = 16;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[152]);
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            sketch.update((long)i);
        }
        sketch.compact(true, mem);
        mem.putByte(2L, (byte)0);
        Union union = Sketches.setOperationBuilder().setNominalEntries(16).buildUnion();
        union.union((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkVer2FamilyException() {
        int k = 16;
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            sketch.update((long)i);
        }
        CompactSketch csk = sketch.compact(true, null);
        WritableMemory v2mem = (WritableMemory)BackwardConversions.convertSerVer3toSerVer2(csk, 9001L);
        v2mem.putByte(2L, (byte)0);
        Union union = Sketches.setOperationBuilder().setNominalEntries(16).buildUnion();
        union.union((Memory)v2mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkVer1FamilyException() {
        int k = 16;
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            sketch.update((long)i);
        }
        CompactSketch csk = sketch.compact(true, null);
        WritableMemory v1mem = (WritableMemory)BackwardConversions.convertSerVer3toSerVer1(csk);
        v1mem.putByte(2L, (byte)0);
        Union union = Sketches.setOperationBuilder().setNominalEntries(16).buildUnion();
        union.union((Memory)v1mem);
    }

    @Test
    public void checkVer2EmptyHandling() {
        int k = 16;
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(16).build();
        Memory mem = BackwardConversions.convertSerVer3toSerVer2(sketch.compact(), 9001L);
        Union union = Sketches.setOperationBuilder().setNominalEntries(16).buildUnion();
        union.union(mem);
    }

    @Test
    public void checkMoveAndResizeOffHeap() {
        WritableMemory wmem2;
        WritableMemory wmem;
        int k = 4096;
        int u = 8192;
        int bytes = Sketches.getMaxUpdateSketchBytes((int)4096);
        ResourceScope scope = ResourceScope.newConfinedScope();
        WritableMemory wmemA = wmem = WritableMemory.allocateDirect((long)(bytes / 2), (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)new DefaultMemoryRequestServer());
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(4096).build(wmem);
        Assert.assertTrue((boolean)sketch.isSameResource((Memory)wmem));
        WritableMemory wmemB = wmem2 = WritableMemory.allocateDirect((long)(bytes / 2), (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)new DefaultMemoryRequestServer());
        Union union = SetOperation.builder().buildUnion(wmem2);
        Assert.assertTrue((boolean)union.isSameResource((Memory)wmem2));
        for (int i = 0; i < 8192; ++i) {
            union.update((long)i);
        }
        Assert.assertFalse((boolean)union.isSameResource((Memory)wmem));
        Union union2 = SetOperation.builder().buildUnion();
        Assert.assertFalse((boolean)union2.isSameResource((Memory)wmem2));
        Assert.assertFalse((boolean)wmemA.isAlive());
        Assert.assertFalse((boolean)wmemB.isAlive());
    }

    @Test
    public void checkRestricted() {
        Union union = Sketches.setOperationBuilder().buildUnion();
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertEquals((long)union.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((short)union.getSeedHash(), (short)ThetaUtil.computeSeedHash((long)9001L));
        Assert.assertEquals((int)union.getRetainedEntries(), (int)0);
        Assert.assertEquals((int)union.getCache().length, (int)128);
    }

    @Test
    public void checkUnionCompactOrderedSource() {
        int lgK = 12;
        int k = 4096;
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        for (int i = 0; i < 4096; ++i) {
            sk.update((long)i);
        }
        double est1 = sk.getEstimate();
        int bytes = Sketches.getCompactSketchMaxBytes((int)12);
        try {
            WritableMemory wmem = WritableMemory.allocateDirect((long)bytes);
            try (ResourceScope scope = wmem.scope();){
                CompactSketch csk = sk.compact(true, wmem);
                Union union = Sketches.setOperationBuilder().buildUnion();
                union.union((Sketch)csk);
                double est2 = union.getResult().getEstimate();
                Assert.assertEquals((double)est2, (double)est1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCompactFlagCorruption() {
        int k = 4096;
        int bytes = Sketch.getMaxUpdateSketchBytes((int)4096);
        WritableMemory wmem1 = WritableMemory.allocate((int)bytes);
        UpdateSketch sk = Sketches.updateSketchBuilder().setNominalEntries(4096).build(wmem1);
        for (int i = 0; i < 4096; ++i) {
            sk.update((long)i);
        }
        sk.compact(true, wmem1);
        Union union = SetOperation.builder().buildUnion();
        union.union((Sketch)sk);
        CompactSketch csk1 = union.getResult();
        UnionImplTest.println("" + csk1.getEstimate());
    }

    @Test
    public void checkDirectUnionSingleItem() {
        int i;
        int i2;
        int num = 2;
        UpdateSketch[] skArr = new UpdateSketch[2];
        for (i2 = 0; i2 < 2; ++i2) {
            skArr[i2] = new UpdateSketchBuilder().build();
        }
        for (i2 = 0; i2 < 1; ++i2) {
            skArr[i2].update((long)i2);
            skArr[i2 + 1].update((long)i2);
            skArr[i2].update((long)(i2 + 2));
        }
        Union union = new SetOperationBuilder().buildUnion();
        for (int i3 = 0; i3 < 2; ++i3) {
            union.union((Sketch)skArr[i3]);
        }
        CompactSketch csk = union.getResult();
        Assert.assertEquals((double)csk.getEstimate(), (double)2.0);
        Memory[] memArr = new Memory[2];
        for (i = 0; i < 2; ++i) {
            memArr[i] = Memory.wrap((byte[])skArr[i].compact().toByteArray());
        }
        union = new SetOperationBuilder().buildUnion();
        for (i = 0; i < 2; ++i) {
            union.union(memArr[i]);
        }
        csk = union.getResult();
        Assert.assertEquals((double)csk.getEstimate(), (double)2.0);
    }

    @Test
    public void printlnTest() {
        UnionImplTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
    }
}

