/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hash;

import java.io.Serializable;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;

public final class MurmurHash3
implements Serializable {
    private static final long serialVersionUID = 0L;

    private MurmurHash3() {
    }

    public static long[] hash(long key, long seed) {
        HashState hashState = new HashState(seed, seed);
        return hashState.finalMix128(key, 0L, 8L);
    }

    public static long[] hash(long[] key, long seed) {
        return MurmurHash3.hash(key, 0, key.length, seed);
    }

    public static long[] hash(long[] key, int offsetLongs, int lengthLongs, long seed) {
        Objects.requireNonNull(key);
        int arrLen = key.length;
        MurmurHash3.checkPositive(arrLen);
        Util.checkBounds(offsetLongs, lengthLongs, arrLen);
        HashState hashState = new HashState(seed, seed);
        int nblocks = lengthLongs >>> 1;
        for (int i = 0; i < nblocks; ++i) {
            long k1 = key[offsetLongs + (i << 1)];
            long k2 = key[offsetLongs + (i << 1) + 1];
            hashState.blockMix128(k1, k2);
        }
        int tail = nblocks << 1;
        int rem = lengthLongs - tail;
        long k1 = rem == 0 ? 0L : key[offsetLongs + tail];
        return hashState.finalMix128(k1, 0L, lengthLongs << 3);
    }

    public static long[] hash(int[] key, long seed) {
        return MurmurHash3.hash(key, 0, key.length, seed);
    }

    public static long[] hash(int[] key, int offsetInts, int lengthInts, long seed) {
        long k2;
        long k1;
        Objects.requireNonNull(key);
        int arrLen = key.length;
        MurmurHash3.checkPositive(arrLen);
        Util.checkBounds(offsetInts, lengthInts, arrLen);
        HashState hashState = new HashState(seed, seed);
        int nblocks = lengthInts >>> 2;
        for (int i = 0; i < nblocks; ++i) {
            long k12 = MurmurHash3.getLong(key, offsetInts + (i << 2), 2);
            long k22 = MurmurHash3.getLong(key, offsetInts + (i << 2) + 2, 2);
            hashState.blockMix128(k12, k22);
        }
        int tail = nblocks << 2;
        int rem = lengthInts - tail;
        if (rem > 2) {
            k1 = MurmurHash3.getLong(key, offsetInts + tail, 2);
            k2 = MurmurHash3.getLong(key, offsetInts + tail + 2, rem - 2);
        } else {
            k1 = rem == 0 ? 0L : MurmurHash3.getLong(key, offsetInts + tail, rem);
            k2 = 0L;
        }
        return hashState.finalMix128(k1, k2, lengthInts << 2);
    }

    public static long[] hash(char[] key, long seed) {
        return MurmurHash3.hash(key, 0, key.length, seed);
    }

    public static long[] hash(char[] key, int offsetChars, int lengthChars, long seed) {
        long k2;
        long k1;
        Objects.requireNonNull(key);
        int arrLen = key.length;
        MurmurHash3.checkPositive(arrLen);
        Util.checkBounds(offsetChars, lengthChars, arrLen);
        HashState hashState = new HashState(seed, seed);
        int nblocks = lengthChars >>> 3;
        for (int i = 0; i < nblocks; ++i) {
            long k12 = MurmurHash3.getLong(key, offsetChars + (i << 3), 4);
            long k22 = MurmurHash3.getLong(key, offsetChars + (i << 3) + 4, 4);
            hashState.blockMix128(k12, k22);
        }
        int tail = nblocks << 3;
        int rem = lengthChars - tail;
        if (rem > 4) {
            k1 = MurmurHash3.getLong(key, offsetChars + tail, 4);
            k2 = MurmurHash3.getLong(key, offsetChars + tail + 4, rem - 4);
        } else {
            k1 = rem == 0 ? 0L : MurmurHash3.getLong(key, offsetChars + tail, rem);
            k2 = 0L;
        }
        return hashState.finalMix128(k1, k2, lengthChars << 1);
    }

    public static long[] hash(byte[] key, long seed) {
        return MurmurHash3.hash(key, 0, key.length, seed);
    }

    public static long[] hash(byte[] key, int offsetBytes, int lengthBytes, long seed) {
        long k2;
        long k1;
        Objects.requireNonNull(key);
        int arrLen = key.length;
        MurmurHash3.checkPositive(arrLen);
        Util.checkBounds(offsetBytes, lengthBytes, arrLen);
        HashState hashState = new HashState(seed, seed);
        int nblocks = lengthBytes >>> 4;
        for (int i = 0; i < nblocks; ++i) {
            long k12 = MurmurHash3.getLong(key, offsetBytes + (i << 4), 8);
            long k22 = MurmurHash3.getLong(key, offsetBytes + (i << 4) + 8, 8);
            hashState.blockMix128(k12, k22);
        }
        int tail = nblocks << 4;
        int rem = lengthBytes - tail;
        if (rem > 8) {
            k1 = MurmurHash3.getLong(key, offsetBytes + tail, 8);
            k2 = MurmurHash3.getLong(key, offsetBytes + tail + 8, rem - 8);
        } else {
            k1 = rem == 0 ? 0L : MurmurHash3.getLong(key, offsetBytes + tail, rem);
            k2 = 0L;
        }
        return hashState.finalMix128(k1, k2, lengthBytes);
    }

    public static long[] hash(ByteBuffer buf, long seed) {
        Objects.requireNonNull(buf);
        MemorySegment bbSeg = MemorySegment.ofBuffer(buf);
        return MurmurHash3.hash(bbSeg, seed);
    }

    public static long[] hash(MemorySegment seg, long seed) {
        long k2;
        long k1;
        Objects.requireNonNull(seg);
        long lengthBytes = seg.byteSize();
        MurmurHash3.checkPositive(lengthBytes);
        HashState hashState = new HashState(seed, seed);
        long nblocks = lengthBytes >>> 4;
        for (long i = 0L; i < nblocks; ++i) {
            long k12 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, i << 4);
            long k22 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (i << 4) + 8L);
            hashState.blockMix128(k12, k22);
        }
        long tail = nblocks << 4;
        int rem = (int)(lengthBytes - tail);
        if (rem > 8) {
            k1 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, tail);
            k2 = MurmurHash3.getLong(seg, tail + 8L, rem - 8);
        } else {
            k1 = rem == 0 ? 0L : MurmurHash3.getLong(seg, tail, rem);
            k2 = 0L;
        }
        return hashState.finalMix128(k1, k2, lengthBytes);
    }

    private static long getLong(int[] intArr, int index, int rem) {
        long out = 0L;
        int i = rem;
        while (i-- > 0) {
            int v = intArr[index + i];
            out ^= ((long)v & 0xFFFFFFFFL) << i * 32;
        }
        return out;
    }

    private static long getLong(char[] charArr, int index, int rem) {
        long out = 0L;
        int i = rem;
        while (i-- > 0) {
            char c = charArr[index + i];
            out ^= ((long)c & 0xFFFFL) << i * 16;
        }
        return out;
    }

    private static long getLong(byte[] bArr, int index, int rem) {
        long out = 0L;
        int i = rem;
        while (i-- > 0) {
            byte b = bArr[index + i];
            out ^= ((long)b & 0xFFL) << i * 8;
        }
        return out;
    }

    private static long getLong(MemorySegment seg, long offsetBytes, int rem) {
        long out = 0L;
        if (rem == 8) {
            return seg.get(ValueLayout.JAVA_LONG_UNALIGNED, offsetBytes);
        }
        int i = rem;
        while (i-- > 0) {
            byte b = seg.get(ValueLayout.JAVA_BYTE, offsetBytes + (long)i);
            out ^= ((long)b & 0xFFL) << (i << 3);
        }
        return out;
    }

    private static void checkPositive(long size) {
        if (size <= 0L) {
            throw new SketchesArgumentException("Array size must not be negative or zero: " + size);
        }
    }

    private static final class HashState {
        private static final long C1 = -8663945395140668459L;
        private static final long C2 = 5545529020109919103L;
        private long h1;
        private long h2;

        HashState(long h1, long h2) {
            this.h1 = h1;
            this.h2 = h2;
        }

        void blockMix128(long k1, long k2) {
            this.h1 ^= HashState.mixK1(k1);
            this.h1 = Long.rotateLeft(this.h1, 27);
            this.h1 += this.h2;
            this.h1 = this.h1 * 5L + 1390208809L;
            this.h2 ^= HashState.mixK2(k2);
            this.h2 = Long.rotateLeft(this.h2, 31);
            this.h2 += this.h1;
            this.h2 = this.h2 * 5L + 944331445L;
        }

        long[] finalMix128(long k1, long k2, long inputLengthBytes) {
            this.h1 ^= HashState.mixK1(k1);
            this.h2 ^= HashState.mixK2(k2);
            this.h1 ^= inputLengthBytes;
            this.h2 ^= inputLengthBytes;
            this.h1 += this.h2;
            this.h2 += this.h1;
            this.h1 = HashState.finalMix64(this.h1);
            this.h2 = HashState.finalMix64(this.h2);
            this.h1 += this.h2;
            this.h2 += this.h1;
            return new long[]{this.h1, this.h2};
        }

        private static long finalMix64(long h) {
            h ^= h >>> 33;
            h *= -49064778989728563L;
            h ^= h >>> 33;
            h *= -4265267296055464877L;
            h ^= h >>> 33;
            return h;
        }

        private static long mixK1(long k1) {
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            return k1 *= 5545529020109919103L;
        }

        private static long mixK2(long k2) {
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            return k2 *= -8663945395140668459L;
        }
    }
}

