/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.SuppressFBWarnings;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.ConcurrentDirectQuickSelectSketch;
import org.apache.datasketches.theta.ConcurrentHeapQuickSelectSketch;
import org.apache.datasketches.theta.ConcurrentHeapThetaBuffer;
import org.apache.datasketches.theta.ConcurrentPropagationService;
import org.apache.datasketches.theta.ConcurrentSharedThetaSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.HeapAlphaSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.thetacommon.ThetaUtil;

public final class UpdatableThetaSketchBuilder {
    private int bLgNomLongs = Integer.numberOfTrailingZeros(4096);
    private long bSeed = 9001L;
    private ResizeFactor bRF = ResizeFactor.X8;
    private Family bFam = Family.QUICKSELECT;
    private float bP = 1.0f;
    private MemorySegmentRequest bMemorySegmentRequest = null;
    private int bNumPoolThreads = ConcurrentPropagationService.NUM_POOL_THREADS;
    private int bConCurLgNomLongs = 4;
    private boolean bPropagateOrderedCompact = true;
    private double bMaxConcurrencyError = 0.0;
    private int bMaxNumLocalThreads = 1;

    public UpdatableThetaSketchBuilder setNominalEntries(int nomEntries) {
        this.bLgNomLongs = ThetaUtil.checkNomLongs(nomEntries);
        return this;
    }

    public UpdatableThetaSketchBuilder setLogNominalEntries(int lgNomEntries) {
        this.bLgNomLongs = ThetaUtil.checkNomLongs(1 << lgNomEntries);
        return this;
    }

    public UpdatableThetaSketchBuilder setLgK(int lgK) {
        this.bLgNomLongs = ThetaUtil.checkNomLongs(1 << lgK);
        return this;
    }

    public int getLgNominalEntries() {
        return this.bLgNomLongs;
    }

    public UpdatableThetaSketchBuilder setConCurNominalEntries(int nomEntries) {
        this.bConCurLgNomLongs = Integer.numberOfTrailingZeros(Util.ceilingPowerOf2(nomEntries));
        if (this.bConCurLgNomLongs > 26 || this.bConCurLgNomLongs < 4) {
            throw new SketchesArgumentException("Nominal Entries must be >= 16 and <= 67108864: " + nomEntries);
        }
        return this;
    }

    public UpdatableThetaSketchBuilder setConCurLogNominalEntries(int lgNomEntries) {
        this.bConCurLgNomLongs = lgNomEntries;
        if (this.bConCurLgNomLongs > 26 || this.bConCurLgNomLongs < 4) {
            throw new SketchesArgumentException("Log Nominal Entries must be >= 4 and <= 26: " + lgNomEntries);
        }
        return this;
    }

    public int getConCurLgNominalEntries() {
        return this.bConCurLgNomLongs;
    }

    public UpdatableThetaSketchBuilder setSeed(long seed) {
        this.bSeed = seed;
        return this;
    }

    public long getSeed() {
        return this.bSeed;
    }

    public UpdatableThetaSketchBuilder setP(float p) {
        if ((double)p <= 0.0 || (double)p > 1.0) {
            throw new SketchesArgumentException("p must be > 0 and <= 1.0: " + p);
        }
        this.bP = p;
        return this;
    }

    public float getP() {
        return this.bP;
    }

    public UpdatableThetaSketchBuilder setResizeFactor(ResizeFactor rf) {
        this.bRF = rf;
        return this;
    }

    public ResizeFactor getResizeFactor() {
        return this.bRF;
    }

    public UpdatableThetaSketchBuilder setFamily(Family family) {
        this.bFam = family;
        return this;
    }

    public Family getFamily() {
        return this.bFam;
    }

    public UpdatableThetaSketchBuilder setMemorySegmentRequest(MemorySegmentRequest mSegReq) {
        this.bMemorySegmentRequest = mSegReq;
        return this;
    }

    public MemorySegmentRequest getMemorySegmentRequest() {
        return this.bMemorySegmentRequest;
    }

    public void setNumPoolThreads(int numPoolThreads) {
        this.bNumPoolThreads = numPoolThreads;
    }

    public int getNumPoolThreads() {
        return this.bNumPoolThreads;
    }

    public UpdatableThetaSketchBuilder setPropagateOrderedCompact(boolean prop) {
        this.bPropagateOrderedCompact = prop;
        return this;
    }

    public boolean getPropagateOrderedCompact() {
        return this.bPropagateOrderedCompact;
    }

    public void setMaxConcurrencyError(double maxConcurrencyError) {
        this.bMaxConcurrencyError = maxConcurrencyError;
    }

    public double getMaxConcurrencyError() {
        return this.bMaxConcurrencyError;
    }

    public void setMaxNumLocalThreads(int maxNumLocalThreads) {
        this.bMaxNumLocalThreads = maxNumLocalThreads;
    }

    public int getMaxNumLocalThreads() {
        return this.bMaxNumLocalThreads;
    }

    public UpdatableThetaSketch build() {
        return this.build(null);
    }

    public UpdatableThetaSketch build(MemorySegment dstSeg) {
        UpdatableThetaSketch sketch = null;
        boolean unionGadget = false;
        switch (this.bFam) {
            case ALPHA: {
                if (dstSeg == null) {
                    sketch = HeapAlphaSketch.newHeapInstance(this.bLgNomLongs, this.bSeed, this.bP, this.bRF);
                    break;
                }
                throw new SketchesArgumentException("AlphaSketch cannot be backed by a MemorySegment.");
            }
            case QUICKSELECT: {
                if (dstSeg == null) {
                    sketch = new HeapQuickSelectSketch(this.bLgNomLongs, this.bSeed, this.bP, this.bRF, false);
                    break;
                }
                sketch = new DirectQuickSelectSketch(this.bLgNomLongs, this.bSeed, this.bP, this.bRF, dstSeg, this.bMemorySegmentRequest, false);
                break;
            }
            default: {
                throw new SketchesArgumentException("Given Family cannot be built as an UpdatableThetaSketch: " + this.bFam.toString());
            }
        }
        return sketch;
    }

    public UpdatableThetaSketch buildShared() {
        return this.buildShared(null);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Harmless in Builder, fix later")
    public UpdatableThetaSketch buildShared(MemorySegment dstSeg) {
        ConcurrentPropagationService.NUM_POOL_THREADS = this.bNumPoolThreads;
        if (dstSeg == null) {
            return new ConcurrentHeapQuickSelectSketch(this.bLgNomLongs, this.bSeed, this.bMaxConcurrencyError);
        }
        return new ConcurrentDirectQuickSelectSketch(this.bLgNomLongs, this.bSeed, this.bMaxConcurrencyError, dstSeg);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Harmless in Builder, fix later")
    public UpdatableThetaSketch buildSharedFromSketch(UpdatableThetaSketch sketch, MemorySegment dstSeg) {
        ConcurrentPropagationService.NUM_POOL_THREADS = this.bNumPoolThreads;
        if (dstSeg == null) {
            return new ConcurrentHeapQuickSelectSketch(sketch, this.bSeed, this.bMaxConcurrencyError);
        }
        return new ConcurrentDirectQuickSelectSketch(sketch, this.bSeed, this.bMaxConcurrencyError, dstSeg);
    }

    public UpdatableThetaSketch buildLocal(UpdatableThetaSketch shared) {
        if (shared == null || !(shared instanceof ConcurrentSharedThetaSketch)) {
            throw new SketchesStateException("The concurrent shared sketch must be built first.");
        }
        return new ConcurrentHeapThetaBuffer(this.bConCurLgNomLongs, this.bSeed, (ConcurrentSharedThetaSketch)((Object)shared), this.bPropagateOrderedCompact, this.bMaxNumLocalThreads);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdatableThetaSketchBuilder configuration:").append(Util.LS);
        sb.append("LgK:").append('\t').append(this.bLgNomLongs).append(Util.LS);
        sb.append("K:").append('\t').append(1 << this.bLgNomLongs).append(Util.LS);
        sb.append("LgLocalK:").append('\t').append(this.bConCurLgNomLongs).append(Util.LS);
        sb.append("LocalK:").append('\t').append(1 << this.bConCurLgNomLongs).append(Util.LS);
        sb.append("Seed:").append('\t').append(this.bSeed).append(Util.LS);
        sb.append("p:").append('\t').append(this.bP).append(Util.LS);
        sb.append("ResizeFactor:").append('\t').append((Object)this.bRF).append(Util.LS);
        sb.append("Family:").append('\t').append((Object)this.bFam).append(Util.LS);
        sb.append("Propagate Ordered Compact").append('\t').append(this.bPropagateOrderedCompact).append(Util.LS);
        sb.append("NumPoolThreads").append('\t').append(this.bNumPoolThreads).append(Util.LS);
        sb.append("MaxConcurrencyError").append('\t').append(this.bMaxConcurrencyError).append(Util.LS);
        sb.append("MaxNumLocalThreads").append('\t').append(this.bMaxNumLocalThreads).append(Util.LS);
        return sb.toString();
    }
}

