/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.factory;

import java.util.Iterator;
import java.util.List;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.factory.Messagefactory;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.ApproximateNode;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.ExtensibleNode;
import org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.filter.SimpleNode;
import org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.util.Strings;

public final class SearchRequestFactory
implements Messagefactory {
    public static final SearchRequestFactory INSTANCE = new SearchRequestFactory();

    private SearchRequestFactory() {
    }

    private void encodeFilters(Asn1Buffer buffer, Iterator<ExprNode> children) {
        if (children.hasNext()) {
            ExprNode child = children.next();
            this.encodeFilters(buffer, children);
            this.encodeFilter(buffer, child);
        }
    }

    private void encodeFilter(Asn1Buffer buffer, BranchNode node, byte tag) {
        int start = buffer.getPos();
        List<ExprNode> children = node.getChildren();
        if (children != null && !children.isEmpty()) {
            this.encodeFilters(buffer, children.iterator());
        }
        BerValue.encodeSequence(buffer, tag, start);
    }

    private void encodeFilter(Asn1Buffer buffer, SimpleNode<?> node, byte tag) {
        int start = buffer.getPos();
        BerValue.encodeOctetString(buffer, node.getValue().getBytes());
        BerValue.encodeOctetString(buffer, node.getAttribute());
        BerValue.encodeSequence(buffer, tag, start);
    }

    private void encodeFilter(Asn1Buffer buffer, PresenceNode node) {
        BerValue.encodeOctetString(buffer, (byte)-121, Strings.getBytesUtf8(node.getAttribute()));
    }

    private void encodeFilter(Asn1Buffer buffer, SubstringNode node) {
        List<String> any;
        int start = buffer.getPos();
        if (node.getFinal() != null) {
            BerValue.encodeOctetString(buffer, (byte)-126, Strings.getBytesUtf8(node.getFinal()));
        }
        if ((any = node.getAny()) != null) {
            for (int i = any.size(); i > 0; --i) {
                BerValue.encodeOctetString(buffer, (byte)-127, Strings.getBytesUtf8(any.get(i - 1)));
            }
        }
        if (node.getInitial() != null) {
            BerValue.encodeOctetString(buffer, (byte)-128, Strings.getBytesUtf8(node.getInitial()));
        }
        BerValue.encodeSequence(buffer, start);
        BerValue.encodeOctetString(buffer, node.getAttribute());
        BerValue.encodeSequence(buffer, (byte)-92, start);
    }

    private void encodeFilter(Asn1Buffer buffer, ExtensibleNode node) {
        int start = buffer.getPos();
        if (node.hasDnAttributes()) {
            BerValue.encodeBoolean(buffer, (byte)-124, true);
        }
        if (node.getValue() != null) {
            BerValue.encodeOctetString(buffer, (byte)-125, node.getValue().getBytes());
        }
        if (node.getAttribute() != null) {
            BerValue.encodeOctetString(buffer, (byte)-126, Strings.getBytesUtf8(node.getAttribute()));
        }
        if (node.getMatchingRuleId() != null) {
            BerValue.encodeOctetString(buffer, (byte)-127, Strings.getBytesUtf8(node.getMatchingRuleId()));
        }
        BerValue.encodeSequence(buffer, (byte)-87, start);
    }

    private void encodeFilter(Asn1Buffer buffer, ExprNode node) {
        switch (node.getClass().getSimpleName()) {
            case "AndNode": {
                this.encodeFilter(buffer, (AndNode)node, (byte)-96);
                break;
            }
            case "ApproximateNode": {
                this.encodeFilter(buffer, (ApproximateNode)node, (byte)-88);
                break;
            }
            case "EqualityNode": {
                this.encodeFilter(buffer, (EqualityNode)node, (byte)-93);
                break;
            }
            case "ExtensibleNode": {
                this.encodeFilter(buffer, (ExtensibleNode)node);
                break;
            }
            case "GreaterEqNode": {
                this.encodeFilter(buffer, (GreaterEqNode)node, (byte)-91);
                break;
            }
            case "LessEqNode": {
                this.encodeFilter(buffer, (LessEqNode)node, (byte)-90);
                break;
            }
            case "NotNode": {
                this.encodeFilter(buffer, (NotNode)node, (byte)-94);
                break;
            }
            case "OrNode": {
                this.encodeFilter(buffer, (OrNode)node, (byte)-95);
                break;
            }
            case "PresenceNode": {
                this.encodeFilter(buffer, (PresenceNode)node);
                break;
            }
            case "SubstringNode": {
                this.encodeFilter(buffer, (SubstringNode)node);
                break;
            }
        }
    }

    @Override
    public void encodeReverse(LdapApiService codec, Asn1Buffer buffer, Message message) {
        int start = buffer.getPos();
        SearchRequest searchRequest = (SearchRequest)message;
        List<String> attributes = searchRequest.getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            for (int i = attributes.size(); i > 0; --i) {
                BerValue.encodeOctetString(buffer, attributes.get(i - 1));
            }
        }
        BerValue.encodeSequence(buffer, start);
        this.encodeFilter(buffer, searchRequest.getFilter());
        BerValue.encodeBoolean(buffer, searchRequest.getTypesOnly());
        BerValue.encodeInteger(buffer, searchRequest.getTimeLimit());
        BerValue.encodeInteger(buffer, searchRequest.getSizeLimit());
        BerValue.encodeEnumerated(buffer, searchRequest.getDerefAliases().getValue());
        BerValue.encodeEnumerated(buffer, searchRequest.getScope().getScope());
        BerValue.encodeOctetString(buffer, Strings.getBytesUtf8(searchRequest.getBase().getName()));
        BerValue.encodeSequence(buffer, (byte)99, start);
    }
}

