/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.builder;

import aQute.bnd.plugin.Activator;
import aQute.bnd.plugin.popup.actions.MakeBundle;
import aQute.lib.osgi.Builder;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class BndBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "biz.aQute.bnd.BndBuilder";
    private static final String MARKER_TYPE = "biz.aQute.bnd.xmlProblem";

    private void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    void checkBnd(IResource resource) {
        if (resource instanceof IFile && resource.getName().endsWith(".bnd")) {
            IFile file = (IFile)resource;
            this.deleteMarkers(file);
            try {
                Builder builder = MakeBundle.setBuilder(Activator.getDefault(), resource.getProject(), file.getLocation().toFile());
                try {
                    builder.build();
                    builder.close();
                }
                catch (Exception e1) {
                    this.addMarker(file, "Unexpected exception: " + e1, 1, 4);
                }
                Iterator<String> i = builder.getErrors().iterator();
                while (i.hasNext()) {
                    this.addMarker(file, i.next(), 1, 4);
                }
                i = builder.getWarnings().iterator();
                while (i.hasNext()) {
                    this.addMarker(file, i.next(), 1, 2);
                }
            }
            catch (Exception e) {
                this.addMarker(file, "Really bad exception: " + e, 1, 4);
            }
        }
    }

    private void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new ResourceVisitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new DeltaVisitor());
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    BndBuilder.this.checkBnd(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    BndBuilder.this.checkBnd(resource);
                }
            }
            return true;
        }
    }

    class ResourceVisitor
    implements IResourceVisitor {
        ResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            BndBuilder.this.checkBnd(resource);
            return true;
        }
    }
}

