/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMap<K, V>
extends HashMap<K, Set<V>> {
    private static final long serialVersionUID = 1L;
    final Set<V> EMPTY = Collections.emptySet();

    public boolean add(K key, V value) {
        HashSet<V> set = (HashSet<V>)this.get(key);
        if (set == null) {
            set = new HashSet<V>();
            this.put(key, set);
        }
        return set.add(value);
    }

    public boolean addAll(K key, Collection<V> value) {
        HashSet<V> set = (HashSet<V>)this.get(key);
        if (set == null) {
            set = new HashSet<V>();
            this.put(key, set);
        }
        return set.addAll(value);
    }

    @Override
    public boolean remove(K key, V value) {
        Set set = (Set)this.get(key);
        if (set == null) {
            return false;
        }
        boolean result = set.remove(value);
        if (set.isEmpty()) {
            this.remove(key);
        }
        return result;
    }

    public boolean removeAll(K key, Collection<V> value) {
        Set set = (Set)this.get(key);
        if (set == null) {
            return false;
        }
        boolean result = set.removeAll(value);
        if (set.isEmpty()) {
            this.remove(key);
        }
        return result;
    }

    public Iterator<V> iterate(K key) {
        Set set = (Set)this.get(key);
        if (set == null) {
            return this.EMPTY.iterator();
        }
        return set.iterator();
    }

    public Iterator<V> all() {
        return new Iterator<V>(){
            Iterator<Set<V>> master;
            Iterator<V> current;
            {
                this.master = MultiMap.this.values().iterator();
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                if (this.current == null || !this.current.hasNext()) {
                    if (this.master.hasNext()) {
                        this.current = this.master.next().iterator();
                        return this.current.hasNext();
                    }
                    return false;
                }
                return true;
            }

            @Override
            public V next() {
                return this.current.next();
            }

            @Override
            public void remove() {
                this.current.remove();
            }
        };
    }
}

