/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.remote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.shell.ShellService;
import org.apache.felix.shell.remote.AtomicInteger;
import org.apache.felix.shell.remote.Listener;
import org.apache.felix.shell.remote.ReentrantLock;
import org.apache.felix.shell.remote.ServiceMediator;
import org.apache.felix.shell.remote.TerminalPrintStream;
import org.apache.felix.shell.remote.TerminalReader;

class Shell
implements Runnable {
    private final Listener m_owner;
    private final Socket m_socket;
    private final AtomicInteger m_useCounter;
    private volatile TerminalPrintStream m_out;

    public Shell(Listener owner, Socket s, AtomicInteger counter) {
        this.m_owner = owner;
        this.m_socket = s;
        this.m_useCounter = counter;
    }

    void terminate() {
        this.exit("\r\nFelix Remote Shell Console Terminating");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_owner.registerConnection(this);
        String msg = null;
        try {
            this.m_out = new TerminalPrintStream(this.m_owner.getServices(), this.m_socket.getOutputStream());
            Object obj = null;
            obj = this.m_owner.getServices().getCommandProcessor(ServiceMediator.NO_WAIT);
            if (obj != null) {
                CommandProcessor cp = (CommandProcessor)obj;
                CommandSession session = cp.createSession(this.m_socket.getInputStream(), (PrintStream)this.m_out, (PrintStream)this.m_out);
                this.startGogoShell(session);
            } else {
                obj = this.m_owner.getServices().getShellService(ServiceMediator.NO_WAIT);
                if (obj != null) {
                    this.startFelixShell();
                } else {
                    msg = "No shell services available...exiting.";
                }
            }
            this.exit(msg);
        }
        catch (IOException ex) {
            this.m_owner.getServices().error("Shell::run()", ex);
        }
        finally {
            this.exit(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startGogoShell(CommandSession session) {
        try {
            session.execute((CharSequence)"gosh --login --noshutdown");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFelixShell() throws IOException {
        BufferedReader in = new BufferedReader(new TerminalReader(this.m_socket.getInputStream(), this.m_out));
        ReentrantLock lock = new ReentrantLock();
        this.m_out.println();
        this.m_out.println("Felix Remote Shell Console:");
        this.m_out.println("============================");
        this.m_out.println("");
        while (true) {
            String line = "";
            try {
                this.m_out.print("-> ");
                line = in.readLine();
                if (line == null) {
                    this.m_out.println("exit");
                    return;
                }
            }
            catch (Exception ex) {
                return;
            }
            line = line.trim();
            if (line.equalsIgnoreCase("exit") || line.equalsIgnoreCase("disconnect")) {
                return;
            }
            ShellService shs = (ShellService)this.m_owner.getServices().getShellService(ServiceMediator.NO_WAIT);
            try {
                lock.acquire();
                shs.executeCommand(line, (PrintStream)this.m_out, (PrintStream)this.m_out);
                continue;
            }
            catch (Exception ex) {
                this.m_owner.getServices().error("Shell::run()", ex);
                continue;
            }
            finally {
                lock.release();
                continue;
            }
            break;
        }
    }

    private void exit(String message) {
        if (message != null) {
            this.m_out.println(message);
        }
        this.m_out.println("Good Bye!");
        this.m_out.close();
        try {
            this.m_socket.close();
        }
        catch (IOException ex) {
            this.m_owner.getServices().error("Shell::exit()", ex);
        }
        this.m_owner.unregisterConnection(this);
        this.m_useCounter.decrement();
    }
}

