/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.net.InetAddress;
import java.util.Vector;
import org.cybergarage.net.HostInterface;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.ssdp.SSDPNotifySocket;

public class SSDPNotifySocketList
extends Vector {
    private InetAddress[] binds = null;

    public SSDPNotifySocketList() {
    }

    public SSDPNotifySocketList(InetAddress[] binds) {
        this.binds = binds;
    }

    public SSDPNotifySocket getSSDPNotifySocket(int n) {
        return (SSDPNotifySocket)this.get(n);
    }

    public void setControlPoint(ControlPoint ctrlPoint) {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPNotifySocket sock = this.getSSDPNotifySocket(n);
            sock.setControlPoint(ctrlPoint);
        }
    }

    public boolean open() {
        int i;
        String[] bindAddresses;
        InetAddress[] binds = this.binds;
        if (binds != null) {
            bindAddresses = new String[binds.length];
            for (i = 0; i < binds.length; ++i) {
                bindAddresses[i] = binds[i].getHostAddress();
            }
        } else {
            int nHostAddrs = HostInterface.getNHostAddresses();
            bindAddresses = new String[nHostAddrs];
            for (int n = 0; n < nHostAddrs; ++n) {
                bindAddresses[n] = HostInterface.getHostAddress(n);
            }
        }
        for (i = 0; i < bindAddresses.length; ++i) {
            if (bindAddresses[i] == null) continue;
            SSDPNotifySocket ssdpNotifySocket = new SSDPNotifySocket(bindAddresses[i]);
            this.add(ssdpNotifySocket);
        }
        return true;
    }

    public void close() {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPNotifySocket sock = this.getSSDPNotifySocket(n);
            sock.close();
        }
        this.clear();
    }

    public void start() {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPNotifySocket sock = this.getSSDPNotifySocket(n);
            sock.start();
        }
    }

    public void stop() {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPNotifySocket sock = this.getSSDPNotifySocket(n);
            sock.stop();
        }
    }
}

